/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.server;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.config.ConfigHolder;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.InitRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BaseEventRespond;
import com.zkteco.zkbiosecurity.cuserver.enums.EventTypeEnum;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@ServerEndpoint(value="/websocket")
@Component
public class WebSocketServer {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServer.class);
    private static final CopyOnWriteArraySet<WebSocketServer> WEB_SOCKET_SET = new CopyOnWriteArraySet();
    private Session session;

    @OnOpen
    public void onOpen(Session session) {
        log.info("send to {},session:{}", (Object)this.getIPInfo(session), (Object)session.getId());
        int maxSize = 204800;
        session.setMaxTextMessageBufferSize(maxSize);
        this.session = session;
        WEB_SOCKET_SET.add(this);
    }

    @OnClose
    public void onClose() {
        try {
            InetSocketAddress addr = (InetSocketAddress)WebSocketServer.getFieldInstance((Object)this.session.getAsyncRemote(), (String)"base#socketWrapper#socket#sc#remoteAddress");
            String address = Objects.nonNull(addr) ? addr.getAddress().toString() : "";
            log.info("ws connection is closed:{},session:{}", (Object)address, (Object)this.session.getId());
        }
        catch (Exception e) {
            log.info("ws connection is closed err session:{}", (Object)this.session.getId());
        }
        WEB_SOCKET_SET.remove(this);
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        log.info("Receive message:{}", (Object)message);
        try {
            JSONObject data = JSONObject.parseObject((String)message);
            if ("init".equals(data.getString("type")) && "CuServerConfig".equals(data.getString("subType"))) {
                InitRequest request = (InitRequest)JSONObject.parseObject((String)data.getString("data"), InitRequest.class);
                ConfigHolder.set((InitRequest)request);
            }
        }
        catch (Exception e) {
            log.error("parse websocket message error", (Throwable)e);
        }
    }

    @OnError
    public void onError(Session session, Throwable error) {
        WEB_SOCKET_SET.remove(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(WebSocketServer item, BaseEventRespond baseEventRespond) throws IOException {
        if (ConfigHolder.isDebugLog()) {
            log.info("send to {},session:{},msg:{}", new Object[]{this.getIPInfo(item.session), item.session.getId(), baseEventRespond.toJSON()});
        }
        String string = item.session.getId();
        synchronized (string) {
            if (item.session.isOpen()) {
                item.session.getBasicRemote().sendText(baseEventRespond.toJSON());
            } else {
                log.info("websocket is closed, IP:{},sessionId:{}", (Object)this.getIPInfo(item.session), (Object)item.session.getId());
            }
        }
    }

    private static Object getFieldInstance(Object obj, String fieldPath) {
        String[] fields;
        for (String field : fields = fieldPath.split("#")) {
            if ((obj = WebSocketServer.getField((Object)obj, obj.getClass(), (String)field)) != null) continue;
            return null;
        }
        return obj;
    }

    private static Object getField(Object obj, Class<?> clazz, String fieldName) {
        while (clazz != Object.class) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field.get(obj);
            }
            catch (Exception exception) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    public void sendTo(BaseEventRespond baseEventRespond) {
        for (WebSocketServer item : WEB_SOCKET_SET) {
            try {
                item.sendMessage(item, baseEventRespond);
            }
            catch (IOException e) {
                log.error("send message error, domainCode:" + baseEventRespond.getDomainCode() + ",channelCode:" + baseEventRespond.getChannelCode() + ",IP:" + this.getIPInfo(item.session), (Throwable)e);
            }
        }
    }

    @Scheduled(cron="*/10 * * * * ?")
    public void heartBeat() {
        BaseEventRespond baseEventRespond = new BaseEventRespond();
        baseEventRespond.setType(EventTypeEnum.HEART_BEAT);
        baseEventRespond.setTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        if (ConfigHolder.isDebugLog()) {
            for (WebSocketServer item : WEB_SOCKET_SET) {
                log.info("webSocket client session:{} ,address:{}", (Object)item.session.getId(), (Object)this.getIPInfo(item.session));
            }
        }
        this.sendTo(baseEventRespond);
    }

    private String getIPInfo(Session session) {
        try {
            InetSocketAddress addr = null;
            if (session.isOpen()) {
                RemoteEndpoint.Async async = session.getAsyncRemote();
                addr = (InetSocketAddress)WebSocketServer.getFieldInstance((Object)async, (String)"base#socketWrapper#socket#sc#remoteAddress");
            }
            return Objects.nonNull(addr) ? addr.getAddress().toString() : "";
        }
        catch (Exception e) {
            log.error("webSocket get client Address error", (Throwable)e);
            return "";
        }
    }
}

