/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.impl;

import com.sun.jna.NativeLong;
import com.sun.jna.platform.win32.WinDef;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.DeviceRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.IpcEmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.PlatformParaRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.TimeZoneRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.PlatformParaRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.TimeZoneRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.exception.IpcException;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.AbstractSdkService;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.HWPuSDK;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.SdkInstance;
import com.zkteco.zkbiosecurity.cuserver.ipc.service.SystemConfigService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class SdcSystemConfigServiceImpl
extends AbstractSdkService
implements SystemConfigService {
    public boolean setSDKPlatformParam(DeviceRequest<PlatformParaRequest> request) {
        HWPuSDK.PU_PLATFORM_SDK_PARA platformSdkPara = new HWPuSDK.PU_PLATFORM_SDK_PARA();
        boolean success = SdkInstance.getInstance().IVS_PU_GetSDKPlatformPara(new WinDef.ULONG(Long.parseLong(request.getSession())), platformSdkPara);
        if (!success) {
            System.out.println(this.errorDetail());
        }
        platformSdkPara.szPlatformIp = Arrays.copyOf(((PlatformParaRequest)request.getRequest()).getPlatformIp().getBytes(), 16);
        platformSdkPara.szPlatformPort = new WinDef.ULONG((long)((PlatformParaRequest)request.getRequest()).getPlatformPort());
        platformSdkPara.szDeviceId = Arrays.copyOf(((PlatformParaRequest)request.getRequest()).getDeviceId().getBytes(), 32);
        platformSdkPara.bEnable = new WinDef.BOOL(true);
        platformSdkPara.enSdkPlatformMode = 1;
        platformSdkPara.enConnectType = 1;
        success = SdkInstance.getInstance().IVS_PU_SetSDKPlatformPara(new WinDef.ULONG(Long.parseLong(request.getSession())), platformSdkPara);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorMsg());
        }
        return true;
    }

    public PlatformParaRespond getSDKPlatformParam(DeviceRequest<IpcEmptyRequest> request) {
        HWPuSDK.PU_PLATFORM_SDK_PARA platformSdkPara = new HWPuSDK.PU_PLATFORM_SDK_PARA();
        PlatformParaRespond platformParaRespond = new PlatformParaRespond();
        boolean result = SdkInstance.getInstance().IVS_PU_GetSDKPlatformPara(new WinDef.ULONG(Long.valueOf(request.getSession()).longValue()), platformSdkPara);
        if (!result) {
            throw new IpcException(this.errorDetail());
        }
        platformParaRespond.setEnable(platformSdkPara.bEnable.booleanValue());
        platformParaRespond.setMode(platformSdkPara.enSdkPlatformMode);
        platformParaRespond.setDeviceId(new String(platformSdkPara.szDeviceId).trim());
        platformParaRespond.setPlatformIp(new String(platformSdkPara.szPlatformIp).trim());
        platformParaRespond.setPlatformPort(platformSdkPara.szPlatformPort.intValue());
        platformParaRespond.setBackupPlatformIp(new String(platformSdkPara.szBackupPlatformIp).trim());
        platformParaRespond.setBackupPlatformPort(platformSdkPara.szBackupPlatformPort.intValue());
        platformParaRespond.setConnectType(platformSdkPara.enConnectType);
        platformParaRespond.setMeshIndex(platformSdkPara.ulMeshIndex.intValue());
        platformParaRespond.setReserved(new String(platformSdkPara.szReserve).trim());
        return platformParaRespond;
    }

    public boolean setDeviceTime(DeviceRequest<TimeZoneRequest> request) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HWPuSDK.LPPU_SYSTEM_TIME_S lppuSystemTimeS = new HWPuSDK.LPPU_SYSTEM_TIME_S();
        lppuSystemTimeS.lTimeZone = new WinDef.LONG((long)((TimeZoneRequest)request.getRequest()).getTimeZone());
        lppuSystemTimeS.ulDotTimeZone = new WinDef.ULONG((long)((TimeZoneRequest)request.getRequest()).getDotTimeZone());
        Calendar date = Calendar.getInstance();
        try {
            Date orderDateStart = new SimpleDateFormat("yyyyMMddHHmmss").parse(((TimeZoneRequest)request.getRequest()).getTime());
            Date dateFormat = sdf.parse(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(orderDateStart));
            date.setTime(dateFormat);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        lppuSystemTimeS.stSystime.szYear = String.valueOf(date.get(1)).getBytes();
        lppuSystemTimeS.stSystime.szMonth = String.valueOf(date.get(2) + 1).getBytes();
        lppuSystemTimeS.stSystime.szDay = String.valueOf(date.get(5)).getBytes();
        lppuSystemTimeS.stSystime.szHour = String.valueOf(date.get(11)).getBytes();
        lppuSystemTimeS.stSystime.szMinute = String.valueOf(date.get(12)).getBytes();
        lppuSystemTimeS.stSystime.szSecond = String.valueOf(date.get(13)).getBytes();
        boolean success = SdkInstance.getInstance().IVS_PU_SetDeviceTime(new NativeLong(Long.parseLong(request.getSession())), lppuSystemTimeS);
        if (!success) {
            throw new IpcException(this.errorDetail());
        }
        return true;
    }

    public TimeZoneRespond getDeviceTime(DeviceRequest<IpcEmptyRequest> request) {
        HWPuSDK.LPPU_SYSTEM_TIME_S lppuSystemTimeS = new HWPuSDK.LPPU_SYSTEM_TIME_S();
        TimeZoneRespond timeZone = new TimeZoneRespond();
        SdkInstance.getInstance().IVS_PU_GetDeviceTime(new NativeLong(Long.parseLong(request.getSession())), lppuSystemTimeS);
        timeZone.setTimeZone(lppuSystemTimeS.lTimeZone.intValue());
        timeZone.setDotTimeZone(lppuSystemTimeS.ulDotTimeZone.intValue());
        timeZone.setTime(new String(lppuSystemTimeS.stSystime.szYear).trim() + "-" + new String(lppuSystemTimeS.stSystime.szMonth).trim() + "-" + new String(lppuSystemTimeS.stSystime.szDay).trim() + " " + new String(lppuSystemTimeS.stSystime.szHour).trim() + ":" + new String(lppuSystemTimeS.stSystime.szMinute).trim() + ":" + new String(lppuSystemTimeS.stSystime.szSecond).trim());
        timeZone.setReserved(new String(lppuSystemTimeS.szReserve).trim());
        return timeZone;
    }
}

