/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.impl;

import com.sun.jna.platform.win32.WinDef;
import com.zkteco.zkbiosecurity.cuserver.ipc.callback.AlarmCallback;
import com.zkteco.zkbiosecurity.cuserver.ipc.callback.MetadataCallback;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.DeviceRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.MetadataCancelRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.exception.IpcException;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.AbstractSdkService;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.HWPuSDK;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.SdkInstance;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.callback.CallbackManager;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.callback.SdcAlarmEventCallback;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.callback.SdcMetadataCallback;
import com.zkteco.zkbiosecurity.cuserver.ipc.service.SubscribeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="SdcSubscribeServiceSdkImpl")
public class SdcSubscribeServiceSdkImpl
extends AbstractSdkService
implements SubscribeService {
    private static final Logger log = LoggerFactory.getLogger(SdcSubscribeServiceSdkImpl.class);

    public long subscribeMetadata(DeviceRequest<MetadataCallback> request) {
        MetadataCallback metadataCallback = (MetadataCallback)request.getRequest();
        SdcMetadataCallback sdcMetadataCallback = new SdcMetadataCallback(metadataCallback);
        CallbackManager.addMetaCallback((String)request.getSession(), (SdcMetadataCallback)sdcMetadataCallback);
        HWPuSDK.PU_REAL_PLAY_INFO_S realPlayInfoS = new HWPuSDK.PU_REAL_PLAY_INFO_S();
        realPlayInfoS.ulChannelId = new WinDef.ULONG(Long.valueOf(101L).longValue());
        realPlayInfoS.hPlayWnd = null;
        realPlayInfoS.enStreamType = 0;
        realPlayInfoS.enVideoType = 4;
        realPlayInfoS.enProtocolType = 1;
        realPlayInfoS.enMediaCallbackType = 5;
        realPlayInfoS.bKeepLive = true;
        realPlayInfoS.szReserved[22] = 1;
        realPlayInfoS.write();
        WinDef.ULONG handle = SdkInstance.getInstance().IVS_PU_RealPlay(new WinDef.ULONG(Long.valueOf(request.getSession()).longValue()), realPlayInfoS, (HWPuSDK.pfRealDataCallBack)sdcMetadataCallback, CallbackManager.getMetaPointer((String)request.getSession()));
        if (handle.longValue() <= 0L) {
            CallbackManager.removeMetaCallback((String)request.getSession());
            throw new IpcException(this.errorCode(), this.errorMsg());
        }
        return handle.longValue();
    }

    public boolean cancelMetadata(DeviceRequest<MetadataCancelRequest> request) {
        boolean success = SdkInstance.getInstance().IVS_PU_StopRealPlay(new WinDef.ULONG(Long.valueOf(request.getSession()).longValue()), new WinDef.ULONG(Long.valueOf(((MetadataCancelRequest)request.getRequest()).getPlayHandle()).longValue()));
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorMsg());
        }
        CallbackManager.removeMetaCallback((String)request.getSession());
        log.debug("Cancel metadata subscribe success");
        return true;
    }

    public boolean subscribeAlarm(DeviceRequest<AlarmCallback> request) {
        SdcAlarmEventCallback sdcAlarmEventCallback = new SdcAlarmEventCallback((AlarmCallback)request.getRequest());
        CallbackManager.addAlarmCallback((String)request.getSession(), (SdcAlarmEventCallback)sdcAlarmEventCallback);
        boolean success = SdkInstance.getInstance().IVS_PU_SetAlarmEnventCallBack(new WinDef.ULONG(Long.valueOf(request.getSession()).longValue()), (HWPuSDK.pfGetDevAlarmInfoCallBack)sdcAlarmEventCallback, CallbackManager.getAlarmPointer((String)request.getSession()));
        if (!success) {
            CallbackManager.removeAlarmCallback((String)request.getSession());
            throw new IpcException(this.errorCode(), this.errorMsg());
        }
        return true;
    }
}

