/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.impl;

import com.sun.jna.NativeLong;
import com.sun.jna.platform.win32.WinDef;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.DeviceRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.IpcEmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.LoginRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.OnvifSwitchRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.PasswordChangeRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.LoginRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.OnvifKeepaliveSwitchRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.exception.IpcException;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.AbstractSdkService;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.SdkInstance;
import com.zkteco.zkbiosecurity.cuserver.ipc.service.SessionService;
import org.springframework.stereotype.Component;

@Component(value="SdcSessionServiceSdkImpl")
public class SdcSessionServiceSdkImpl
extends AbstractSdkService
implements SessionService {
    public LoginRespond login(DeviceRequest<LoginRequest> request) {
        LoginRespond loginRespond = new LoginRespond();
        long loginId = SdkInstance.getInstance().IVS_PU_Login(((LoginRequest)request.getRequest()).getIp(), new WinDef.ULONG(Long.valueOf(((LoginRequest)request.getRequest()).getPort()).longValue()), ((LoginRequest)request.getRequest()).getUserName(), ((LoginRequest)request.getRequest()).getPassWord());
        if (loginId <= 0L) {
            throw new IpcException(this.errorCode());
        }
        loginRespond.setSession(String.valueOf(loginId));
        return loginRespond;
    }

    public boolean logout(DeviceRequest<IpcEmptyRequest> request) {
        boolean result = SdkInstance.getInstance().IVS_PU_Logout(new WinDef.ULONG(Long.parseLong(request.getSession())));
        if (!result) {
            throw new IpcException(this.errorDetail());
        }
        return true;
    }

    public boolean changeSDKPassword(DeviceRequest<PasswordChangeRequest> request) {
        PasswordChangeRequest passwordChangeRequest = (PasswordChangeRequest)request.getRequest();
        boolean result = SdkInstance.getInstance().IVS_PU_ChangeDevicePassword(new NativeLong(Long.valueOf(request.getSession()).longValue()), passwordChangeRequest.getUserName(), passwordChangeRequest.getOldPassword(), passwordChangeRequest.getNewPassword());
        if (!result) {
            throw new IpcException(this.errorDetail());
        }
        return true;
    }

    public boolean changeWebPassword(DeviceRequest<PasswordChangeRequest> request) {
        PasswordChangeRequest passwordChangeRequest = (PasswordChangeRequest)request.getRequest();
        boolean result = SdkInstance.getInstance().IVS_PU_ChangeAdminPassword(new NativeLong(Long.valueOf(request.getSession()).longValue()), passwordChangeRequest.getOldPassword(), passwordChangeRequest.getNewPassword(), 0);
        if (!result) {
            throw new IpcException(this.errorCode(), this.errorMsg());
        }
        return true;
    }

    public boolean setOnvifMediaKeepAliveMode(DeviceRequest<OnvifSwitchRequest> request) {
        boolean result = SdkInstance.getInstance().IVS_PU_SetOnvifMediaKeepAliveMode(new WinDef.ULONG(Long.valueOf(request.getSession()).longValue()), new WinDef.BOOL(((OnvifSwitchRequest)request.getRequest()).isEnabled()));
        if (!result) {
            throw new IpcException(this.errorDetail());
        }
        return false;
    }

    public OnvifKeepaliveSwitchRespond getOnvifMediaKeepAliveMode(DeviceRequest<IpcEmptyRequest> request) {
        OnvifKeepaliveSwitchRespond respond = new OnvifKeepaliveSwitchRespond();
        boolean enabled = false;
        boolean result = SdkInstance.getInstance().IVS_PU_GetOnvifMediaKeepAliveMode(new WinDef.ULONG(Long.valueOf(request.getSession()).longValue()), new WinDef.BOOLByReference(new WinDef.BOOL(enabled)));
        if (!result) {
            throw new IpcException(this.errorDetail());
        }
        respond.setEnabled(enabled);
        return respond;
    }
}

