/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.impl;

import com.sun.jna.platform.win32.WinDef;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.CruisePoint;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.DeviceRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.PtzPresetInfo;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.GuardPositionParamRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.IpcEmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.PtzControlRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.PtzPresetParamRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.CruiseTrackRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.GuardPositionParamRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.PtzPresetListRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.exception.IpcException;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.AbstractSdkService;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.HWPuSDK;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.SdkInstance;
import com.zkteco.zkbiosecurity.cuserver.ipc.service.PtzControlService;
import org.springframework.stereotype.Component;

@Component
public class SdcPtzControlServiceImpl
extends AbstractSdkService
implements PtzControlService {
    public boolean PTZControl(DeviceRequest<PtzControlRequest> request) {
        HWPuSDK.LPPU_PTZ_CONTROL_PARA_S ptzControlParaS = this.transPtzControl((PtzControlRequest)request.getRequest());
        boolean success = SdkInstance.getInstance().IVS_PU_PTZControl(new WinDef.ULONG(Long.parseLong(request.getSession())), ptzControlParaS);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        return true;
    }

    public CruiseTrackRespond getCruiseTrackInfo(DeviceRequest<IpcEmptyRequest> request) {
        return this.operateCruiseTrack(request, 2);
    }

    public CruiseTrackRespond StopCruise(DeviceRequest<IpcEmptyRequest> request) {
        return this.operateCruiseTrack(request, 5);
    }

    private CruiseTrackRespond operateCruiseTrack(DeviceRequest<IpcEmptyRequest> request, int puPtzCruiseTrackStop) {
        HWPuSDK.PU_PTZ_CRUISE_TRACK_PARA cruiseTrackPara = new HWPuSDK.PU_PTZ_CRUISE_TRACK_PARA();
        cruiseTrackPara.ulPtzId = new WinDef.ULONG(101L);
        cruiseTrackPara.enPtzCruiseTrack = puPtzCruiseTrackStop;
        boolean success = SdkInstance.getInstance().IVS_PU_PTZ_CruiseTrack(new WinDef.ULONG(Long.parseLong(request.getSession())), cruiseTrackPara);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        return this.toCruiseTrack(cruiseTrackPara);
    }

    public PtzPresetListRespond getPresetList(DeviceRequest<IpcEmptyRequest> request) {
        HWPuSDK.PU_PTZ_PRESET_LIST_PARA presetList = new HWPuSDK.PU_PTZ_PRESET_LIST_PARA();
        presetList.ulChannelId = new WinDef.ULONG(101L);
        boolean success = SdkInstance.getInstance().IVS_PU_PTZ_GetPresetList(new WinDef.ULONG(Long.parseLong(request.getSession())), presetList);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        return this.toPtzPresetList(presetList);
    }

    public boolean addPreset(DeviceRequest<PtzPresetParamRequest> request) {
        PtzPresetParamRequest paramRequest = (PtzPresetParamRequest)request.getRequest();
        paramRequest.setChannelId("101");
        paramRequest.setPresetCmd(1);
        return this.operatePresetParam(request.getSession(), paramRequest);
    }

    public boolean updatePreset(DeviceRequest<PtzPresetParamRequest> request) {
        PtzPresetParamRequest paramRequest = (PtzPresetParamRequest)request.getRequest();
        paramRequest.setChannelId("101");
        paramRequest.setPresetCmd(4);
        return this.operatePresetParam(request.getSession(), paramRequest);
    }

    public boolean deletePreset(DeviceRequest<PtzPresetParamRequest> request) {
        PtzPresetParamRequest paramRequest = (PtzPresetParamRequest)request.getRequest();
        paramRequest.setChannelId("101");
        paramRequest.setPresetCmd(3);
        return this.operatePresetParam(request.getSession(), paramRequest);
    }

    private boolean operatePresetParam(String loginId, PtzPresetParamRequest ptzPresetParamRequest) {
        HWPuSDK.PU_PTZ_PRESET_PARA ptzPresetPara = this.transPtzPresetParam(ptzPresetParamRequest);
        boolean success = SdkInstance.getInstance().IVS_PU_PTZ_Preset(new WinDef.ULONG(Long.parseLong(loginId)), ptzPresetPara);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        return true;
    }

    public boolean setGuardPositionParam(DeviceRequest<GuardPositionParamRequest> request) {
        HWPuSDK.GUARD_POSITION_PARA guardPositionPara = this.transGuardPositionParam((GuardPositionParamRequest)request.getRequest());
        boolean success = SdkInstance.getInstance().IVS_PU_SetGuardPositionPara(new WinDef.ULONG(Long.parseLong(request.getSession())), guardPositionPara);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        return true;
    }

    public GuardPositionParamRespond getGuardPositionParam(DeviceRequest<IpcEmptyRequest> request) {
        HWPuSDK.GUARD_POSITION_PARA guardPositionPara = new HWPuSDK.GUARD_POSITION_PARA();
        boolean success = SdkInstance.getInstance().IVS_PU_GetGuardPositionPara(new WinDef.ULONG(Long.parseLong(request.getSession())), guardPositionPara);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        return this.toGuardPositionParam(guardPositionPara);
    }

    private HWPuSDK.LPPU_PTZ_CONTROL_PARA_S transPtzControl(PtzControlRequest ptzControlRequest) {
        HWPuSDK.LPPU_PTZ_CONTROL_PARA_S ptzControlParaS = new HWPuSDK.LPPU_PTZ_CONTROL_PARA_S();
        ptzControlParaS.ulChannel = ptzControlRequest.getChannel();
        ptzControlParaS.ulOpCode = ptzControlRequest.getOpCode();
        ptzControlParaS.ulParam1 = ptzControlRequest.getParam1();
        ptzControlParaS.ulParam2 = ptzControlRequest.getParam2();
        return ptzControlParaS;
    }

    private CruiseTrackRespond toCruiseTrack(HWPuSDK.PU_PTZ_CRUISE_TRACK_PARA cruiseTrackPara) {
        CruiseTrackRespond cruiseTrackRespond = new CruiseTrackRespond();
        cruiseTrackRespond.setPtzId(cruiseTrackPara.ulPtzId.longValue());
        cruiseTrackRespond.setCruiseTrackIndex(cruiseTrackPara.ulCruiseTrackIndex.longValue());
        cruiseTrackRespond.setCruiseType(cruiseTrackPara.ulCruiseType.longValue());
        cruiseTrackRespond.setCruiseTrackName(new String(cruiseTrackPara.szCuriseTrackName).trim());
        cruiseTrackRespond.setPointNum(cruiseTrackPara.ulPointNum.longValue());
        CruisePoint[] cruisePoints = new CruisePoint[32];
        HWPuSDK.PU_CRUISE_POINT[] puCruisePoints = cruiseTrackPara.stCruisePoint;
        for (int i = 0; i < puCruisePoints.length; ++i) {
            cruisePoints[i].setPresetIndex(puCruisePoints[i].ulPresetIndex.longValue());
            cruisePoints[i].setDwellTime(puCruisePoints[i].ulDwellTime.longValue());
            cruisePoints[i].setSpeed(puCruisePoints[i].ulSpeed.longValue());
        }
        cruiseTrackRespond.setCruisePoints(cruisePoints);
        cruiseTrackRespond.setPtzCruiseTrack(cruiseTrackPara.enPtzCruiseTrack);
        return cruiseTrackRespond;
    }

    private PtzPresetListRespond toPtzPresetList(HWPuSDK.PU_PTZ_PRESET_LIST_PARA presetListPara) {
        PtzPresetListRespond presetListRespond = new PtzPresetListRespond();
        presetListRespond.setChannelId(presetListPara.ulChannelId.toString());
        presetListRespond.setBeginIndex(presetListPara.ulBeginIndex.longValue());
        presetListRespond.setEndIndex(presetListPara.ulEndIndex.longValue());
        presetListRespond.setTotalNum(presetListPara.ulTotalNum.longValue());
        PtzPresetInfo[] presetInfos = new PtzPresetInfo[10];
        HWPuSDK.PU_PTZ_PRESET_INFO[] puPtzPresetInfos = presetListPara.stPtzPresetInfo;
        for (int i = 0; i < puPtzPresetInfos.length; ++i) {
            presetInfos[i].setIndex(puPtzPresetInfos[i].ulIndex.longValue());
            presetInfos[i].setPresetName(new String(puPtzPresetInfos[i].szPresetName).trim());
        }
        presetListRespond.setPresetInfo(presetInfos);
        return presetListRespond;
    }

    private HWPuSDK.PU_PTZ_PRESET_PARA transPtzPresetParam(PtzPresetParamRequest paramRequest) {
        HWPuSDK.PU_PTZ_PRESET_PARA puPtzPresetPara = new HWPuSDK.PU_PTZ_PRESET_PARA();
        puPtzPresetPara.ulChannelId = new WinDef.ULONG(Long.parseLong(paramRequest.getChannelId()));
        puPtzPresetPara.szPresetName = paramRequest.getPresetName().getBytes();
        puPtzPresetPara.ulIndex = new WinDef.ULONG(paramRequest.getIndex());
        puPtzPresetPara.enPresetCmd = paramRequest.getPresetCmd();
        return puPtzPresetPara;
    }

    private HWPuSDK.GUARD_POSITION_PARA transGuardPositionParam(GuardPositionParamRequest guardPositionParam) {
        HWPuSDK.GUARD_POSITION_PARA guardPositionPara = new HWPuSDK.GUARD_POSITION_PARA();
        guardPositionPara.ulPtzId = new WinDef.ULONG(guardPositionParam.getPtzId());
        guardPositionPara.bEnable = new WinDef.BOOL(guardPositionParam.getEnable().booleanValue());
        guardPositionPara.ulPresetIndex = new WinDef.ULONG(guardPositionParam.getPresetIndex());
        guardPositionPara.ulWaitTime = new WinDef.ULONG(guardPositionParam.getWaitTime());
        return guardPositionPara;
    }

    private GuardPositionParamRespond toGuardPositionParam(HWPuSDK.GUARD_POSITION_PARA puGuardPositionPara) {
        GuardPositionParamRespond guardPositionParamRespond = new GuardPositionParamRespond();
        guardPositionParamRespond.setPtzId(puGuardPositionPara.ulPtzId.longValue());
        guardPositionParamRespond.setEnable(Boolean.valueOf(puGuardPositionPara.bEnable.booleanValue()));
        guardPositionParamRespond.setPresetIndex(puGuardPositionPara.ulPresetIndex.longValue());
        guardPositionParamRespond.setWaitTime(puGuardPositionPara.ulWaitTime.longValue());
        return guardPositionParamRespond;
    }
}

