/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.impl;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.WinDef;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.AlarmTime;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.BaseAreaParam;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.DeviceRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.MaskParam;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.HideAlarmParamRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.ITGEModeRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.IpcEmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.MotionDetectionParamRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.PrivacyMaskArrayRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.HideAlarmParamRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.ITGEModeRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.MotionDetectionParamRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.PrivacyMaskArrayRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.exception.IpcException;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.AbstractSdkService;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.HWPuSDK;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.SdkInstance;
import com.zkteco.zkbiosecurity.cuserver.ipc.service.OrdinaryIntelligenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SdcOrdinaryIntelligenceServiceImpl
extends AbstractSdkService
implements OrdinaryIntelligenceService {
    private static final Logger log = LoggerFactory.getLogger(SdcOrdinaryIntelligenceServiceImpl.class);

    public boolean setITGEMode(DeviceRequest<ITGEModeRequest> request) {
        HWPuSDK.PU_ITGT_MODE_S itgeModeItem = this.transITGEMode((ITGEModeRequest)request.getRequest());
        itgeModeItem.write();
        boolean success = SdkInstance.getInstance().IVS_PU_SetITGEMode(new WinDef.ULONG(Long.parseLong(request.getSession())), itgeModeItem);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        return true;
    }

    public ITGEModeRespond getITGEMode(DeviceRequest<IpcEmptyRequest> request) {
        HWPuSDK.PU_ITGT_MODE_S itgeMode = new HWPuSDK.PU_ITGT_MODE_S();
        itgeMode.ulChannelId = new WinDef.ULONG(101L);
        itgeMode.write();
        Pointer pointer = itgeMode.getPointer();
        boolean success = SdkInstance.getInstance().IVS_PU_GetITGEMode(new WinDef.ULONG(Long.parseLong(request.getSession())), itgeMode);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        itgeMode = (HWPuSDK.PU_ITGT_MODE_S)Structure.newInstance(HWPuSDK.PU_ITGT_MODE_S.class, (Pointer)pointer);
        itgeMode.read();
        return this.toITGEMode(itgeMode);
    }

    public boolean setHideAlarmParam(DeviceRequest<HideAlarmParamRequest> request) {
        HWPuSDK.PU_HIDE_ALARM_PARA hideAlarmPara = this.transHideAlarmParam((HideAlarmParamRequest)request.getRequest());
        hideAlarmPara.write();
        Pointer pointer = hideAlarmPara.getPointer();
        boolean success = SdkInstance.getInstance().IVS_PU_SetAlarmPara(new WinDef.ULONG(Long.parseLong(request.getSession())), 6, pointer);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        return true;
    }

    public HideAlarmParamRespond getHideAlarmParam(DeviceRequest<IpcEmptyRequest> request) {
        HWPuSDK.PU_HIDE_ALARM_PARA hideAlarmPara = new HWPuSDK.PU_HIDE_ALARM_PARA();
        hideAlarmPara.ulChannel = new WinDef.ULONG(101L);
        hideAlarmPara.write();
        Pointer pointer = hideAlarmPara.getPointer();
        boolean success = SdkInstance.getInstance().IVS_PU_GetAlarmPara(new WinDef.ULONG(Long.parseLong(request.getSession())), 6, pointer);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        hideAlarmPara = (HWPuSDK.PU_HIDE_ALARM_PARA)Structure.newInstance(HWPuSDK.PU_HIDE_ALARM_PARA.class, (Pointer)pointer);
        hideAlarmPara.read();
        return this.toHideAlarmParam(hideAlarmPara);
    }

    public boolean setMotionDetectionAlarmParam(DeviceRequest<MotionDetectionParamRequest> request) {
        HWPuSDK.PU_MOTION_DETECTION_PARA motionDetectionPara = this.transMotionDetectionParam((MotionDetectionParamRequest)request.getRequest());
        motionDetectionPara.write();
        Pointer pointer = motionDetectionPara.getPointer();
        boolean success = SdkInstance.getInstance().IVS_PU_SetAlarmPara(new WinDef.ULONG(Long.parseLong(request.getSession())), 4, pointer);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        return true;
    }

    public MotionDetectionParamRespond getMotionDetectionAlarmParam(DeviceRequest<IpcEmptyRequest> request) {
        HWPuSDK.PU_MOTION_DETECTION_PARA motionDetectionPara = new HWPuSDK.PU_MOTION_DETECTION_PARA();
        motionDetectionPara.ulChannelId = new WinDef.ULONG(101L);
        motionDetectionPara.write();
        Pointer pointer = motionDetectionPara.getPointer();
        boolean success = SdkInstance.getInstance().IVS_PU_GetAlarmPara(new WinDef.ULONG(Long.parseLong(request.getSession())), 4, pointer);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        motionDetectionPara = (HWPuSDK.PU_MOTION_DETECTION_PARA)Structure.newInstance(HWPuSDK.PU_MOTION_DETECTION_PARA.class, (Pointer)pointer);
        motionDetectionPara.read();
        return this.toMotionDetectionParam(motionDetectionPara);
    }

    public boolean setPrivacyMaskParam(DeviceRequest<PrivacyMaskArrayRequest> request) {
        HWPuSDK.PU_PRIVACY_MASK_ARRAY puPrivacyMaskArray = this.transPrivacyMaskParam((PrivacyMaskArrayRequest)request.getRequest());
        puPrivacyMaskArray.write();
        boolean success = SdkInstance.getInstance().IVS_PU_SetPrivacyMask(new WinDef.ULONG(Long.parseLong(request.getSession())), puPrivacyMaskArray);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        return true;
    }

    public PrivacyMaskArrayRespond getPrivacyMaskParam(DeviceRequest<IpcEmptyRequest> request) {
        HWPuSDK.PU_PRIVACY_MASK_ARRAY puPrivacyMaskArray = new HWPuSDK.PU_PRIVACY_MASK_ARRAY();
        puPrivacyMaskArray.ulChannelID = new WinDef.ULONG(101L);
        puPrivacyMaskArray.write();
        Pointer pointer = puPrivacyMaskArray.getPointer();
        boolean success = SdkInstance.getInstance().IVS_PU_GetPrivacyMask(new WinDef.ULONG(Long.parseLong(request.getSession())), puPrivacyMaskArray);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        puPrivacyMaskArray = (HWPuSDK.PU_PRIVACY_MASK_ARRAY)Structure.newInstance(HWPuSDK.PU_PRIVACY_MASK_ARRAY.class, (Pointer)pointer);
        puPrivacyMaskArray.read();
        return this.toPrivacyMaskParam(puPrivacyMaskArray);
    }

    private ITGEModeRespond toITGEMode(HWPuSDK.PU_ITGT_MODE_S itgeMode) {
        ITGEModeRespond itgeModeItem = new ITGEModeRespond();
        itgeModeItem.setChannelId(itgeMode.ulChannelId.toString());
        itgeModeItem.setEnITGEMode(itgeMode.enITGEMode);
        itgeModeItem.setReserve(new String(itgeMode.szReserve).trim());
        return itgeModeItem;
    }

    private HWPuSDK.PU_ITGT_MODE_S transITGEMode(ITGEModeRequest itgeMode) {
        HWPuSDK.PU_ITGT_MODE_S itgeModeS = new HWPuSDK.PU_ITGT_MODE_S();
        itgeModeS.ulChannelId = new WinDef.ULONG(Long.parseLong(itgeMode.getChannelId()));
        itgeModeS.enITGEMode = itgeMode.getEnITGEMode();
        itgeModeS.szReserve = itgeMode.getReserve() != null && itgeMode.getReserve().length() > 0 ? itgeMode.getReserve().getBytes() : new byte[32 - HWPuSDK.LLong.size];
        return itgeModeS;
    }

    private HideAlarmParamRespond toHideAlarmParam(HWPuSDK.PU_HIDE_ALARM_PARA alarmPara) {
        HideAlarmParamRespond hideAlarmParam = new HideAlarmParamRespond();
        hideAlarmParam.setChannelId(alarmPara.ulChannel.toString());
        hideAlarmParam.setEnable(alarmPara.lEnable.longValue());
        hideAlarmParam.setSensitivity(alarmPara.ulSensitivity.longValue());
        hideAlarmParam.setDeteInterval(alarmPara.ulDeteInterval.longValue());
        HWPuSDK.PU_DETECTION_AREA detectionArea = alarmPara.stDetectionArea;
        BaseAreaParam.DetectionArea detectionAreaItem = new BaseAreaParam.DetectionArea();
        detectionAreaItem.setAreaNum(detectionArea.ulNum.longValue());
        detectionAreaItem.area = new MaskParam[16];
        HWPuSDK.PU_MASK_PARA[] stMaskPara = detectionArea.stMaskPara;
        for (int i = 0; i < stMaskPara.length; ++i) {
            detectionAreaItem.area[i] = this.toMaskParam(stMaskPara[i]);
        }
        hideAlarmParam.setDetectionArea(detectionAreaItem);
        HWPuSDK.PU_ALARM_TIME_LIST puAlarmTimeList = alarmPara.stAlarmTimeList;
        BaseAreaParam.AlarmTimeList alarmTimeList = new BaseAreaParam.AlarmTimeList();
        alarmTimeList.setNum(puAlarmTimeList.ulNum.longValue());
        alarmTimeList.alarmTimes = new AlarmTime[8];
        HWPuSDK.PU_ALARM_TIME[] puAlarmTime = puAlarmTimeList.stAlarmTime;
        for (int j = 0; j < puAlarmTime.length; ++j) {
            alarmTimeList.alarmTimes[j] = this.toHWAlarmTime(puAlarmTime[j]);
        }
        hideAlarmParam.setAlarmTimeList(alarmTimeList);
        return hideAlarmParam;
    }

    private HWPuSDK.PU_HIDE_ALARM_PARA transHideAlarmParam(HideAlarmParamRequest hideAlarmParam) {
        HWPuSDK.PU_HIDE_ALARM_PARA alarmPara = new HWPuSDK.PU_HIDE_ALARM_PARA();
        alarmPara.ulChannel = new WinDef.ULONG(Long.parseLong(hideAlarmParam.getChannelId()));
        alarmPara.lEnable = new NativeLong(hideAlarmParam.getEnable());
        alarmPara.ulSensitivity = new WinDef.ULONG(hideAlarmParam.getSensitivity());
        alarmPara.ulDeteInterval = new WinDef.ULONG(hideAlarmParam.getDeteInterval());
        BaseAreaParam.DetectionArea detectionAreaItem = hideAlarmParam.getDetectionArea();
        HWPuSDK.PU_DETECTION_AREA detectionArea = new HWPuSDK.PU_DETECTION_AREA();
        detectionArea.ulNum = new WinDef.ULONG(detectionAreaItem.getAreaNum());
        MaskParam[] maskParams = detectionAreaItem.area;
        for (int i = 0; i < maskParams.length; ++i) {
            detectionArea.stMaskPara[i] = this.transMaskParam(maskParams[i]);
        }
        alarmPara.stDetectionArea = detectionArea;
        BaseAreaParam.AlarmTimeList sdcAlarmTimeList = hideAlarmParam.getAlarmTimeList();
        HWPuSDK.PU_ALARM_TIME_LIST puAlarmTimeList = new HWPuSDK.PU_ALARM_TIME_LIST();
        puAlarmTimeList.ulNum = new WinDef.ULONG(sdcAlarmTimeList.num);
        AlarmTime[] sdcAlarmTimes = sdcAlarmTimeList.alarmTimes;
        for (int j = 0; j < sdcAlarmTimes.length; ++j) {
            puAlarmTimeList.stAlarmTime[j] = this.transHWAlarmTime(sdcAlarmTimes[j]);
        }
        alarmPara.stAlarmTimeList = puAlarmTimeList;
        return alarmPara;
    }

    private MotionDetectionParamRespond toMotionDetectionParam(HWPuSDK.PU_MOTION_DETECTION_PARA puMotionDetectionPara) {
        MotionDetectionParamRespond motionDetectionParam = new MotionDetectionParamRespond();
        motionDetectionParam.setChannelId(puMotionDetectionPara.ulChannelId.toString());
        motionDetectionParam.setEnable(puMotionDetectionPara.lEnable.longValue());
        motionDetectionParam.setInterval(puMotionDetectionPara.ulInterval.longValue());
        motionDetectionParam.setSensitivity(puMotionDetectionPara.ulSensitivity.longValue());
        motionDetectionParam.setDeteInterval(puMotionDetectionPara.ulDeteInterval.longValue());
        HWPuSDK.PU_DETECTION_AREA detectionArea = puMotionDetectionPara.stDetectionArea;
        BaseAreaParam.DetectionArea detectionAreaItem = new BaseAreaParam.DetectionArea();
        detectionAreaItem.setAreaNum(detectionArea.ulNum.longValue());
        detectionAreaItem.area = new MaskParam[16];
        HWPuSDK.PU_MASK_PARA[] stMaskPara = detectionArea.stMaskPara;
        for (int i = 0; i < stMaskPara.length; ++i) {
            detectionAreaItem.area[i] = this.toMaskParam(stMaskPara[i]);
        }
        motionDetectionParam.setDetectionArea(detectionAreaItem);
        HWPuSDK.PU_ALARM_TIME_LIST puAlarmTimeList = puMotionDetectionPara.stAlarmTimeList;
        BaseAreaParam.AlarmTimeList alarmTimeList = new BaseAreaParam.AlarmTimeList();
        alarmTimeList.setNum(puAlarmTimeList.ulNum.longValue());
        alarmTimeList.alarmTimes = new AlarmTime[8];
        HWPuSDK.PU_ALARM_TIME[] puAlarmTime = puAlarmTimeList.stAlarmTime;
        for (int j = 0; j < puAlarmTime.length; ++j) {
            alarmTimeList.alarmTimes[j] = this.toHWAlarmTime(puAlarmTime[j]);
        }
        motionDetectionParam.setAlarmTimeList(alarmTimeList);
        return motionDetectionParam;
    }

    private HWPuSDK.PU_MOTION_DETECTION_PARA transMotionDetectionParam(MotionDetectionParamRequest motionDetectionParam) {
        HWPuSDK.PU_MOTION_DETECTION_PARA alarmPara = new HWPuSDK.PU_MOTION_DETECTION_PARA();
        alarmPara.ulChannelId = new WinDef.ULONG(Long.parseLong(motionDetectionParam.getChannelId()));
        alarmPara.lEnable = new NativeLong(motionDetectionParam.getEnable());
        alarmPara.ulInterval = new WinDef.ULONG(motionDetectionParam.getInterval());
        alarmPara.ulSensitivity = new WinDef.ULONG(motionDetectionParam.getSensitivity());
        alarmPara.ulDeteInterval = new WinDef.ULONG(motionDetectionParam.getDeteInterval());
        BaseAreaParam.DetectionArea detectionAreaItem = motionDetectionParam.getDetectionArea();
        HWPuSDK.PU_DETECTION_AREA detectionArea = new HWPuSDK.PU_DETECTION_AREA();
        detectionArea.ulNum = new WinDef.ULONG(detectionAreaItem.getAreaNum());
        MaskParam[] maskParams = detectionAreaItem.area;
        for (int i = 0; i < maskParams.length; ++i) {
            detectionArea.stMaskPara[i] = this.transMaskParam(maskParams[i]);
        }
        alarmPara.stDetectionArea = detectionArea;
        BaseAreaParam.AlarmTimeList sdcAlarmTimeList = motionDetectionParam.getAlarmTimeList();
        HWPuSDK.PU_ALARM_TIME_LIST puAlarmTimeList = new HWPuSDK.PU_ALARM_TIME_LIST();
        puAlarmTimeList.ulNum = new WinDef.ULONG(sdcAlarmTimeList.num);
        AlarmTime[] sdcAlarmTimes = sdcAlarmTimeList.alarmTimes;
        for (int j = 0; j < sdcAlarmTimes.length; ++j) {
            puAlarmTimeList.stAlarmTime[j] = this.transHWAlarmTime(sdcAlarmTimes[j]);
        }
        alarmPara.stAlarmTimeList = puAlarmTimeList;
        return alarmPara;
    }

    private PrivacyMaskArrayRespond toPrivacyMaskParam(HWPuSDK.PU_PRIVACY_MASK_ARRAY puPrivacyMaskArray) {
        PrivacyMaskArrayRespond privacyMaskArray = new PrivacyMaskArrayRespond();
        privacyMaskArray.setChannelID(puPrivacyMaskArray.ulChannelID.toString());
        privacyMaskArray.setNum(puPrivacyMaskArray.ulNum.longValue());
        privacyMaskArray.setEnable(Boolean.valueOf(puPrivacyMaskArray.bEnable.booleanValue()));
        HWPuSDK.PU_MASK_PARA[] puMaskPara = puPrivacyMaskArray.stMaskPara;
        MaskParam[] maskParams = new MaskParam[10];
        for (int i = 0; i < puMaskPara.length; ++i) {
            maskParams[i] = this.toMaskParam(puMaskPara[i]);
        }
        privacyMaskArray.setMaskPara(maskParams);
        return privacyMaskArray;
    }

    private HWPuSDK.PU_PRIVACY_MASK_ARRAY transPrivacyMaskParam(PrivacyMaskArrayRequest privacyMaskArray) {
        HWPuSDK.PU_PRIVACY_MASK_ARRAY puPrivacyMaskArray = new HWPuSDK.PU_PRIVACY_MASK_ARRAY();
        puPrivacyMaskArray.ulChannelID = new WinDef.ULONG(Long.parseLong(privacyMaskArray.getChannelID()));
        puPrivacyMaskArray.ulNum = new WinDef.ULONG(privacyMaskArray.getNum());
        puPrivacyMaskArray.bEnable = new WinDef.BOOL(privacyMaskArray.getEnable().booleanValue());
        MaskParam[] maskParams = privacyMaskArray.getMaskPara();
        HWPuSDK.PU_MASK_PARA[] puMaskParas = (HWPuSDK.PU_MASK_PARA[])new HWPuSDK.PU_MASK_PARA().toArray(10);
        for (int i = 0; i < maskParams.length; ++i) {
            puMaskParas[i] = this.transMaskParam(maskParams[i]);
        }
        puPrivacyMaskArray.stMaskPara = puMaskParas;
        return puPrivacyMaskArray;
    }

    private MaskParam toMaskParam(HWPuSDK.PU_MASK_PARA puMaskPara) {
        MaskParam maskParam = new MaskParam();
        maskParam.setStartX(puMaskPara.ulStartX.longValue());
        maskParam.setStartY(puMaskPara.ulStartY.longValue());
        maskParam.setWidth(puMaskPara.ulWidth.longValue());
        maskParam.setHeight(puMaskPara.ulHeight.longValue());
        return maskParam;
    }

    private HWPuSDK.PU_MASK_PARA transMaskParam(MaskParam maskParam) {
        HWPuSDK.PU_MASK_PARA puMaskPara = new HWPuSDK.PU_MASK_PARA();
        puMaskPara.ulStartX = new WinDef.ULONG(maskParam.getStartX());
        puMaskPara.ulStartY = new WinDef.ULONG(maskParam.getStartY());
        puMaskPara.ulHeight = new WinDef.ULONG(maskParam.getHeight());
        puMaskPara.ulWidth = new WinDef.ULONG(maskParam.getWidth());
        return puMaskPara;
    }
}

