/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.impl;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.WinDef;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.AlarmTime;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.BaseAreaParam;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.DeviceRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.IgaArea;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.IgtLine;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.IgtPoint;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.HotMapParasRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.HumanCountAlgParaRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.HumanCountParasRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.IpcEmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.QueueDetectAlgParaRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.QueueDetectParasRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.HotMapParasRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.HumanCountAlgParaRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.HumanCountParasRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.QueueDetectAlgParaRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.QueueDetectParasRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.exception.IpcException;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.AbstractSdkService;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.HWPuSDK;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.SdkInstance;
import com.zkteco.zkbiosecurity.cuserver.ipc.service.IntelligentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SdcIntelligentServiceImpl
extends AbstractSdkService
implements IntelligentService {
    private static final Logger log = LoggerFactory.getLogger(SdcIntelligentServiceImpl.class);

    public boolean clearCrossline(DeviceRequest<IpcEmptyRequest> request) {
        String session = request.getSession();
        boolean success = SdkInstance.getInstance().IVS_PU_SetHumanCountClear(new WinDef.ULONG(Long.valueOf(session).longValue()));
        if (!success) {
            log.error("clearCrossline error:" + this.errorDetail());
            throw new IpcException(this.errorDetail());
        }
        log.debug("clearCrossline success\uff1a" + success);
        return success;
    }

    public HumanCountParasRespond getCrossLinePara(DeviceRequest<IpcEmptyRequest> request) {
        boolean success = false;
        String session = request.getSession();
        HWPuSDK.PU_HUMANCOUNT_PARAM alarmPara = new HWPuSDK.PU_HUMANCOUNT_PARAM();
        alarmPara.ulChannelId = new WinDef.ULONG(101L);
        alarmPara.write();
        Pointer pointer = alarmPara.getPointer();
        int enAlarmType = 118;
        success = SdkInstance.getInstance().IVS_PU_GetAlarmPara(new WinDef.ULONG(Long.valueOf(session).longValue()), enAlarmType, pointer);
        if (!success) {
            log.error("getCrossLineParas error:" + this.errorDetail());
            throw new IpcException(this.errorDetail());
        }
        log.debug("getCrossLineParas success:" + success);
        alarmPara = (HWPuSDK.PU_HUMANCOUNT_PARAM)Structure.newInstance(HWPuSDK.PU_HUMANCOUNT_PARAM.class, (Pointer)pointer);
        alarmPara.read();
        return this.toHumanCountParas(alarmPara);
    }

    public boolean setCrossLinePara(DeviceRequest<HumanCountParasRequest> request) {
        boolean success = false;
        String session = request.getSession();
        HumanCountParasRequest humanCountParas = (HumanCountParasRequest)request.getRequest();
        HWPuSDK.PU_HUMANCOUNT_PARAM puParam = this.transHumanCountParas(humanCountParas);
        puParam.write();
        Pointer pointer = puParam.getPointer();
        int enAlarmType = 118;
        success = SdkInstance.getInstance().IVS_PU_SetAlarmPara(new WinDef.ULONG(Long.valueOf(session).longValue()), enAlarmType, pointer);
        if (!success) {
            log.error("setCrossLineParas error:" + this.errorDetail());
            throw new IpcException(this.errorDetail());
        }
        log.debug("setCrossLineParas success:" + success);
        return success;
    }

    public HotMapParasRespond getHotMapPara(DeviceRequest<IpcEmptyRequest> request) {
        boolean success = false;
        String session = request.getSession();
        HWPuSDK.PU_HOTMAP_PARA hotMapPara = new HWPuSDK.PU_HOTMAP_PARA();
        hotMapPara.ulChannelId = new NativeLong(101L);
        success = SdkInstance.getInstance().IVS_PU_GetHotMapPara(new WinDef.ULONG(Long.valueOf(session).longValue()), hotMapPara);
        if (!success) {
            log.error("getHotMapPara error" + this.errorDetail());
            throw new IpcException(this.errorDetail());
        }
        log.debug("getHotMapPara success:" + success);
        return this.toHotMapParas(hotMapPara);
    }

    public boolean setHotMapPara(DeviceRequest<HotMapParasRequest> request) {
        boolean success = false;
        String session = request.getSession();
        HotMapParasRequest hotMapParas = (HotMapParasRequest)request.getRequest();
        HWPuSDK.PU_HOTMAP_PARA hotMapPara = this.transHotMapParas(hotMapParas);
        success = SdkInstance.getInstance().IVS_PU_SetHotMapPara(new WinDef.ULONG(Long.valueOf(session).longValue()), hotMapPara);
        if (!success) {
            log.error("setHotMapPara error" + this.errorDetail());
            throw new IpcException(this.errorDetail());
        }
        log.debug("setHotMapPara success:" + success);
        return success;
    }

    public QueueDetectParasRespond getQueueLengthParas(DeviceRequest<IpcEmptyRequest> request) {
        boolean success = false;
        String session = request.getSession();
        HWPuSDK.PU_ITGT_QUEUE_DETECT_PARAM puQueueDetectPara = new HWPuSDK.PU_ITGT_QUEUE_DETECT_PARAM();
        puQueueDetectPara.ulChannelId = new WinDef.ULONG(101L);
        puQueueDetectPara.write();
        Pointer pointer = puQueueDetectPara.getPointer();
        int enAlarmType = 121;
        success = SdkInstance.getInstance().IVS_PU_GetAlarmPara(new WinDef.ULONG(Long.valueOf(session).longValue()), enAlarmType, pointer);
        if (!success) {
            log.error("getQueueLengthParas error:" + this.errorDetail());
            throw new IpcException(this.errorDetail());
        }
        log.debug("getQueueLengthParas success:" + success);
        puQueueDetectPara = (HWPuSDK.PU_ITGT_QUEUE_DETECT_PARAM)Structure.newInstance(HWPuSDK.PU_ITGT_QUEUE_DETECT_PARAM.class, (Pointer)pointer);
        puQueueDetectPara.read();
        return this.toQueueDetectParas(puQueueDetectPara);
    }

    public boolean setQueueLengthParas(DeviceRequest<QueueDetectParasRequest> request) {
        boolean success = false;
        String session = request.getSession();
        QueueDetectParasRequest queueDetectParas = (QueueDetectParasRequest)request.getRequest();
        HWPuSDK.PU_ITGT_QUEUE_DETECT_PARAM puParam = this.transQueueDetectParas(queueDetectParas);
        puParam.write();
        Pointer pointer = puParam.getPointer();
        int enAlarmType = 121;
        success = SdkInstance.getInstance().IVS_PU_SetAlarmPara(new WinDef.ULONG(Long.valueOf(session).longValue()), enAlarmType, pointer);
        if (!success) {
            log.error("setQueueLengthParas error:" + this.errorDetail());
            throw new IpcException(this.errorDetail());
        }
        log.debug("setQueueLengthParas success:" + success);
        return success;
    }

    private HWPuSDK.PU_ITGT_QUEUE_DETECT_PARAM transQueueDetectParas(QueueDetectParasRequest queueDetectParas) {
        HWPuSDK.PU_ITGT_QUEUE_DETECT_PARAM alarmPara = new HWPuSDK.PU_ITGT_QUEUE_DETECT_PARAM();
        alarmPara.ulChannelId = new WinDef.ULONG(Long.valueOf(queueDetectParas.getChannelId()).longValue());
        HWPuSDK.PU_ITGT_QUEUEDETECT_ALG_PARAM stAlgParams = alarmPara.stAlgParams;
        QueueDetectAlgParaRequest algParams = queueDetectParas.getAlgParams();
        stAlgParams.enEnable = algParams.getEnEnable();
        stAlgParams.ulAlarmTime = new WinDef.ULONG(Long.valueOf(algParams.getAlarmTime()).longValue());
        stAlgParams.ulAverTimePerCapita = new WinDef.ULONG(Long.valueOf(algParams.getAverTimePerCapita()).longValue());
        stAlgParams.ulSensitivity = new WinDef.ULONG(Long.valueOf(algParams.getSensitivity()).longValue());
        stAlgParams.ulTimeThreshold = new WinDef.ULONG(Long.valueOf(algParams.getTimeThreshold()).longValue());
        alarmPara.stAlgParams = stAlgParams;
        HWPuSDK.PU_IGT_AERADTC_LIST_S stGuardAreaList = alarmPara.stAreaList;
        IgaArea[] igArea = queueDetectParas.getAreaList().getStArea();
        stGuardAreaList.ulAreaNum = new WinDef.ULONG(queueDetectParas.getAreaList().getAreaNum());
        HWPuSDK.PU_IGT_AREA[] puArea = new HWPuSDK.PU_IGT_AREA[igArea.length];
        for (int i = 0; i < igArea.length; ++i) {
            puArea[i] = this.transIgaArea(igArea[i]);
        }
        stGuardAreaList.stArea = puArea;
        alarmPara.stAreaList = stGuardAreaList;
        HWPuSDK.PU_ALARM_TIME_LIST_S stQlGuardPlan = alarmPara.stGuardPlan;
        BaseAreaParam.AlarmTimeList guardPlan = queueDetectParas.getGuardPlan();
        AlarmTime[] alarmTimes = guardPlan.getAlarmTimes();
        HWPuSDK.PU_ALARM_TIME_S[] puTime = new HWPuSDK.PU_ALARM_TIME_S[(int)guardPlan.getNum()];
        for (int i = 0; i < puTime.length; ++i) {
            puTime[i] = this.transAlarmTime(alarmTimes[i]);
        }
        stQlGuardPlan.ulNum = new WinDef.ULONG(guardPlan.getNum());
        stQlGuardPlan.stAlarmTime = puTime;
        alarmPara.stGuardPlan = stQlGuardPlan;
        return alarmPara;
    }

    private QueueDetectParasRespond toQueueDetectParas(HWPuSDK.PU_ITGT_QUEUE_DETECT_PARAM para) {
        QueueDetectParasRespond queueDetectParas = new QueueDetectParasRespond();
        queueDetectParas.setChannelId(para.ulChannelId.toString());
        QueueDetectAlgParaRespond algPara = new QueueDetectAlgParaRespond();
        algPara.setEnEnable(para.stAlgParams.enEnable);
        algPara.setTimeThreshold(para.stAlgParams.ulTimeThreshold.toString());
        algPara.setAlarmTime(para.stAlgParams.ulAlarmTime.toString());
        algPara.setSensitivity(para.stAlgParams.ulSensitivity.toString());
        algPara.setAverTimePerCapita(para.stAlgParams.ulAverTimePerCapita.toString());
        queueDetectParas.setAlgParams(algPara);
        BaseAreaParam.AreaList areaList = new BaseAreaParam.AreaList();
        HWPuSDK.PU_IGT_AERADTC_LIST_S stAreaList = para.stAreaList;
        areaList.areaNum = stAreaList.ulAreaNum.longValue();
        HWPuSDK.PU_IGT_AREA[] stArea = stAreaList.stArea;
        areaList.setStArea(new IgaArea[stArea.length]);
        for (int i = 0; i < stArea.length; ++i) {
            areaList.stArea[i] = this.toIgaArea1(stArea[i]);
        }
        queueDetectParas.setAreaList(areaList);
        HWPuSDK.PU_ALARM_TIME_LIST_S stHCGuardPlan = para.stGuardPlan;
        BaseAreaParam.AlarmTimeList sdcAlarmTimeList = new BaseAreaParam.AlarmTimeList();
        sdcAlarmTimeList.num = stHCGuardPlan.ulNum.longValue();
        HWPuSDK.PU_ALARM_TIME_S[] stAlarmTime = stHCGuardPlan.stAlarmTime;
        sdcAlarmTimeList.setAlarmTimes(new AlarmTime[stAlarmTime.length]);
        for (int i = 0; i < stAlarmTime.length; ++i) {
            sdcAlarmTimeList.alarmTimes[i] = this.toAlarmTime(stAlarmTime[i]);
        }
        queueDetectParas.setGuardPlan(sdcAlarmTimeList);
        return queueDetectParas;
    }

    private HotMapParasRespond toHotMapParas(HWPuSDK.PU_HOTMAP_PARA para) {
        HotMapParasRespond hotMapParas = new HotMapParasRespond();
        hotMapParas.setChannelId(para.ulChannelId.toString());
        hotMapParas.setEnEnable(para.enEnable);
        hotMapParas.setEnSendMeta(para.enSendMeta);
        hotMapParas.setPtzPara(this.toPTZCurrentLocation(para.stPtzPara));
        BaseAreaParam.AreaList areaList = new BaseAreaParam.AreaList();
        HWPuSDK.PU_HOTMAP_AERADTC_LIST stAreaList = para.stAreaList;
        areaList.areaNum = stAreaList.ulAreaNum.longValue();
        HWPuSDK.PU_IGT_AREA[] stArea = stAreaList.stArea;
        areaList.setStArea(new IgaArea[stArea.length]);
        for (int i = 0; i < stArea.length; ++i) {
            areaList.stArea[i] = this.toIgaArea1(stArea[i]);
        }
        hotMapParas.setAreaList(areaList);
        return hotMapParas;
    }

    private HWPuSDK.PU_HOTMAP_PARA transHotMapParas(HotMapParasRequest hotMapParas) {
        HWPuSDK.PU_HOTMAP_PARA para = new HWPuSDK.PU_HOTMAP_PARA();
        para.ulChannelId = new NativeLong(101L);
        para.enEnable = hotMapParas.getEnEnable();
        para.enSendMeta = hotMapParas.getEnSendMeta();
        para.stPtzPara = this.transPTZCurrentLocation(hotMapParas.getPtzPara());
        HWPuSDK.PU_HOTMAP_AERADTC_LIST stAreaList = para.stAreaList;
        IgaArea[] stArea = hotMapParas.getAreaList().getStArea();
        HWPuSDK.PU_IGT_AREA[] puArea = new HWPuSDK.PU_IGT_AREA[stArea.length];
        for (int i = 0; i < stArea.length; ++i) {
            puArea[i] = this.transIgaArea(stArea[i]);
        }
        stAreaList.ulAreaNum = new WinDef.ULONG(hotMapParas.getAreaList().getAreaNum());
        stAreaList.stArea = puArea;
        para.stAreaList = stAreaList;
        return para;
    }

    private HWPuSDK.PU_HUMANCOUNT_PARAM transHumanCountParas(HumanCountParasRequest humanCountParas) {
        HWPuSDK.PU_HUMANCOUNT_PARAM alarmPara = new HWPuSDK.PU_HUMANCOUNT_PARAM();
        HumanCountAlgParaRequest humanCountAlgPara = humanCountParas.getAlgParams();
        alarmPara.ulChannelId = new WinDef.ULONG(Long.valueOf(humanCountParas.getChannelId()).longValue());
        HWPuSDK.PU_HUMANCOUNT_ALG_PARAM stAlgParams = alarmPara.stAlgParams;
        stAlgParams.enHCEnable = new WinDef.BOOL(humanCountAlgPara.isEnHCEnable());
        stAlgParams.enOSDEnable = new WinDef.BOOL(humanCountAlgPara.isEnOSDEnable());
        stAlgParams.enClearAtZero = new WinDef.BOOL(humanCountAlgPara.isEnClearAtZero());
        stAlgParams.stOSDLocation = this.transIgtPoint1(humanCountAlgPara.getStOSDLocation());
        stAlgParams.ulSensitivity = new WinDef.ULONG(humanCountAlgPara.getSensitivity());
        stAlgParams.ulAlarmTime = new WinDef.ULONG(humanCountAlgPara.getAlarmTime());
        stAlgParams.ulAlarmHumanNum = new WinDef.ULONG(humanCountAlgPara.getAlarmHumanNum());
        stAlgParams.ulMinHeadSize = new WinDef.ULONG(humanCountAlgPara.getMinHeadSize());
        stAlgParams.stRefLine = this.transLine(humanCountAlgPara.getStRefLine());
        stAlgParams.enInDir = humanCountAlgPara.getEnInDir();
        alarmPara.stAlgParams = stAlgParams;
        HWPuSDK.PU_IGT_AERADTC_LIST_S stGuardAreaList = alarmPara.stGuardAreaList;
        IgaArea[] igArea = humanCountParas.getAreaList().getStArea();
        stGuardAreaList.ulAreaNum = new WinDef.ULONG(humanCountParas.getAreaList().getAreaNum());
        HWPuSDK.PU_IGT_AREA[] puArea = new HWPuSDK.PU_IGT_AREA[igArea.length];
        for (int i = 0; i < igArea.length; ++i) {
            puArea[i] = this.transIgaArea(igArea[i]);
        }
        stGuardAreaList.stArea = puArea;
        alarmPara.stGuardAreaList = stGuardAreaList;
        HWPuSDK.PU_ALARM_TIME_LIST_S stHCGuardPlan = alarmPara.stHCGuardPlan;
        BaseAreaParam.AlarmTimeList guardPlan = humanCountParas.getGuardPlan();
        AlarmTime[] alarmTimes = guardPlan.getAlarmTimes();
        HWPuSDK.PU_ALARM_TIME_S[] puTime = new HWPuSDK.PU_ALARM_TIME_S[(int)guardPlan.getNum()];
        for (int i = 0; i < puTime.length; ++i) {
            puTime[i] = this.transAlarmTime(alarmTimes[i]);
        }
        stHCGuardPlan.ulNum = new WinDef.ULONG(guardPlan.getNum());
        stHCGuardPlan.stAlarmTime = puTime;
        alarmPara.stHCGuardPlan = stHCGuardPlan;
        return alarmPara;
    }

    private HumanCountParasRespond toHumanCountParas(HWPuSDK.PU_HUMANCOUNT_PARAM alarmPara) {
        HumanCountParasRespond humanCountParas = new HumanCountParasRespond();
        HumanCountAlgParaRespond humanCountAlgPara = new HumanCountAlgParaRespond();
        humanCountParas.setChannelId(alarmPara.ulChannelId.toString());
        humanCountAlgPara.setEnHCEnable(alarmPara.stAlgParams.enHCEnable.booleanValue());
        humanCountAlgPara.setEnOSDEnable(alarmPara.stAlgParams.enOSDEnable.booleanValue());
        humanCountAlgPara.setEnClearAtZero(alarmPara.stAlgParams.enClearAtZero.booleanValue());
        humanCountAlgPara.setStOSDLocation(this.toIgtPoint_p(alarmPara.stAlgParams.stOSDLocation));
        humanCountAlgPara.setSensitivity(alarmPara.stAlgParams.ulSensitivity.longValue());
        humanCountAlgPara.setAlarmTime(alarmPara.stAlgParams.ulAlarmTime.longValue());
        humanCountAlgPara.setAlarmHumanNum(alarmPara.stAlgParams.ulAlarmHumanNum.longValue());
        humanCountAlgPara.setMinHeadSize(alarmPara.stAlgParams.ulMinHeadSize.longValue());
        humanCountAlgPara.setStRefLine(this.toLine(alarmPara.stAlgParams.stRefLine));
        humanCountAlgPara.setEnInDir(alarmPara.stAlgParams.enInDir);
        humanCountParas.setAlgParams(humanCountAlgPara);
        BaseAreaParam.AreaList areaList = new BaseAreaParam.AreaList();
        HWPuSDK.PU_IGT_AERADTC_LIST_S stGuardAreaList = alarmPara.stGuardAreaList;
        areaList.areaNum = stGuardAreaList.ulAreaNum.longValue();
        HWPuSDK.PU_IGT_AREA[] stArea = stGuardAreaList.stArea;
        areaList.setStArea(new IgaArea[stArea.length]);
        for (int i = 0; i < stArea.length; ++i) {
            areaList.stArea[i] = this.toIgaArea1(stArea[i]);
        }
        humanCountParas.setAreaList(areaList);
        HWPuSDK.PU_ALARM_TIME_LIST_S stHCGuardPlan = alarmPara.stHCGuardPlan;
        BaseAreaParam.AlarmTimeList sdcAlarmTimeList = new BaseAreaParam.AlarmTimeList();
        sdcAlarmTimeList.num = stHCGuardPlan.ulNum.longValue();
        HWPuSDK.PU_ALARM_TIME_S[] stAlarmTime = stHCGuardPlan.stAlarmTime;
        sdcAlarmTimeList.setAlarmTimes(new AlarmTime[stAlarmTime.length]);
        for (int i = 0; i < stAlarmTime.length; ++i) {
            sdcAlarmTimeList.alarmTimes[i] = this.toAlarmTime(stAlarmTime[i]);
        }
        humanCountParas.setGuardPlan(sdcAlarmTimeList);
        return humanCountParas;
    }

    public IgaArea toIgaArea1(HWPuSDK.PU_IGT_AREA igtArea) {
        IgaArea enterArea = new IgaArea();
        enterArea.setPointNum(igtArea.uPointNum);
        HWPuSDK.PU_IGT_POINT_S[] stPoint = igtArea.stPoint;
        enterArea.setPoint(new IgtPoint[stPoint.length]);
        for (int i = 0; i < stPoint.length; ++i) {
            enterArea.getPoint()[i] = this.toIgtPoint(stPoint[i]);
        }
        enterArea.setAreaIndex(igtArea.ulAreaIndex.longValue());
        enterArea.enable = igtArea.bEnable.booleanValue();
        enterArea.setAreaName(new String(igtArea.szAreaName).trim());
        enterArea.setLocation(this.toPTZCurrentLocation(igtArea.stLocation));
        return enterArea;
    }

    private IgtPoint toIgtPoint_p(HWPuSDK.PU_POINT igtPoint) {
        IgtPoint igtPoint1 = new IgtPoint();
        igtPoint1.setPointPosX(igtPoint.usPosX.shortValue());
        igtPoint1.setPointPosY(igtPoint.usPosY.shortValue());
        return igtPoint1;
    }

    public HWPuSDK.PU_POINT transIgtPoint1(IgtPoint igtPoint) {
        HWPuSDK.PU_POINT puIgtPointS = new HWPuSDK.PU_POINT();
        puIgtPointS.usPosY = new WinDef.USHORT((long)igtPoint.getPointPosX());
        puIgtPointS.usPosY = new WinDef.USHORT((long)igtPoint.getPointPosY());
        return puIgtPointS;
    }

    private IgtLine toLine(HWPuSDK.PU_HC_LINE_S line) {
        IgtLine line1 = new IgtLine();
        IgtPoint igtPointStart = new IgtPoint();
        IgtPoint igtPointEnd = new IgtPoint();
        igtPointStart.setPointPosX(line.stPtS.usPosX.shortValue());
        igtPointStart.setPointPosY(line.stPtS.usPosY.shortValue());
        igtPointEnd.setPointPosX(line.stPtE.usPosX.shortValue());
        igtPointEnd.setPointPosY(line.stPtE.usPosY.shortValue());
        line1.setStartPoint(igtPointStart);
        line1.setEndPoint(igtPointEnd);
        return line1;
    }

    private HWPuSDK.PU_HC_LINE_S transLine(IgtLine line) {
        HWPuSDK.PU_HC_LINE_S PULine = new HWPuSDK.PU_HC_LINE_S();
        PULine.stPtS.usPosX = new WinDef.USHORT((long)line.getStartPoint().getPointPosX());
        PULine.stPtS.usPosY = new WinDef.USHORT((long)line.getStartPoint().getPointPosY());
        PULine.stPtE.usPosY = new WinDef.USHORT((long)line.getEndPoint().getPointPosX());
        PULine.stPtE.usPosY = new WinDef.USHORT((long)line.getEndPoint().getPointPosY());
        return PULine;
    }
}

