/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.impl;

import com.sun.jna.platform.win32.WinDef;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.DeviceRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.CaptureImageRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.FaceLibraryParaRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.FaceRecordParaRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.FaceRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.IpcEmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.CaptureImageRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.FaceLibraryParaRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.FaceRecordParaRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.exception.IpcException;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.AbstractSdkService;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.HWPuSDK;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.SdkInstance;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.util.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.ipc.service.FaceLibraryService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import sun.misc.BASE64Encoder;

@Component(value="SdcFaceLibraryServiceSdkImpl")
public class SdcFaceLibraryServiceSdkImpl
extends AbstractSdkService
implements FaceLibraryService {
    private static final Logger log = LoggerFactory.getLogger(SdcFaceLibraryServiceSdkImpl.class);

    public boolean addFaceLibrary(DeviceRequest<FaceLibraryParaRequest> request) {
        boolean success = false;
        String session = request.getSession();
        FaceLibraryParaRequest libraryPara = (FaceLibraryParaRequest)request.getRequest();
        HWPuSDK.PU_FACE_LIB_SET_S faceLibSet = new HWPuSDK.PU_FACE_LIB_SET_S();
        faceLibSet.ulChannelId = new WinDef.ULONG(101L);
        faceLibSet.enOptType = 1;
        faceLibSet.stFacelib.enLibType = libraryPara.getFaceListType();
        try {
            faceLibSet.stFacelib.szLibName = this.isOSLinux() ? ByteBuffer.allocate(65).put(libraryPara.getFaceListName().getBytes(StandardCharsets.UTF_8)).array() : ByteBuffer.allocate(65).put(libraryPara.getFaceListName().getBytes("GBK")).array();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        faceLibSet.stFacelib.uiThreshold = new WinDef.ULONG((long)libraryPara.getThreshold());
        success = SdkInstance.getInstance().IVS_PU_SetFaceLib(new WinDef.ULONG(Long.valueOf(session).longValue()), faceLibSet);
        if (!success) {
            log.error("addFaceLibrary error:" + this.errorDetail());
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        log.debug("addFaceLibrary success");
        return success;
    }

    public List<FaceLibraryParaRespond> getFaceLibraryList(DeviceRequest<IpcEmptyRequest> request) {
        String session = request.getSession();
        HWPuSDK.PU_FACE_LIB_GET_S faceLib = new HWPuSDK.PU_FACE_LIB_GET_S();
        faceLib.ulChannelId = new WinDef.ULONG(101L);
        faceLib.szFindResultPath = ByteBuffer.allocate(256).put(HWPuSDK.faceLibInfoPath.getBytes()).array();
        boolean success = SdkInstance.getInstance().IVS_PU_GetFaceLib(new WinDef.ULONG(Long.valueOf(session).longValue()), faceLib);
        if (success) {
            log.debug("getFaceLibraryList success");
            List list = JsonUtil.getJsonFaceLibraryList();
            return list;
        }
        log.error("getFaceLibraryList error, code: {}, msg: {}", (Object)this.errorCode(), (Object)this.errorMsg());
        throw new IpcException(this.errorDetail());
    }

    public boolean deleteFaceLibrary(DeviceRequest<FaceLibraryParaRequest> request) {
        boolean success = false;
        String session = request.getSession();
        FaceLibraryParaRequest libraryPara = (FaceLibraryParaRequest)request.getRequest();
        HWPuSDK.PU_FACE_LIB_SET_S faceLibSet = new HWPuSDK.PU_FACE_LIB_SET_S();
        faceLibSet.ulChannelId = new WinDef.ULONG(101L);
        faceLibSet.enOptType = 3;
        faceLibSet.stFacelib.ulFaceLibID = new WinDef.ULONG(Long.valueOf(libraryPara.getId()).longValue());
        try {
            faceLibSet.stFacelib.szLibName = this.isOSLinux() ? ByteBuffer.allocate(65).put(libraryPara.getFaceListName().getBytes(StandardCharsets.UTF_8)).array() : ByteBuffer.allocate(65).put(libraryPara.getFaceListName().getBytes("GBK")).array();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        success = SdkInstance.getInstance().IVS_PU_SetFaceLib(new WinDef.ULONG(Long.valueOf(session).longValue()), faceLibSet);
        if (success) {
            log.debug("deleteFaceLibrary success");
            return success;
        }
        log.error("deleteFaceLibrary error:" + this.errorDetail());
        throw new IpcException(this.errorDetail());
    }

    public boolean updateFaceLibrary(DeviceRequest<FaceLibraryParaRequest> request) {
        boolean success = false;
        String session = request.getSession();
        FaceLibraryParaRequest libraryPara = (FaceLibraryParaRequest)request.getRequest();
        HWPuSDK.PU_FACE_LIB_SET_S faceLibSet = new HWPuSDK.PU_FACE_LIB_SET_S();
        faceLibSet.ulChannelId = new WinDef.ULONG(101L);
        faceLibSet.enOptType = 2;
        faceLibSet.stFacelib = new HWPuSDK.PU_FACE_LIB_S.ByValue();
        faceLibSet.stFacelib.ulFaceLibID = new WinDef.ULONG(Long.valueOf(libraryPara.getId()).longValue());
        faceLibSet.stFacelib.enLibType = libraryPara.getFaceListType();
        faceLibSet.stFacelib.isControl = libraryPara.getOnControl();
        faceLibSet.stFacelib.uiThreshold = new WinDef.ULONG((long)libraryPara.getThreshold());
        try {
            faceLibSet.stFacelib.szLibName = this.isOSLinux() ? ByteBuffer.allocate(65).put(libraryPara.getFaceListName().getBytes(StandardCharsets.UTF_8)).array() : ByteBuffer.allocate(65).put(libraryPara.getFaceListName().getBytes("GBK")).array();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        success = SdkInstance.getInstance().IVS_PU_SetFaceLib(new WinDef.ULONG(Long.valueOf(session).longValue()), faceLibSet);
        if (!success) {
            log.error("deleteFaceLibrary error:" + this.errorDetail());
            throw new IpcException(this.errorDetail());
        }
        log.debug("dFaceLibrary success");
        return success;
    }

    public boolean addOneFace(DeviceRequest<FaceRequest> request) {
        boolean success = false;
        String session = request.getSession();
        Long loginIdL = Long.valueOf(session);
        FaceRequest faceRequest = (FaceRequest)request.getRequest();
        FaceLibraryParaRequest libraryPara = faceRequest.getFaceLibraryPara();
        FaceRecordParaRequest faceRecordPara = faceRequest.getFaceRecordPara();
        HWPuSDK.PU_FACE_INFO_ADD_S faceInfoAdd = new HWPuSDK.PU_FACE_INFO_ADD_S();
        faceInfoAdd.ulChannelId = new WinDef.ULONG(101L);
        HWPuSDK.PU_FACE_LIB_S.ByValue faceLibByValue = new HWPuSDK.PU_FACE_LIB_S.ByValue();
        faceLibByValue.ulFaceLibID = new WinDef.ULONG(Long.parseLong(libraryPara.getId()));
        faceLibByValue.isControl = libraryPara.getOnControl();
        faceLibByValue.enLibType = libraryPara.getFaceListType();
        faceLibByValue.uiThreshold = new WinDef.ULONG((long)libraryPara.getThreshold());
        try {
            faceLibByValue.szLibName = this.isOSLinux() ? ByteBuffer.allocate(65).put(libraryPara.getFaceListName().getBytes(StandardCharsets.UTF_8)).array() : ByteBuffer.allocate(65).put(libraryPara.getFaceListName().getBytes("GBK")).array();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        faceInfoAdd.stFacelib = faceLibByValue;
        File file = new File(faceRecordPara.getPicPath());
        String fileName = file.getName();
        faceInfoAdd.stRecord = this.toHWFaceRecode(faceRecordPara);
        faceInfoAdd.stRecord.ulFaceId = new WinDef.ULONG(0L);
        success = SdkInstance.getInstance().IVS_PU_AddOneFaceV2(new WinDef.ULONG(loginIdL.longValue()), faceInfoAdd, fileName);
        if (success) {
            log.debug("addOneFace success\uff1a" + success);
            HWPuSDK.PU_FACE_FEATURE_EXTRACT_S extractS = new HWPuSDK.PU_FACE_FEATURE_EXTRACT_S();
            extractS.stFacelib = faceInfoAdd.stFacelib;
            extractS.ulChannelId = new WinDef.ULONG(101L);
            boolean b = SdkInstance.getInstance().IVS_PU_FeatureExtract(new WinDef.ULONG(loginIdL.longValue()), extractS);
            if (b) {
                this.checkImportStatus(session, extractS.stFacelib, extractS.taskID);
            }
        } else {
            log.error("addOneFace error\uff1a" + this.errorDetail());
            throw new IpcException(this.errorDetail());
        }
        return success;
    }

    public boolean modifyFaceInfo(DeviceRequest<FaceRequest> request) {
        boolean success = false;
        String session = request.getSession();
        FaceRequest faceRequest = (FaceRequest)request.getRequest();
        FaceLibraryParaRequest faceLibraryPara = faceRequest.getFaceLibraryPara();
        FaceRecordParaRequest faceRecordPara = faceRequest.getFaceRecordPara();
        HWPuSDK.PU_FACE_INFO_MODIFY_S faceInfoModify = new HWPuSDK.PU_FACE_INFO_MODIFY_S();
        faceInfoModify.ulChannelId = new WinDef.ULONG(101L);
        HWPuSDK.PU_FACE_LIB_S.ByValue faceLibByValue = new HWPuSDK.PU_FACE_LIB_S.ByValue();
        faceLibByValue.ulFaceLibID = new WinDef.ULONG(Long.parseLong(faceLibraryPara.getId()));
        faceLibByValue.isControl = faceLibraryPara.getOnControl();
        faceLibByValue.enLibType = faceLibraryPara.getFaceListType();
        faceLibByValue.uiThreshold = new WinDef.ULONG((long)faceLibraryPara.getThreshold());
        try {
            faceLibByValue.szLibName = this.isOSLinux() ? ByteBuffer.allocate(65).put(faceLibraryPara.getFaceListName().getBytes(StandardCharsets.UTF_8)).array() : ByteBuffer.allocate(65).put(faceLibraryPara.getFaceListName().getBytes("GBK")).array();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        faceInfoModify.stFacelib = faceLibByValue;
        faceInfoModify.stRecord = this.toHWFaceRecode(faceRecordPara);
        success = SdkInstance.getInstance().IVS_PU_FaceInfoModify(new WinDef.ULONG(Long.parseLong(session)), faceInfoModify);
        if (!success) {
            log.error("faceInfoModify error:" + this.errorDetail());
            throw new IpcException(this.errorDetail());
        }
        log.debug("faceInfoModify success\uff1a" + success);
        return success;
    }

    public List<FaceRecordParaRespond> findFaceList(DeviceRequest<FaceRequest> request) {
        String session = request.getSession();
        FaceRequest faceRequest = (FaceRequest)request.getRequest();
        FaceLibraryParaRequest faceLibraryPara = faceRequest.getFaceLibraryPara();
        FaceRecordParaRequest faceRecordPara = faceRequest.getFaceRecordPara();
        HWPuSDK.PU_FACE_INFO_FIND_S faceInfoFind = new HWPuSDK.PU_FACE_INFO_FIND_S();
        faceInfoFind.ulChannelId = new WinDef.ULONG(101L);
        faceInfoFind.stFacelib = new HWPuSDK.PU_FACE_LIB_S.ByValue();
        faceInfoFind.stFacelib.ulFaceLibID = new WinDef.ULONG(Long.valueOf(faceLibraryPara.getId()).longValue());
        faceInfoFind.uFindNum = 0;
        faceInfoFind.uStartIndex = 0;
        HWPuSDK.PU_FACE_FIND_CONDITION_S faceFindCondition = this.toHWFaceFindCondition(faceRecordPara);
        faceInfoFind.stCondition = new HWPuSDK.PU_FACE_FIND_CONDITION_S.ByValue();
        faceInfoFind.stCondition.szName = faceFindCondition.szName;
        faceInfoFind.stCondition.enGender = faceFindCondition.enGender;
        faceInfoFind.stCondition.enCardType = faceFindCondition.enCardType;
        faceInfoFind.stCondition.szCardID = faceFindCondition.szCardID;
        faceInfoFind.stCondition.szProvince = faceFindCondition.szProvince;
        faceInfoFind.stCondition.szCity = faceFindCondition.szCity;
        faceInfoFind.stCondition.enFeatureStatus = 1;
        faceInfoFind.szFindResultPath = ByteBuffer.allocate(257).put(HWPuSDK.faceInfoPath.getBytes()).array();
        boolean success = SdkInstance.getInstance().IVS_PU_FindFaceInfo(new WinDef.ULONG(Long.valueOf(session).longValue()), faceInfoFind);
        if (success) {
            log.debug("getFaceList success:" + success);
            List jsonFaceList = JsonUtil.getJsonFaceRecordList();
            return jsonFaceList;
        }
        log.error("getFaceList success:" + this.errorDetail());
        throw new IpcException(this.errorDetail());
    }

    public boolean deleteFaceInfo(DeviceRequest<FaceRequest> request) {
        boolean success = false;
        String session = request.getSession();
        FaceRequest faceRequest = (FaceRequest)request.getRequest();
        List faceParaList = faceRequest.getFaceRecordList();
        FaceLibraryParaRequest faceLibraryPara = faceRequest.getFaceLibraryPara();
        if (faceParaList != null && faceParaList.size() > 0) {
            int[] faceIdArr = new int[100];
            for (int i = 0; i < faceParaList.size(); ++i) {
                faceIdArr[i] = Integer.valueOf(((FaceRecordParaRequest)faceParaList.get(i)).getId());
            }
            HWPuSDK.PU_FACE_INFO_DELETE_S faceInfoDelete = new HWPuSDK.PU_FACE_INFO_DELETE_S();
            faceInfoDelete.ulChannelId = new WinDef.ULONG(101L);
            faceInfoDelete.stFacelib = new HWPuSDK.PU_FACE_LIB_S.ByValue();
            faceInfoDelete.stFacelib.ulFaceLibID = new WinDef.ULONG(Long.valueOf(faceLibraryPara.getId()).longValue());
            faceInfoDelete.uFaceNum = faceParaList.size();
            faceInfoDelete.uFaceID = faceIdArr;
            success = SdkInstance.getInstance().IVS_PU_DelFaceInfo(new WinDef.ULONG(Long.valueOf(session).longValue()), faceInfoDelete);
            if (success) {
                log.debug("getFaceList success:" + success);
            } else {
                log.error("getFaceList fail:" + this.errorDetail());
                throw new IpcException(this.errorDetail());
            }
        }
        return success;
    }

    public HWPuSDK.PU_FACE_RECORD_S.ByValue toHWFaceRecode(FaceRecordParaRequest facePara) {
        HWPuSDK.PU_FACE_RECORD_S.ByValue faceRecord = new HWPuSDK.PU_FACE_RECORD_S.ByValue();
        faceRecord.ulFaceId = new WinDef.ULONG(Long.parseLong(facePara.getFaceId()));
        faceRecord.enGender = facePara.getGender();
        faceRecord.enCardType = facePara.getCardType();
        try {
            if (this.isOSLinux()) {
                faceRecord.szName = Arrays.copyOf((facePara.getName() != null ? facePara.getName() : "").getBytes(StandardCharsets.UTF_8), 64);
                faceRecord.szCardID = ByteBuffer.allocate(32).put((facePara.getCardId() != null ? facePara.getCardId() : "").getBytes(StandardCharsets.UTF_8)).array();
                faceRecord.szPicPath = ByteBuffer.allocate(256).put((facePara.getPicPath() != null ? facePara.getPicPath() : "").getBytes(StandardCharsets.UTF_8)).array();
            } else {
                faceRecord.szName = Arrays.copyOf((facePara.getName() != null ? facePara.getName() : "").getBytes("GBK"), 64);
                faceRecord.szCardID = ByteBuffer.allocate(32).put((facePara.getCardId() != null ? facePara.getCardId() : "").getBytes("GBK")).array();
                faceRecord.szPicPath = ByteBuffer.allocate(256).put((facePara.getPicPath() != null ? facePara.getPicPath() : "").getBytes("GBK")).array();
            }
            faceRecord.szProvince = Arrays.copyOf((facePara.getProvince() != null ? facePara.getProvince() : "").getBytes("GBK"), 32);
            faceRecord.szCity = Arrays.copyOf((facePara.getCity() != null ? facePara.getCity() : "").getBytes("GBK"), 48);
            faceRecord.szBirthday = Arrays.copyOf((facePara.getBirthDay() != null ? facePara.getBirthDay() : "").getBytes(), 32);
            faceRecord.szExtensionField = ByteBuffer.allocate(512).put("".getBytes()).array();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return faceRecord;
    }

    public void checkImportStatus(String loginId, HWPuSDK.PU_FACE_LIB_S stFacelib, WinDef.ULONG taskId) {
        HWPuSDK.PU_FACE_LIB_STATUS_S libStatus = new HWPuSDK.PU_FACE_LIB_STATUS_S();
        boolean success = false;
        while (!libStatus.status.booleanValue()) {
            libStatus.ulChannelId = new WinDef.ULONG(101L);
            libStatus.stFacelib.ulFaceLibID = stFacelib.ulFaceLibID;
            libStatus.taskID = taskId;
            try {
                libStatus.szResultCsvPath = this.isOSLinux() ? Arrays.copyOf(HWPuSDK.pathImport.getBytes(StandardCharsets.UTF_8), 256) : Arrays.copyOf(HWPuSDK.pathImport.getBytes("GBK"), 256);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            success = SdkInstance.getInstance().IVS_PU_CheckImportStatus(new WinDef.ULONG(Long.valueOf(loginId).longValue()), libStatus);
        }
        if (success) {
            log.debug("importFace success :" + success);
        } else {
            log.error("importFace error:" + this.errorDetail());
        }
    }

    public HWPuSDK.PU_FACE_FIND_CONDITION_S toHWFaceFindCondition(FaceRecordParaRequest facePara) {
        HWPuSDK.PU_FACE_FIND_CONDITION_S faceFindCondition = new HWPuSDK.PU_FACE_FIND_CONDITION_S();
        faceFindCondition.enGender = -1;
        faceFindCondition.enCardType = -1;
        faceFindCondition.enFeatureStatus = 1;
        try {
            if (this.isOSLinux()) {
                faceFindCondition.szName = ByteBuffer.allocate(64).put((facePara.getName() != null ? facePara.getName() : "").getBytes(StandardCharsets.UTF_8)).array();
                faceFindCondition.szCardID = ByteBuffer.allocate(32).put((facePara.getCardId() != null ? facePara.getCardId() : "").getBytes(StandardCharsets.UTF_8)).array();
                faceFindCondition.szProvince = ByteBuffer.allocate(32).put((facePara.getProvince() != null ? facePara.getProvince() : "").getBytes(StandardCharsets.UTF_8)).array();
                faceFindCondition.szCity = ByteBuffer.allocate(48).put((facePara.getCity() != null ? facePara.getCity() : "").getBytes(StandardCharsets.UTF_8)).array();
            } else {
                faceFindCondition.szName = ByteBuffer.allocate(64).put((facePara.getName() != null ? facePara.getName() : "").getBytes("GBK")).array();
                faceFindCondition.szCardID = ByteBuffer.allocate(32).put((facePara.getCardId() != null ? facePara.getCardId() : "").getBytes("GBK")).array();
                faceFindCondition.szProvince = ByteBuffer.allocate(32).put((facePara.getProvince() != null ? facePara.getProvince() : "").getBytes("GBK")).array();
                faceFindCondition.szCity = ByteBuffer.allocate(48).put((facePara.getCity() != null ? facePara.getCity() : "").getBytes("GBK")).array();
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return faceFindCondition;
    }

    public CaptureImageRespond saveManualSnapshot(DeviceRequest<CaptureImageRequest> request) {
        HWPuSDK.SNAPSHOT_PARA snapshotPara = new HWPuSDK.SNAPSHOT_PARA();
        snapshotPara.ulChannelID = new WinDef.ULONG(101L);
        snapshotPara.ulStreamID = new WinDef.ULONG(0L);
        snapshotPara.enPictureFormat = 1;
        String timeStamp = System.currentTimeMillis() + ".jpeg";
        File file = new File(((CaptureImageRequest)request.getRequest()).getImagePath());
        if (!file.exists()) {
            file.mkdirs();
        }
        String imagePath = ((CaptureImageRequest)request.getRequest()).getImagePath() + "\\" + timeStamp;
        imagePath = imagePath.replaceAll("\\\\\\\\", "\\\\");
        try {
            snapshotPara.szPicPath = this.isOSLinux() ? Arrays.copyOf(imagePath.getBytes(StandardCharsets.UTF_8), 516) : Arrays.copyOf(imagePath.getBytes("GBK"), 516);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        boolean success = SdkInstance.getInstance().IVS_PU_ManualSnapshot(new WinDef.ULONG(Long.parseLong(request.getSession())), snapshotPara);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        CaptureImageRespond captureImageRespond = new CaptureImageRespond();
        captureImageRespond.setImagePath(imagePath);
        return captureImageRespond;
    }

    public String saveBase64ManualSnapshot(DeviceRequest<CaptureImageRequest> request) {
        CaptureImageRequest captureImageRequest = new CaptureImageRequest();
        captureImageRequest.setImagePath(((CaptureImageRequest)request.getRequest()).getImagePath());
        DeviceRequest imageRequestRequest = new DeviceRequest();
        imageRequestRequest.setRequest((Object)captureImageRequest);
        imageRequestRequest.setSession(request.getSession());
        CaptureImageRespond captureImageRespond = this.saveManualSnapshot(imageRequestRequest);
        if (StringUtils.isNotBlank((CharSequence)captureImageRespond.getImagePath())) {
            String imgFileToBase64 = this.getImgFileToBase64(captureImageRespond.getImagePath());
            File file = new File(captureImageRespond.getImagePath());
            if (file.exists()) {
                file.delete();
            }
            return imgFileToBase64;
        }
        throw new IpcException(this.errorCode(), this.errorDetail());
    }

    public boolean getFaceImage(DeviceRequest<FaceRequest> request) {
        FaceRequest faceRequest = (FaceRequest)request.getRequest();
        HWPuSDK.PU_FACE_PIC_GET_S facePicGet = new HWPuSDK.PU_FACE_PIC_GET_S();
        facePicGet.ulChannelId = new WinDef.ULONG(101L);
        HWPuSDK.PU_FACE_LIB_S faceLibs = new HWPuSDK.PU_FACE_LIB_S();
        faceLibs.ulFaceLibID = new WinDef.ULONG(Long.parseLong(faceRequest.getFaceLibraryPara().getId()));
        facePicGet.stFacelib = faceLibs;
        facePicGet.uFaceID = new WinDef.ULONG(Long.parseLong(faceRequest.getFaceRecordPara().getFaceId()));
        facePicGet.szFindResultPath = ByteBuffer.allocate(257).put(faceRequest.getFaceRecordPara().getPicPath().getBytes(StandardCharsets.UTF_8)).array();
        boolean success = SdkInstance.getInstance().IVS_PU_GetFacePicture(new WinDef.ULONG(Long.parseLong(request.getSession())), facePicGet);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        return true;
    }

    public boolean importFaceLibrary(DeviceRequest<FaceRequest> request) {
        log.info("\u5f00\u59cb\u5bfc\u5165...");
        FaceRequest faceRequest = (FaceRequest)request.getRequest();
        FaceLibraryParaRequest libraryPara = faceRequest.getFaceLibraryPara();
        HWPuSDK.PU_FACE_LIB_IMPORT_S faceLibImport = new HWPuSDK.PU_FACE_LIB_IMPORT_S();
        faceLibImport.ulChannelId = new WinDef.ULONG(101L);
        faceLibImport.enPacketType = 0;
        faceLibImport.stFacelib = new HWPuSDK.PU_FACE_LIB_S.ByValue();
        faceLibImport.stFacelib.ulFaceLibID = new WinDef.ULONG(Long.parseLong(libraryPara.getId()));
        faceLibImport.stFacelib.isControl = libraryPara.getOnControl();
        faceLibImport.stFacelib.uiThreshold = new WinDef.ULONG((long)libraryPara.getThreshold());
        faceLibImport.stFacelib.enLibType = libraryPara.getFaceListType();
        try {
            faceLibImport.szFileName = Arrays.copyOf(faceRequest.getFaceFile().getName().getBytes("GBK"), 128);
            faceLibImport.szPath = Arrays.copyOf(faceRequest.getFaceFile().getAbsolutePath().getBytes("GBK"), 256);
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        boolean success = SdkInstance.getInstance().IVS_PU_ImportFaceLibEx(new WinDef.ULONG(Long.parseLong(request.getSession())), faceLibImport);
        if (success) {
            log.info("\u5bfc\u5165\u6210\u529f...");
            this.checkImportStatus(request.getSession(), (HWPuSDK.PU_FACE_LIB_S)faceLibImport.stFacelib, faceLibImport.taskID);
            HWPuSDK.PU_FACE_FEATURE_EXTRACT_S extractS = new HWPuSDK.PU_FACE_FEATURE_EXTRACT_S();
            extractS.stFacelib = faceLibImport.stFacelib;
            extractS.stFacelib.szLibName = ByteBuffer.allocate(65).put(libraryPara.getFaceListName().getBytes(StandardCharsets.UTF_8)).array();
            System.out.println(new String(extractS.stFacelib.szLibName));
            extractS.ulChannelId = new WinDef.ULONG(101L);
            boolean flag = SdkInstance.getInstance().IVS_PU_FeatureExtract(new WinDef.ULONG(Long.parseLong(request.getSession())), extractS);
            if (flag) {
                this.checkImportStatus(request.getSession(), extractS.stFacelib, extractS.taskID);
            }
        } else {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getImgFileToBase64(String imgFile) {
        FileInputStream inputStream = null;
        byte[] buffer = null;
        try {
            inputStream = new FileInputStream(imgFile);
            int count = 0;
            while (count == 0) {
                count = ((InputStream)inputStream).available();
            }
            buffer = new byte[count];
            ((InputStream)inputStream).read(buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return new BASE64Encoder().encode(buffer);
    }

    public boolean isOSLinux() {
        Properties prop = System.getProperties();
        String os = prop.getProperty("os.name");
        return os != null && os.toLowerCase().contains("linux");
    }
}

