/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.impl;

import com.alibaba.fastjson.JSONObject;
import com.sun.jna.NativeLong;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.ptr.LongByReference;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.ChannelInfo;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.DeviceBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.DeviceRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.OsdDateTimePara;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.OsdInfo;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.OsdStringPara;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.StreamAbilityPara;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.StreamAttribute;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.DiscoveryDeviceRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.IpcEmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.OsdPartcularParaRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.RtspRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.VideoStreamRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.DeviceAbilityRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.DeviceInfoRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.DiscoveryDeviceRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.MasterSlaveChannelInfoRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.OsdPartcularParaRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.StreamAbilityRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.VideoStreamRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.enums.BitRateType;
import com.zkteco.zkbiosecurity.cuserver.ipc.enums.FrameBitMode;
import com.zkteco.zkbiosecurity.cuserver.ipc.enums.MirrorMode;
import com.zkteco.zkbiosecurity.cuserver.ipc.enums.PicQuality;
import com.zkteco.zkbiosecurity.cuserver.ipc.enums.StreamMode;
import com.zkteco.zkbiosecurity.cuserver.ipc.enums.StreamType;
import com.zkteco.zkbiosecurity.cuserver.ipc.enums.VideoEncodeMode;
import com.zkteco.zkbiosecurity.cuserver.ipc.enums.VideoFormat;
import com.zkteco.zkbiosecurity.cuserver.ipc.exception.IpcException;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.AbstractSdkService;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.HWPuSDK;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.SdkInstance;
import com.zkteco.zkbiosecurity.cuserver.ipc.service.DeviceService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SdcDeviceServiceImpl
extends AbstractSdkService
implements DeviceService {
    public boolean reboot(DeviceRequest<IpcEmptyRequest> request) {
        boolean success = SdkInstance.getInstance().IVS_PU_Reboot(new NativeLong(Long.parseLong(request.getSession())));
        if (!success) {
            throw new IpcException(this.errorDetail());
        }
        return true;
    }

    public DeviceInfoRespond getDeviceInfo(DeviceRequest<IpcEmptyRequest> request) {
        DeviceInfoRespond deviceInfoRespond = new DeviceInfoRespond();
        HWPuSDK.PU_DEVICE_INFO_EX pstDeviceInfo = new HWPuSDK.PU_DEVICE_INFO_EX();
        boolean success = SdkInstance.getInstance().IVS_PU_GetDeviceInfoEx(new WinDef.ULONG(Long.parseLong(request.getSession())), pstDeviceInfo);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorMsg());
        }
        deviceInfoRespond.setSoftwareVersion(new String(pstDeviceInfo.stDeviceInfo.stDeviceVersion.szVerSoftware).trim());
        deviceInfoRespond.setUBootVersion(new String(pstDeviceInfo.stDeviceInfo.stDeviceVersion.szVerUboot).trim());
        deviceInfoRespond.setKernelVersion(new String(pstDeviceInfo.stDeviceInfo.stDeviceVersion.szVerKernel).trim());
        deviceInfoRespond.setHardwareVersion(new String(pstDeviceInfo.stDeviceInfo.stDeviceVersion.szVerHardware).trim());
        deviceInfoRespond.setDeviceName(new String(pstDeviceInfo.stDeviceInfo.szDeviceName).trim());
        deviceInfoRespond.setDeviceType(new String(pstDeviceInfo.stDeviceInfo.szDeviceType).trim());
        deviceInfoRespond.setDeviceSn(new String(pstDeviceInfo.stDeviceInfo.szSerialNumber).trim());
        deviceInfoRespond.setDhcpEnable(Boolean.valueOf(pstDeviceInfo.stDeviceEthernetPara.bDhcpEnable.booleanValue()));
        deviceInfoRespond.setFirstDNSAddress(new String(pstDeviceInfo.stDeviceEthernetPara.szFirstDNSAddress).trim());
        deviceInfoRespond.setSecondDNSAddress(new String(pstDeviceInfo.stDeviceEthernetPara.szSecondDNSAddress).trim());
        deviceInfoRespond.setDeviceGateway(new String(pstDeviceInfo.stDeviceEthernetPara.szGateWayAddress).trim());
        deviceInfoRespond.setIpAddress(new String(pstDeviceInfo.stDeviceEthernetPara.szIPAddress).trim());
        deviceInfoRespond.setSubnetMask(new String(pstDeviceInfo.stDeviceEthernetPara.szSubNetMask).trim());
        deviceInfoRespond.setMacAddress(new String(pstDeviceInfo.stDeviceInfo.stDeviceVersion.szReserved).trim());
        deviceInfoRespond.setIpAddress(new String(pstDeviceInfo.stDeviceEthernetPara.szFirstDNSAddress).trim());
        return deviceInfoRespond;
    }

    public List<JSONObject> getRealTimeRTSP(DeviceRequest<RtspRequest> request) {
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        String head = "rtsp://";
        JSONObject mainJson = new JSONObject();
        mainJson.put("rtspUrl", (Object)(head + request.getDeviceInfo().getIpAddress() + "/LiveMedia/ch1/Media1/trackID=1"));
        mainJson.put("type", (Object)1);
        JSONObject subJson = new JSONObject();
        subJson.put("rtspUrl", (Object)(head + request.getDeviceInfo().getIpAddress() + "/LiveMedia/ch1/Media2/trackID=1"));
        subJson.put("type", (Object)2);
        switch (((RtspRequest)request.getRequest()).getType()) {
            case 0: {
                result.add(mainJson);
                result.add(subJson);
                break;
            }
            case 1: {
                result.add(mainJson);
                break;
            }
            case 2: {
                result.add(subJson);
                break;
            }
        }
        return result;
    }

    public DeviceAbilityRespond getDeviceAbility(DeviceRequest<IpcEmptyRequest> request) {
        HWPuSDK.PU_DEVICE_ABILITY puDeviceAbility = new HWPuSDK.PU_DEVICE_ABILITY();
        DeviceAbilityRespond deviceAbilityRespond = new DeviceAbilityRespond();
        boolean result = SdkInstance.getInstance().IVS_PU_GetDeviceAbility(new WinDef.ULONG(Long.parseLong(request.getSession())), puDeviceAbility);
        if (!result) {
            throw new IpcException(this.errorDetail());
        }
        deviceAbilityRespond.setVideoInputChannelNum(puDeviceAbility.ulVideoInputChannelNum.longValue());
        deviceAbilityRespond.setAudioInputChannelNum(puDeviceAbility.ulAudioInputChannelNum.longValue());
        deviceAbilityRespond.setAlarmDINum(puDeviceAbility.ulAlarmDINum.longValue());
        deviceAbilityRespond.setAlarmDONum(puDeviceAbility.ulAlarmDONum.longValue());
        deviceAbilityRespond.setSerialPortNum(puDeviceAbility.ulSerialPortNum.longValue());
        deviceAbilityRespond.setNetworkCardNum(puDeviceAbility.ulNetworkCardNum.longValue());
        deviceAbilityRespond.setHardDiskNum(puDeviceAbility.ulHardDiskNum.longValue());
        deviceAbilityRespond.setPTZNum(puDeviceAbility.ulPTZNum.longValue());
        deviceAbilityRespond.setTalkBackInputNum(puDeviceAbility.ulTalkbackInputNum.longValue());
        deviceAbilityRespond.setTalkBackOutputNum(puDeviceAbility.ulTalkbackOutputNum.longValue());
        deviceAbilityRespond.setRTPOverFlag(puDeviceAbility.ulRTPOverFlag.longValue());
        deviceAbilityRespond.setDiskFac(new String(puDeviceAbility.stHardDiskInfo.szDiskFac).trim());
        deviceAbilityRespond.setDiskType(puDeviceAbility.stHardDiskInfo.enDiskType);
        deviceAbilityRespond.setAllSpace(puDeviceAbility.stHardDiskInfo.ulAllSpace.longValue());
        deviceAbilityRespond.setLeftSpace(puDeviceAbility.stHardDiskInfo.ulLeftSpace.longValue());
        deviceAbilityRespond.setReserved(new String(puDeviceAbility.szReserved).trim());
        return deviceAbilityRespond;
    }

    public StreamAbilityRespond getStreamAbility(DeviceRequest<IpcEmptyRequest> request) {
        HWPuSDK.PU_STREAM_ABILITY puStreamAbility = new HWPuSDK.PU_STREAM_ABILITY();
        HWPuSDK.PU_STREAM_ABILITY_PARA[] stStreamAbility = puStreamAbility.stStreamAbility;
        StreamAbilityPara[] streamAbilityParas = new StreamAbilityPara[4];
        StreamAbilityRespond streamAbilityRespond = new StreamAbilityRespond();
        boolean result = SdkInstance.getInstance().IVS_PU_GetStreamAbility(new WinDef.ULONG(Long.parseLong(request.getSession())), puStreamAbility);
        if (!result) {
            throw new IpcException(this.errorDetail());
        }
        streamAbilityRespond.setChannelId(puStreamAbility.ulChannelId.longValue());
        streamAbilityRespond.setCameraName(new String(puStreamAbility.szCameraName).trim());
        streamAbilityRespond.setPTZType(puStreamAbility.ulPTZType.longValue());
        streamAbilityRespond.setPresetNum(puStreamAbility.ulPresetNum.longValue());
        streamAbilityRespond.setCruiseTrackNum(puStreamAbility.ulCruiseTrackNum.longValue());
        streamAbilityRespond.setMaxStreamNum(puStreamAbility.ulMaxStreamNum.longValue());
        streamAbilityRespond.setPtzFastLocate(puStreamAbility.bPtzFastLocate.booleanValue());
        streamAbilityRespond.setPtzHorizotalScan(puStreamAbility.bPtzHorizotalScan.booleanValue());
        streamAbilityRespond.setPtzVerticalScan(puStreamAbility.bPtzVerticalScan.booleanValue());
        for (int i = 0; i < stStreamAbility.length; ++i) {
            StreamAbilityPara streamAbilityPara = new StreamAbilityPara();
            streamAbilityPara.setStreamType(stStreamAbility[i].enStreamType);
            streamAbilityPara.setVideoFormat(stStreamAbility[i].enVideoFormat);
            streamAbilityPara.setMaxResolution(stStreamAbility[i].enMaxResolution);
            streamAbilityPara.setMaxBitRate(stStreamAbility[i].ulMaxBitRate.longValue());
            streamAbilityPara.setMaxFrmRate(stStreamAbility[i].ulMaxFrmRate.longValue());
            streamAbilityPara.setMaxIFrameInterval(stStreamAbility[i].ulMaxIFrameInterval.longValue());
            streamAbilityPara.setVideoType(stStreamAbility[i].enVideoType);
            streamAbilityPara.setReserved(new String(stStreamAbility[i].szReserved).trim());
            streamAbilityParas[i] = streamAbilityPara;
        }
        streamAbilityRespond.setStreamAbilityPara(streamAbilityParas);
        streamAbilityRespond.setReserved(new String(puStreamAbility.szReserved).trim());
        return streamAbilityRespond;
    }

    public OsdPartcularParaRespond getOSDChannelConfig(DeviceRequest<OsdPartcularParaRequest> partcularParaRequest) {
        HWPuSDK.PU_OSD_STRING_ARRAY puOsdStringArray = new HWPuSDK.PU_OSD_STRING_ARRAY();
        HWPuSDK.PU_OSD_STRING_PARA[] szStringPara = puOsdStringArray.szStringPara;
        OsdStringPara[] osdStringParaArray = new OsdStringPara[7];
        OsdPartcularParaRespond osdPartcularParaRespond = new OsdPartcularParaRespond();
        boolean result = SdkInstance.getInstance().IVS_PU_GetOsdTextEx(new WinDef.ULONG(Long.parseLong(partcularParaRequest.getSession())), puOsdStringArray, ((OsdPartcularParaRequest)partcularParaRequest.getRequest()).getCharEncodeType());
        if (!result) {
            throw new IpcException(this.errorDetail());
        }
        osdPartcularParaRespond.setChannelID(puOsdStringArray.ulChannelID.longValue());
        OsdDateTimePara osdDateTimePara = new OsdDateTimePara();
        osdDateTimePara.setShowWeekday(Boolean.valueOf(puOsdStringArray.stOsdDateTimePara.bShowWeekday.booleanValue()));
        osdDateTimePara.setDateEnable(Boolean.valueOf(puOsdStringArray.stOsdDateTimePara.bDateEnable.booleanValue()));
        osdDateTimePara.setDateType(puOsdStringArray.stOsdDateTimePara.enDateType);
        osdDateTimePara.setLanguageType(puOsdStringArray.stOsdDateTimePara.enLanguageType);
        OsdInfo osdInfo = new OsdInfo();
        osdInfo.setStartX(puOsdStringArray.stOsdDateTimePara.stOsdPara.ulStartX.longValue());
        osdInfo.setStartY(puOsdStringArray.stOsdDateTimePara.stOsdPara.ulStartY.longValue());
        osdInfo.setTextColor(puOsdStringArray.stOsdDateTimePara.stOsdPara.ulTextColor.longValue());
        osdInfo.setBackgroundColor(puOsdStringArray.stOsdDateTimePara.stOsdPara.enBackgroundColor);
        osdInfo.setBackgroundAlpha(puOsdStringArray.stOsdDateTimePara.stOsdPara.enBackgroundAlpha);
        osdInfo.setReserved(new String(puOsdStringArray.stOsdDateTimePara.stOsdPara.szReserve).trim());
        osdDateTimePara.setOsdInfo(osdInfo);
        osdDateTimePara.setReserve(new String(puOsdStringArray.stOsdDateTimePara.szReserve).trim());
        osdPartcularParaRespond.setOsdDateTimePara(osdDateTimePara);
        osdPartcularParaRespond.setOsdStringNum(puOsdStringArray.ulOSDStringNum.longValue());
        for (int i = 0; i < szStringPara.length; ++i) {
            OsdStringPara osdStringPara = new OsdStringPara();
            osdStringPara.setEnable(Boolean.valueOf(szStringPara[i].bEnable.booleanValue()));
            OsdInfo osdInfoPara = new OsdInfo();
            osdInfoPara.setStartX(szStringPara[i].stOSDInfo.ulStartX.longValue());
            osdInfoPara.setStartY(szStringPara[i].stOSDInfo.ulStartY.longValue());
            osdInfoPara.setTextColor(szStringPara[i].stOSDInfo.ulTextColor.longValue());
            osdInfoPara.setBackgroundColor(szStringPara[i].stOSDInfo.enBackgroundColor);
            osdInfoPara.setBackgroundAlpha(szStringPara[i].stOSDInfo.enBackgroundAlpha);
            osdInfoPara.setReserved(new String(szStringPara[i].stOSDInfo.szReserve).trim());
            osdStringPara.setOsdInfo(osdInfoPara);
            osdStringPara.setStringLen(szStringPara[i].ulStringLen.longValue());
            osdStringPara.setStrContext(new String(szStringPara[i].szString).trim());
            osdStringParaArray[i] = osdStringPara;
        }
        osdPartcularParaRespond.setOsdStringPara(osdStringParaArray);
        return osdPartcularParaRespond;
    }

    public void setOSDChannelConfig(DeviceRequest<OsdPartcularParaRequest> paraRequestDeviceRequest) {
        HWPuSDK.PU_OSD_STRING_ARRAY puOsdStringArray = new HWPuSDK.PU_OSD_STRING_ARRAY();
        OsdStringPara[] osdStringParaArray = ((OsdPartcularParaRequest)paraRequestDeviceRequest.getRequest()).getOsdStringPara();
        HWPuSDK.PU_OSD_STRING_PARA[] osdStringParas = new HWPuSDK.PU_OSD_STRING_PARA[7];
        boolean result = SdkInstance.getInstance().IVS_PU_GetOsdTextEx(new WinDef.ULONG(Long.parseLong(paraRequestDeviceRequest.getSession())), puOsdStringArray, ((OsdPartcularParaRequest)paraRequestDeviceRequest.getRequest()).getCharEncodeType());
        if (!result) {
            System.out.println(this.errorDetail());
        }
        puOsdStringArray.ulChannelID = new WinDef.ULONG(((OsdPartcularParaRequest)paraRequestDeviceRequest.getRequest()).getChannelID());
        puOsdStringArray.stOsdDateTimePara.bShowWeekday = new WinDef.BOOL(((OsdPartcularParaRequest)paraRequestDeviceRequest.getRequest()).getOsdDateTimePara().getShowWeekday().booleanValue());
        puOsdStringArray.stOsdDateTimePara.bDateEnable = new WinDef.BOOL(((OsdPartcularParaRequest)paraRequestDeviceRequest.getRequest()).getOsdDateTimePara().getShowWeekday().booleanValue());
        puOsdStringArray.stOsdDateTimePara.enDateType = ((OsdPartcularParaRequest)paraRequestDeviceRequest.getRequest()).getOsdDateTimePara().getDateType();
        puOsdStringArray.stOsdDateTimePara.enLanguageType = ((OsdPartcularParaRequest)paraRequestDeviceRequest.getRequest()).getOsdDateTimePara().getLanguageType();
        puOsdStringArray.stOsdDateTimePara.stOsdPara.ulStartX = new WinDef.ULONG(((OsdPartcularParaRequest)paraRequestDeviceRequest.getRequest()).getOsdDateTimePara().getOsdInfo().getStartX());
        puOsdStringArray.stOsdDateTimePara.stOsdPara.ulStartY = new WinDef.ULONG(((OsdPartcularParaRequest)paraRequestDeviceRequest.getRequest()).getOsdDateTimePara().getOsdInfo().getStartY());
        puOsdStringArray.stOsdDateTimePara.stOsdPara.ulTextColor = new WinDef.ULONG(((OsdPartcularParaRequest)paraRequestDeviceRequest.getRequest()).getOsdDateTimePara().getOsdInfo().getTextColor());
        puOsdStringArray.stOsdDateTimePara.stOsdPara.enBackgroundColor = ((OsdPartcularParaRequest)paraRequestDeviceRequest.getRequest()).getOsdDateTimePara().getOsdInfo().getBackgroundColor();
        puOsdStringArray.stOsdDateTimePara.stOsdPara.enBackgroundAlpha = ((OsdPartcularParaRequest)paraRequestDeviceRequest.getRequest()).getOsdDateTimePara().getOsdInfo().getBackgroundAlpha();
        puOsdStringArray.stOsdDateTimePara.stOsdPara.szReserve = Arrays.copyOf(((OsdPartcularParaRequest)paraRequestDeviceRequest.getRequest()).getOsdDateTimePara().getOsdInfo().getReserved().getBytes(), 32);
        puOsdStringArray.stOsdDateTimePara.szReserve = Arrays.copyOf(((OsdPartcularParaRequest)paraRequestDeviceRequest.getRequest()).getOsdDateTimePara().getReserve().getBytes(), 32);
        puOsdStringArray.ulOSDStringNum = new WinDef.ULONG(((OsdPartcularParaRequest)paraRequestDeviceRequest.getRequest()).getOsdStringNum());
        for (int i = 0; i < osdStringParaArray.length; ++i) {
            HWPuSDK.PU_OSD_STRING_PARA puOsdStringPara = new HWPuSDK.PU_OSD_STRING_PARA();
            puOsdStringPara.bEnable = new WinDef.BOOL(osdStringParaArray[i].getEnable().booleanValue());
            HWPuSDK.PU_OSD_INFO osdInfo = new HWPuSDK.PU_OSD_INFO();
            osdInfo.ulStartX = new WinDef.ULONG(osdStringParaArray[i].getOsdInfo().getStartX());
            osdInfo.ulStartY = new WinDef.ULONG(osdStringParaArray[i].getOsdInfo().getStartY());
            osdInfo.ulTextColor = new WinDef.ULONG(osdStringParaArray[i].getOsdInfo().getTextColor());
            osdInfo.enBackgroundColor = osdStringParaArray[i].getOsdInfo().getBackgroundColor();
            osdInfo.enBackgroundAlpha = osdStringParaArray[i].getOsdInfo().getBackgroundAlpha();
            osdInfo.szReserve = Arrays.copyOf(osdStringParaArray[i].getOsdInfo().getReserved().getBytes(), 32);
            puOsdStringPara.stOSDInfo = osdInfo;
            puOsdStringPara.ulStringLen = new WinDef.ULONG(osdStringParaArray[i].getStringLen());
            puOsdStringPara.szString = Arrays.copyOf(osdStringParaArray[i].getStrContext().getBytes(), 100);
            osdStringParas[i] = puOsdStringPara;
        }
        puOsdStringArray.szStringPara = osdStringParas;
        result = SdkInstance.getInstance().IVS_PU_SetOsdTextEx(new WinDef.ULONG(Long.parseLong(paraRequestDeviceRequest.getSession())), puOsdStringArray, ((OsdPartcularParaRequest)paraRequestDeviceRequest.getRequest()).getCharEncodeType());
        if (!result) {
            throw new IpcException(this.errorDetail());
        }
    }

    public VideoStreamRespond getVideoStreamInfo(DeviceRequest<IpcEmptyRequest> request) {
        HWPuSDK.PU_VIDEO_STREAM_INFO puVideoStreamInfo = new HWPuSDK.PU_VIDEO_STREAM_INFO();
        HWPuSDK.PU_STREAM_ATTRIBUTE[] stStreamAttribute = puVideoStreamInfo.stStreamAttribute;
        VideoStreamRespond videoStreamRespond = new VideoStreamRespond();
        boolean result = SdkInstance.getInstance().IVS_PU_GetVideoStreamInfo(new WinDef.ULONG(Long.parseLong(request.getSession())), puVideoStreamInfo);
        if (!result) {
            throw new IpcException(this.errorDetail());
        }
        videoStreamRespond.setChannelId(puVideoStreamInfo.ulChannelId.longValue());
        videoStreamRespond.setStreamMode(StreamMode.get((int)puVideoStreamInfo.enStreamMode));
        ArrayList<StreamAttribute> streamAttributeList = new ArrayList<StreamAttribute>();
        for (int i = 0; i < stStreamAttribute.length; ++i) {
            StreamAttribute streamAttribute = new StreamAttribute();
            streamAttribute.setStreamType(StreamType.get((int)stStreamAttribute[i].enStreamId));
            streamAttribute.setBitRate(stStreamAttribute[i].stVideoAttribute.ulBitRate.longValue());
            streamAttribute.setIFrameInterval(stStreamAttribute[i].stVideoAttribute.ulIFrameInterval.longValue());
            streamAttribute.setFrameRate(stStreamAttribute[i].stVideoAttribute.ulFrameRate.longValue());
            streamAttribute.setVideoEncodeMode(VideoEncodeMode.get((int)stStreamAttribute[i].stVideoAttribute.enVideoEncodeMode));
            streamAttribute.setResolution(stStreamAttribute[i].stVideoAttribute.enResolution);
            streamAttribute.setBitRateType(BitRateType.get((int)stStreamAttribute[i].stVideoAttribute.enBitRateType));
            streamAttribute.setPicQuality(PicQuality.get((int)stStreamAttribute[i].stVideoAttribute.enPicQuality));
            streamAttribute.setVideoFormat(VideoFormat.get((int)stStreamAttribute[i].stVideoAttribute.enVideoFormat));
            streamAttribute.setRcPriMode(FrameBitMode.get((int)stStreamAttribute[i].stVideoAttribute.enRcPriMode));
            streamAttribute.setMirrorMode(MirrorMode.get((int)stStreamAttribute[i].stVideoAttribute.enMirrorMode));
            streamAttributeList.add(streamAttribute);
        }
        videoStreamRespond.setStreamAttributeList(streamAttributeList);
        videoStreamRespond.setReserved(new String(puVideoStreamInfo.szReserved).trim());
        return videoStreamRespond;
    }

    public boolean setVideoStreamInfo(DeviceRequest<VideoStreamRequest> request) {
        HWPuSDK.PU_VIDEO_STREAM_INFO puVideoStreamInfo = new HWPuSDK.PU_VIDEO_STREAM_INFO();
        HWPuSDK.PU_STREAM_ATTRIBUTE[] stStreamAttribute = puVideoStreamInfo.stStreamAttribute;
        boolean result = SdkInstance.getInstance().IVS_PU_GetVideoStreamInfo(new WinDef.ULONG(Long.parseLong(request.getSession())), puVideoStreamInfo);
        if (!result) {
            System.out.println(this.errorDetail());
        }
        puVideoStreamInfo.ulChannelId = new WinDef.ULONG(((VideoStreamRequest)request.getRequest()).getChannelId());
        puVideoStreamInfo.enStreamMode = ((VideoStreamRequest)request.getRequest()).getStreamMode().getValue();
        List streamAttributeList = ((VideoStreamRequest)request.getRequest()).getStreamAttributeList();
        if (streamAttributeList != null) {
            for (int i = 0; i < streamAttributeList.size(); ++i) {
                StreamAttribute streamAttribute = (StreamAttribute)streamAttributeList.get(i);
                stStreamAttribute[i].enStreamId = streamAttribute.getStreamType().getValue();
                stStreamAttribute[i].stVideoAttribute.ulBitRate = new WinDef.ULONG(streamAttribute.getBitRate());
                stStreamAttribute[i].stVideoAttribute.ulIFrameInterval = new WinDef.ULONG(streamAttribute.getIFrameInterval());
                stStreamAttribute[i].stVideoAttribute.ulFrameRate = new WinDef.ULONG(streamAttribute.getFrameRate());
                stStreamAttribute[i].stVideoAttribute.enVideoEncodeMode = streamAttribute.getVideoEncodeMode().getValue();
                stStreamAttribute[i].stVideoAttribute.enResolution = streamAttribute.getResolution();
                stStreamAttribute[i].stVideoAttribute.enBitRateType = streamAttribute.getBitRateType().getValue();
                stStreamAttribute[i].stVideoAttribute.enPicQuality = streamAttribute.getPicQuality().getValue();
                stStreamAttribute[i].stVideoAttribute.enVideoFormat = streamAttribute.getVideoFormat().getValue();
                stStreamAttribute[i].stVideoAttribute.enRcPriMode = streamAttribute.getRcPriMode().getValue();
                stStreamAttribute[i].stVideoAttribute.enMirrorMode = streamAttribute.getMirrorMode().getValue();
            }
        }
        if (null != ((VideoStreamRequest)request.getRequest()).getReserved()) {
            puVideoStreamInfo.szReserved = Arrays.copyOf(((VideoStreamRequest)request.getRequest()).getReserved().getBytes(), 32);
        }
        if (!(result = SdkInstance.getInstance().IVS_PU_SetVideoStreamInfo(new WinDef.ULONG(Long.parseLong(request.getSession())), puVideoStreamInfo))) {
            throw new IpcException(this.errorDetail());
        }
        return true;
    }

    public MasterSlaveChannelInfoRespond getMasterSlaveChannelInfo(DeviceRequest<IpcEmptyRequest> request) {
        int i;
        HWPuSDK.PU_MASTER_SLAVER_CHANNEL_INFO_S puMasterSlaverChannelInfoS = new HWPuSDK.PU_MASTER_SLAVER_CHANNEL_INFO_S();
        HWPuSDK.PU_PRE_CHANNEL_INFO_S[] astMasterChanInfo = puMasterSlaverChannelInfoS.astMasterChanInfo;
        HWPuSDK.PU_PRE_CHANNEL_INFO_S[] astSlaveChanInfo = puMasterSlaverChannelInfoS.astSlaveChanInfo;
        ChannelInfo[] masterChannelInfoList = new ChannelInfo[8];
        ChannelInfo[] slaveChannelInfoList = new ChannelInfo[8];
        MasterSlaveChannelInfoRespond channelInfoRespond = new MasterSlaveChannelInfoRespond();
        boolean result = SdkInstance.getInstance().IVS_PU_GetMasterSlaveChannelInfo(new WinDef.ULONG(Long.parseLong(request.getSession())), puMasterSlaverChannelInfoS);
        if (!result) {
            throw new IpcException(this.errorDetail());
        }
        channelInfoRespond.setMasterChanCap(puMasterSlaverChannelInfoS.ulMasterChanCap.longValue());
        channelInfoRespond.setSlaveChanCap(puMasterSlaverChannelInfoS.ulSlaveChanCap.longValue());
        channelInfoRespond.setMasterChanNum(puMasterSlaverChannelInfoS.ulMasterChanNum.longValue());
        channelInfoRespond.setSlaveChanNum(puMasterSlaverChannelInfoS.ulSlaveChanNum.longValue());
        for (i = 0; i < astMasterChanInfo.length; ++i) {
            masterChannelInfoList[i] = this.formatChannelInfo(astMasterChanInfo[i]);
        }
        channelInfoRespond.setMasterChannelInfo(masterChannelInfoList);
        for (i = 0; i < astSlaveChanInfo.length; ++i) {
            slaveChannelInfoList[i] = this.formatChannelInfo(astSlaveChanInfo[i]);
        }
        channelInfoRespond.setSlaveChannelInfo(slaveChannelInfoList);
        channelInfoRespond.setReserved(new String(puMasterSlaverChannelInfoS.szReserved).trim());
        return channelInfoRespond;
    }

    private ChannelInfo formatChannelInfo(HWPuSDK.PU_PRE_CHANNEL_INFO_S channelInfoS) {
        ChannelInfo channelInfo = new ChannelInfo();
        channelInfo.setChannelID(channelInfoS.ulChannelID.longValue());
        channelInfo.setSlaveChanStatus(channelInfoS.enSlaveChanStatus);
        channelInfo.setReserved(new String(channelInfoS.szReserved).trim());
        return channelInfo;
    }

    public DiscoveryDeviceRespond discoveryDevice(DeviceRequest<DiscoveryDeviceRequest> request) {
        DiscoveryDeviceRequest discoveryDeviceRequest = (DiscoveryDeviceRequest)request.getRequest();
        HWPuSDK.PU_DISCOVER_DEVICE_INFO[] puDiscoverDeviceInfo = (HWPuSDK.PU_DISCOVER_DEVICE_INFO[])new HWPuSDK.PU_DISCOVER_DEVICE_INFO().toArray(50);
        LongByReference longByReference = new LongByReference();
        boolean success = SdkInstance.getInstance().IVS_PU_DiscoveryDeviceByIpAddresses(discoveryDeviceRequest.getStartIp(), discoveryDeviceRequest.getEndIp(), new NativeLong(discoveryDeviceRequest.getSearchNum()), puDiscoverDeviceInfo, longByReference);
        if (!success) {
            throw new IpcException(this.errorDetail());
        }
        DiscoveryDeviceRespond discoveryDeviceRespond = new DiscoveryDeviceRespond();
        discoveryDeviceRespond.setStartIp(discoveryDeviceRequest.getStartIp());
        discoveryDeviceRespond.setEndIp(discoveryDeviceRequest.getEndIp());
        discoveryDeviceRespond.setSearchNum(discoveryDeviceRequest.getSearchNum());
        discoveryDeviceRespond.setDeviceNum(longByReference.getValue());
        List deviceList = this.setDiscoveryDevice(puDiscoverDeviceInfo);
        discoveryDeviceRespond.setDeviceBaseInfoList(deviceList);
        return discoveryDeviceRespond;
    }

    private List<DeviceBaseInfo> setDiscoveryDevice(HWPuSDK.PU_DISCOVER_DEVICE_INFO[] puDiscoverDeviceInfo) {
        ArrayList<DeviceBaseInfo> deviceBaseInfos = new ArrayList<DeviceBaseInfo>();
        for (HWPuSDK.PU_DISCOVER_DEVICE_INFO deviceInfo : puDiscoverDeviceInfo) {
            if (!StringUtils.isNotBlank((CharSequence)new String(deviceInfo.szDeviceIp).trim())) continue;
            DeviceBaseInfo deviceBaseInfo = new DeviceBaseInfo();
            deviceBaseInfo.setMacAddress(new String(deviceInfo.szDeviceMac).trim());
            deviceBaseInfo.setDeviceType(new String(deviceInfo.szDeviceType).trim());
            deviceBaseInfo.setDeviceVersion(new String(deviceInfo.szDeviceVersion).trim());
            deviceBaseInfo.setDeviceName(new String(deviceInfo.szDeviceName).trim());
            deviceBaseInfo.setIpAddress(new String(deviceInfo.szDeviceIp).trim());
            deviceBaseInfo.setSubnetMask(new String(deviceInfo.szDeviceMask).trim());
            deviceBaseInfo.setDeviceGateway(new String(deviceInfo.szDeviceGateway).trim());
            deviceBaseInfo.setDeviceSn(new String(deviceInfo.szSerialNumber).trim());
            deviceBaseInfo.setDhcpEnable(Boolean.valueOf(deviceInfo.uDhcpEnable.intValue() == 1));
            deviceBaseInfos.add(deviceBaseInfo);
        }
        return deviceBaseInfos;
    }
}

