/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.impl;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.WinDef;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.AlarmTime;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.BaseAreaParam;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.CrowdDensityDetectAlgParam;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.DeviceRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.IgaArea;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.CrowdDensityDetectParamRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.IpcEmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.CrowdDensityDetectParamRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.exception.IpcException;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.AbstractSdkService;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.HWPuSDK;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.SdkInstance;
import com.zkteco.zkbiosecurity.cuserver.ipc.service.CrowdDensityService;
import org.springframework.stereotype.Component;

@Component
public class SdcCrowdDensityServiceImpl
extends AbstractSdkService
implements CrowdDensityService {
    public boolean setCrowdDensityDetectParam(DeviceRequest<CrowdDensityDetectParamRequest> request) {
        HWPuSDK.PU_CROWD_DENSITY_DETECT_PARAM puCrowdDensityDetectParam = this.transCrowdDensityDetectParam((CrowdDensityDetectParamRequest)request.getRequest());
        puCrowdDensityDetectParam.write();
        Pointer pointer = puCrowdDensityDetectParam.getPointer();
        boolean success = SdkInstance.getInstance().IVS_PU_SetAlarmPara(new WinDef.ULONG(Long.parseLong(request.getSession())), 122, pointer);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        return true;
    }

    public CrowdDensityDetectParamRespond getCrowdDensityDetectParam(DeviceRequest<IpcEmptyRequest> request) {
        HWPuSDK.PU_CROWD_DENSITY_DETECT_PARAM puCrowdDensityParam = new HWPuSDK.PU_CROWD_DENSITY_DETECT_PARAM();
        puCrowdDensityParam.ulChannelId = new WinDef.ULONG(101L);
        puCrowdDensityParam.write();
        Pointer pointer = puCrowdDensityParam.getPointer();
        boolean success = SdkInstance.getInstance().IVS_PU_GetAlarmPara(new WinDef.ULONG(Long.parseLong(request.getSession())), 122, pointer);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        puCrowdDensityParam = (HWPuSDK.PU_CROWD_DENSITY_DETECT_PARAM)Structure.newInstance(HWPuSDK.PU_CROWD_DENSITY_DETECT_PARAM.class, (Pointer)pointer);
        puCrowdDensityParam.read();
        return this.toCrowdDensityDetectParam(puCrowdDensityParam);
    }

    private CrowdDensityDetectParamRespond toCrowdDensityDetectParam(HWPuSDK.PU_CROWD_DENSITY_DETECT_PARAM param) {
        CrowdDensityDetectParamRespond crowdDensityDetectParam = new CrowdDensityDetectParamRespond();
        crowdDensityDetectParam.setChannelId(param.ulChannelId.toString());
        crowdDensityDetectParam.setAlgParams(this.toCrowdDensityDetectAlgParam(param.stAlgParams));
        crowdDensityDetectParam.setReserve(new String(param.szReserve).trim());
        BaseAreaParam.AreaList sdcAreaList = new BaseAreaParam.AreaList();
        HWPuSDK.PU_IGT_AERADTC_LIST_S stAreaList = param.stAreaList;
        sdcAreaList.areaNum = stAreaList.ulAreaNum.longValue();
        sdcAreaList.stArea = new IgaArea[4];
        HWPuSDK.PU_IGT_AREA[] stArea = stAreaList.stArea;
        for (int i = 0; i < stArea.length; ++i) {
            sdcAreaList.stArea[i] = this.toIgaArea(stArea[i]);
        }
        crowdDensityDetectParam.setAreaList(sdcAreaList);
        HWPuSDK.PU_ALARM_TIME_LIST_S stAreaGuardPlan = param.stGuardPlan;
        BaseAreaParam.AlarmTimeList sdcAlarmTimeList = new BaseAreaParam.AlarmTimeList();
        sdcAlarmTimeList.num = stAreaGuardPlan.ulNum.longValue();
        sdcAlarmTimeList.alarmTimes = new AlarmTime[8];
        HWPuSDK.PU_ALARM_TIME_S[] stAlarmTime = stAreaGuardPlan.stAlarmTime;
        for (int i = 0; i < stAlarmTime.length; ++i) {
            sdcAlarmTimeList.alarmTimes[i] = this.toAlarmTime(stAlarmTime[i]);
        }
        crowdDensityDetectParam.setGuardPlan(sdcAlarmTimeList);
        return crowdDensityDetectParam;
    }

    private HWPuSDK.PU_CROWD_DENSITY_DETECT_PARAM transCrowdDensityDetectParam(CrowdDensityDetectParamRequest param) {
        HWPuSDK.PU_CROWD_DENSITY_DETECT_PARAM puParam = new HWPuSDK.PU_CROWD_DENSITY_DETECT_PARAM();
        puParam.ulChannelId = new WinDef.ULONG(Long.parseLong(param.getChannelId()));
        puParam.stAlgParams = this.transCrowdDensityDetectAlgParam(param.getAlgParams());
        BaseAreaParam.AreaList sdcAreaList = param.getAreaList();
        HWPuSDK.PU_IGT_AERADTC_LIST_S stAreaList = new HWPuSDK.PU_IGT_AERADTC_LIST_S();
        stAreaList.ulAreaNum = new WinDef.ULONG(sdcAreaList.areaNum);
        IgaArea[] igtAreas = sdcAreaList.stArea;
        for (int i = 0; i < igtAreas.length; ++i) {
            stAreaList.stArea[i] = this.transIgaArea(igtAreas[i]);
        }
        puParam.stAreaList = stAreaList;
        BaseAreaParam.AlarmTimeList sdcAlarmTimeList = param.getGuardPlan();
        AlarmTime[] sdcAlarmTimes = sdcAlarmTimeList.alarmTimes;
        HWPuSDK.PU_ALARM_TIME_LIST_S puAlarmTimeList = new HWPuSDK.PU_ALARM_TIME_LIST_S();
        puAlarmTimeList.ulNum = new WinDef.ULONG(sdcAlarmTimeList.num);
        for (int i = 0; i < sdcAlarmTimes.length; ++i) {
            puAlarmTimeList.stAlarmTime[i] = this.transAlarmTime(sdcAlarmTimes[i]);
        }
        puParam.stGuardPlan = puAlarmTimeList;
        return puParam;
    }

    private CrowdDensityDetectAlgParam toCrowdDensityDetectAlgParam(HWPuSDK.PU_ITGT_CROWD_DENSITY_DETECT_ALG_PARAM param) {
        CrowdDensityDetectAlgParam algParam = new CrowdDensityDetectAlgParam();
        algParam.setEnable(param.enEnable);
        algParam.setPeopleNumThreshold(param.fPeopleNumThreshold.longValue());
        algParam.setAlarmTime(param.ulAlarmTime.longValue());
        algParam.setSensitivity(param.ulSensitivity.longValue());
        algParam.setReserve(new String(param.szReserve).trim());
        return algParam;
    }

    private HWPuSDK.PU_ITGT_CROWD_DENSITY_DETECT_ALG_PARAM transCrowdDensityDetectAlgParam(CrowdDensityDetectAlgParam param) {
        HWPuSDK.PU_ITGT_CROWD_DENSITY_DETECT_ALG_PARAM puParam = new HWPuSDK.PU_ITGT_CROWD_DENSITY_DETECT_ALG_PARAM();
        puParam.enEnable = param.getEnable();
        puParam.fPeopleNumThreshold = new WinDef.ULONG(param.getPeopleNumThreshold());
        puParam.ulAlarmTime = new WinDef.ULONG(param.getAlarmTime());
        puParam.ulSensitivity = new WinDef.ULONG(param.getSensitivity());
        return puParam;
    }
}

