/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.impl;

import com.sun.jna.NativeLong;
import com.sun.jna.platform.win32.WinDef;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.AlarmTime;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.BaseAreaParam;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.DeviceRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.IgaArea;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.IgtLine;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.IgtPoint;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.AreaDetectRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.IpcEmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.SmartAlarmParamRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.TripwireAlarmParaRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.AreaDetectRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.SmartAlarmParamRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.TripwireAlarmParaRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.exception.IpcException;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.AbstractSdkService;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.HWPuSDK;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.SdkInstance;
import com.zkteco.zkbiosecurity.cuserver.ipc.service.BehaviorAnalysisService;
import com.zkteco.zkbiosecurity.cuserver.ipc.service.SubscribeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SdcBehaviorAnalysisServiceImpl
extends AbstractSdkService
implements BehaviorAnalysisService {
    private static final Logger log = LoggerFactory.getLogger(SdcBehaviorAnalysisServiceImpl.class);
    @Autowired
    private SubscribeService subscribeAlarm;

    public boolean setGlobalBehavioralAnalysisParam(DeviceRequest<SmartAlarmParamRequest> smartAlarmParam) {
        HWPuSDK.PU_IGT_ALARM_PARA alarmParam = new HWPuSDK.PU_IGT_ALARM_PARA();
        alarmParam.ulChannelId = new WinDef.ULONG(101L);
        boolean success = SdkInstance.getInstance().IVS_PU_GetIgtPara(new WinDef.ULONG(Long.parseLong(smartAlarmParam.getSession())), alarmParam);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        if (((SmartAlarmParamRequest)smartAlarmParam.getRequest()).getIgtEnable() != null) {
            alarmParam.bIgtEnable = new WinDef.BOOL(((SmartAlarmParamRequest)smartAlarmParam.getRequest()).getIgtEnable().booleanValue());
        }
        if (((SmartAlarmParamRequest)smartAlarmParam.getRequest()).getTrackEnable() != null) {
            alarmParam.bTrackEnable = new WinDef.BOOL(((SmartAlarmParamRequest)smartAlarmParam.getRequest()).getTrackEnable().booleanValue());
        }
        if (((SmartAlarmParamRequest)smartAlarmParam.getRequest()).getEnFieldType() >= 0) {
            alarmParam.enFieldType = ((SmartAlarmParamRequest)smartAlarmParam.getRequest()).getEnFieldType();
        }
        if (((SmartAlarmParamRequest)smartAlarmParam.getRequest()).getEnMinTargetSize() >= 0) {
            alarmParam.enMinTargetSize = ((SmartAlarmParamRequest)smartAlarmParam.getRequest()).getEnMinTargetSize();
        }
        if (((SmartAlarmParamRequest)smartAlarmParam.getRequest()).getEnShadowMode() >= 0) {
            alarmParam.enShadowMode = ((SmartAlarmParamRequest)smartAlarmParam.getRequest()).getEnShadowMode();
        }
        if (((SmartAlarmParamRequest)smartAlarmParam.getRequest()).getEnDetectSens() >= 0) {
            alarmParam.enDetectSens = ((SmartAlarmParamRequest)smartAlarmParam.getRequest()).getEnDetectSens();
        }
        if (((SmartAlarmParamRequest)smartAlarmParam.getRequest()).getInsensitiveObject() != null) {
            alarmParam.bInsensitiveObject = new WinDef.BOOL(((SmartAlarmParamRequest)smartAlarmParam.getRequest()).getInsensitiveObject().booleanValue());
        }
        if (!(success = SdkInstance.getInstance().IVS_PU_SetIgtPara(new WinDef.ULONG(Long.parseLong(smartAlarmParam.getSession())), alarmParam))) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        return true;
    }

    public SmartAlarmParamRespond getGlobalBehavioralAnalysisParam(DeviceRequest<IpcEmptyRequest> request) {
        HWPuSDK.PU_IGT_ALARM_PARA alarmParam = new HWPuSDK.PU_IGT_ALARM_PARA();
        alarmParam.ulChannelId = new WinDef.ULONG(101L);
        boolean success = SdkInstance.getInstance().IVS_PU_GetIgtPara(new WinDef.ULONG(Long.parseLong(request.getSession())), alarmParam);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        return this.transSmartAlarmParam(alarmParam);
    }

    public boolean setAreaIntrusionParam(DeviceRequest<AreaDetectRequest> request) {
        return this.setSdcAreaDetectItem(Long.parseLong(request.getSession()), (AreaDetectRequest)request.getRequest(), 0);
    }

    public AreaDetectRespond getAreaIntrusionParam(DeviceRequest<IpcEmptyRequest> request) {
        return this.getSdcAreaDetectItem(Long.parseLong(request.getSession()), 0);
    }

    public boolean setTripwireParam(DeviceRequest<TripwireAlarmParaRequest> request) {
        HWPuSDK.PU_TW_ALARM_PARA pstIgtTwAlarmPara = this.transTripwireAlarmPara((TripwireAlarmParaRequest)request.getRequest());
        pstIgtTwAlarmPara.ulChannelId = new WinDef.ULONG(101L);
        boolean success = SdkInstance.getInstance().IVS_PU_SetIgtTripwireAlarmPara(new WinDef.ULONG(Long.parseLong(request.getSession())), pstIgtTwAlarmPara);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        return true;
    }

    public TripwireAlarmParaRespond getTripwireParam(DeviceRequest<IpcEmptyRequest> request) {
        HWPuSDK.PU_TW_ALARM_PARA pstIgtTwAlarmPara = new HWPuSDK.PU_TW_ALARM_PARA();
        pstIgtTwAlarmPara.ulChannelId = new WinDef.ULONG(101L);
        boolean success = SdkInstance.getInstance().IVS_PU_GetIgtTripwireAlarmPara(new WinDef.ULONG(Long.parseLong(request.getSession())), pstIgtTwAlarmPara);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        return this.toTripwireAlarmParaItem(pstIgtTwAlarmPara);
    }

    public boolean setAreaEnterParam(DeviceRequest<AreaDetectRequest> request) {
        return this.setSdcAreaDetectItem(Long.parseLong(request.getSession()), (AreaDetectRequest)request.getRequest(), 4);
    }

    public AreaDetectRespond getAreaEnterParam(DeviceRequest<IpcEmptyRequest> request) {
        return this.getSdcAreaDetectItem(Long.parseLong(request.getSession()), 4);
    }

    public boolean setAreaExitParam(DeviceRequest<AreaDetectRequest> request) {
        return this.setSdcAreaDetectItem(Long.parseLong(request.getSession()), (AreaDetectRequest)request.getRequest(), 5);
    }

    public AreaDetectRespond getAreaExitParam(DeviceRequest<IpcEmptyRequest> request) {
        return this.getSdcAreaDetectItem(Long.parseLong(request.getSession()), 5);
    }

    public boolean setAreaHoverParam(DeviceRequest<AreaDetectRequest> request) {
        return this.setSdcAreaDetectItem(Long.parseLong(request.getSession()), (AreaDetectRequest)request.getRequest(), 1);
    }

    public AreaDetectRespond getAreaHoverParam(DeviceRequest<IpcEmptyRequest> request) {
        return this.getSdcAreaDetectItem(Long.parseLong(request.getSession()), 1);
    }

    public boolean setAreaFastMoveParam(DeviceRequest<AreaDetectRequest> request) {
        return this.setSdcAreaDetectItem(Long.parseLong(request.getSession()), (AreaDetectRequest)request.getRequest(), 6);
    }

    public AreaDetectRespond getAreaFastMoveParam(DeviceRequest<IpcEmptyRequest> request) {
        return this.getSdcAreaDetectItem(Long.parseLong(request.getSession()), 6);
    }

    private boolean setSdcAreaDetectItem(long loginId, AreaDetectRequest sdcAreaItem, int puAlarmTypeExit) {
        HWPuSDK.PU_IGT_AEREDTC_ALARM_PARA alarmParam = this.toAreaEnterParam(sdcAreaItem);
        boolean success = SdkInstance.getInstance().IVS_PU_SetIgtAreaDtcAlarmPara(new WinDef.ULONG(loginId), puAlarmTypeExit, alarmParam);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        return true;
    }

    private AreaDetectRespond getSdcAreaDetectItem(long loginId, int puAlarmTypeExit) {
        HWPuSDK.PU_IGT_AEREDTC_ALARM_PARA alarmParam = new HWPuSDK.PU_IGT_AEREDTC_ALARM_PARA();
        alarmParam.ulChannelId = new WinDef.ULONG(101L);
        boolean success = SdkInstance.getInstance().IVS_PU_GetIgtAreaDtcAlarmPara(new WinDef.ULONG(loginId), puAlarmTypeExit, alarmParam);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        return this.transAreaDetectItem(alarmParam);
    }

    private SmartAlarmParamRespond transSmartAlarmParam(HWPuSDK.PU_IGT_ALARM_PARA alarmPara) {
        SmartAlarmParamRespond smartAlarmParam = new SmartAlarmParamRespond();
        smartAlarmParam.setChannelId(alarmPara.ulChannelId.toString());
        smartAlarmParam.setIgtEnable(Boolean.valueOf(alarmPara.bIgtEnable.booleanValue()));
        smartAlarmParam.setTrackEnable(Boolean.valueOf(alarmPara.bTrackEnable.booleanValue()));
        smartAlarmParam.setEnFieldType(alarmPara.enFieldType);
        smartAlarmParam.setEnMinTargetSize(alarmPara.enMinTargetSize);
        smartAlarmParam.setEnShadowMode(alarmPara.enShadowMode);
        smartAlarmParam.setEnDetectSens(alarmPara.enDetectSens);
        smartAlarmParam.setInsensitiveObject(Boolean.valueOf(alarmPara.bInsensitiveObject.booleanValue()));
        smartAlarmParam.setSzReserved(new String(alarmPara.szReserved).trim());
        return smartAlarmParam;
    }

    private AreaDetectRespond transAreaDetectItem(HWPuSDK.PU_IGT_AEREDTC_ALARM_PARA alarmParam) {
        AreaDetectRespond areaDetectItem = new AreaDetectRespond();
        areaDetectItem.setChannelId(alarmParam.ulChannelId.toString());
        areaDetectItem.setEnable(Boolean.valueOf(alarmParam.bEnable.booleanValue()));
        areaDetectItem.setReserved(new String(alarmParam.szReserved).trim());
        areaDetectItem.setAlarmInterval(alarmParam.ulAlarmInterval.longValue());
        areaDetectItem.setTargetDetecMode(alarmParam.enTargetDetecMode);
        areaDetectItem.setRemainTime(alarmParam.ulRemainTime.longValue());
        areaDetectItem.setSensitivity(alarmParam.uiSensitivity.intValue());
        BaseAreaParam.AreaList sdcAreaList = new BaseAreaParam.AreaList();
        HWPuSDK.PU_IGT_AERADTC_LIST_S stAreaList = alarmParam.stAreaDtcList;
        sdcAreaList.areaNum = stAreaList.ulAreaNum.longValue();
        sdcAreaList.stArea = new IgaArea[4];
        HWPuSDK.PU_IGT_AREA[] stArea = stAreaList.stArea;
        for (int i = 0; i < stArea.length; ++i) {
            sdcAreaList.stArea[i] = this.toIgaArea(stArea[i]);
        }
        areaDetectItem.setAreaDtcList(sdcAreaList);
        HWPuSDK.PU_ALARM_TIME_LIST_S stAreaGuardPlan = alarmParam.stAreaGuardPlan;
        BaseAreaParam.AlarmTimeList sdcAlarmTimeList = new BaseAreaParam.AlarmTimeList();
        sdcAlarmTimeList.num = stAreaGuardPlan.ulNum.longValue();
        sdcAlarmTimeList.alarmTimes = new AlarmTime[8];
        HWPuSDK.PU_ALARM_TIME_S[] stAlarmTime = stAreaGuardPlan.stAlarmTime;
        for (int i = 0; i < stAlarmTime.length; ++i) {
            sdcAlarmTimeList.alarmTimes[i] = this.toAlarmTime(stAlarmTime[i]);
        }
        areaDetectItem.setAreaGuardPlan(sdcAlarmTimeList);
        return areaDetectItem;
    }

    private HWPuSDK.PU_IGT_AEREDTC_ALARM_PARA toAreaEnterParam(AreaDetectRequest sdcAreaOutItem) {
        HWPuSDK.PU_IGT_AEREDTC_ALARM_PARA alarmParam = new HWPuSDK.PU_IGT_AEREDTC_ALARM_PARA();
        alarmParam.ulChannelId = new WinDef.ULONG(Long.parseLong(sdcAreaOutItem.getChannelId()));
        alarmParam.bEnable = new WinDef.BOOL(sdcAreaOutItem.getEnable().booleanValue());
        alarmParam.szReserved = sdcAreaOutItem.getReserved() != null ? sdcAreaOutItem.getReserved().getBytes() : new byte[32];
        alarmParam.ulAlarmInterval = new WinDef.ULONG(sdcAreaOutItem.getAlarmInterval());
        alarmParam.enTargetDetecMode = sdcAreaOutItem.getTargetDetecMode();
        alarmParam.ulRemainTime = new WinDef.ULONG(sdcAreaOutItem.getRemainTime());
        alarmParam.uiSensitivity = new WinDef.UCHAR((long)sdcAreaOutItem.getSensitivity());
        BaseAreaParam.AreaList sdcAreaList = sdcAreaOutItem.getAreaDtcList();
        HWPuSDK.PU_IGT_AERADTC_LIST_S stAreaList = new HWPuSDK.PU_IGT_AERADTC_LIST_S();
        stAreaList.ulAreaNum = new WinDef.ULONG(sdcAreaList.areaNum);
        IgaArea[] igtAreas = sdcAreaList.stArea;
        for (int i = 0; i < igtAreas.length; ++i) {
            stAreaList.stArea[i] = this.transIgaArea(igtAreas[i]);
        }
        alarmParam.stAreaDtcList = stAreaList;
        BaseAreaParam.AlarmTimeList sdcAlarmTimeList = sdcAreaOutItem.getAreaGuardPlan();
        AlarmTime[] sdcAlarmTimes = sdcAlarmTimeList.alarmTimes;
        HWPuSDK.PU_ALARM_TIME_LIST_S puAlarmTimeList = new HWPuSDK.PU_ALARM_TIME_LIST_S();
        puAlarmTimeList.ulNum = new WinDef.ULONG(sdcAlarmTimeList.num);
        for (int i = 0; i < sdcAlarmTimes.length; ++i) {
            puAlarmTimeList.stAlarmTime[i] = this.transAlarmTime(sdcAlarmTimes[i]);
        }
        alarmParam.stAreaGuardPlan = puAlarmTimeList;
        return alarmParam;
    }

    private HWPuSDK.PU_IGT_TW_LINE toHWLine(IgtLine igtLine) {
        HWPuSDK.PU_IGT_TW_LINE puIgtTwLine = new HWPuSDK.PU_IGT_TW_LINE();
        puIgtTwLine.bEnable = new WinDef.BOOL(igtLine.getEnable().booleanValue());
        puIgtTwLine.szLineName = igtLine.getLineName() != null && igtLine.getLineName().length() > 0 ? igtLine.getLineName().getBytes() : new byte[36];
        puIgtTwLine.ucDirection = new WinDef.UCHAR((long)igtLine.getDirection());
        puIgtTwLine.ulLineIndex = new NativeLong(igtLine.getLineIndex());
        puIgtTwLine.stStartPoit = this.transIgtPoint(igtLine.getStartPoint());
        puIgtTwLine.stEndPoit = this.transIgtPoint(igtLine.getEndPoint());
        return puIgtTwLine;
    }

    private TripwireAlarmParaRespond toTripwireAlarmParaItem(HWPuSDK.PU_TW_ALARM_PARA hwParam) {
        TripwireAlarmParaRespond tripwireAlarmParaItem = new TripwireAlarmParaRespond();
        HWPuSDK.PU_IGT_TW_LINE_LIST_S stlineList = hwParam.stlineList;
        tripwireAlarmParaItem.setChannelId(hwParam.ulChannelId.toString());
        tripwireAlarmParaItem.setEnable(Boolean.valueOf(hwParam.bEnable.booleanValue()));
        tripwireAlarmParaItem.setTargetDetecMode(hwParam.enTargetDetecMode);
        tripwireAlarmParaItem.setSensitivity(hwParam.ulSensitivity.longValue());
        tripwireAlarmParaItem.setAlarmInterval(hwParam.ulAlarmInterval.longValue());
        tripwireAlarmParaItem.setReserved(new String(hwParam.szReserved).trim());
        BaseAreaParam.TripLineList tripLineList = new BaseAreaParam.TripLineList();
        tripLineList.lineNum = stlineList.ulLineNum.longValue();
        tripLineList.lineList = new IgtLine[5];
        HWPuSDK.PU_IGT_TW_LINE[] lines = stlineList.szTWLineList;
        for (int i = 0; i < lines.length; ++i) {
            IgtLine tripwireLine = new IgtLine();
            HWPuSDK.PU_IGT_TW_LINE line = lines[i];
            WinDef.BOOL lineEnable = line.bEnable;
            String szLineName = new String(line.szLineName).trim();
            WinDef.UCHAR ucDirection = line.ucDirection;
            NativeLong ulLineIndex = line.ulLineIndex;
            HWPuSDK.PU_IGT_POINT_S stStartPoit = line.stStartPoit;
            HWPuSDK.PU_IGT_POINT_S stEndPoit = line.stEndPoit;
            IgtPoint startPoint = new IgtPoint();
            startPoint.setPointPosX(stStartPoit.usPointPosX);
            startPoint.setPointPosY(stStartPoit.usPointPosY);
            IgtPoint endPoint = new IgtPoint();
            endPoint.setPointPosX(stEndPoit.usPointPosX);
            endPoint.setPointPosY(stEndPoit.usPointPosY);
            tripwireLine.setEnable(Boolean.valueOf(lineEnable.booleanValue()));
            tripwireLine.setLineName(szLineName.trim());
            tripwireLine.setDirection(ucDirection.intValue());
            tripwireLine.setLineIndex(ulLineIndex.longValue());
            tripwireLine.setStartPoint(startPoint);
            tripwireLine.setEndPoint(endPoint);
            tripLineList.lineList[i] = tripwireLine;
        }
        tripwireAlarmParaItem.setLineList(tripLineList);
        return tripwireAlarmParaItem;
    }

    private HWPuSDK.PU_TW_ALARM_PARA transTripwireAlarmPara(TripwireAlarmParaRequest tripwireAlarmParaItem) {
        HWPuSDK.PU_TW_ALARM_PARA alarmPara = new HWPuSDK.PU_TW_ALARM_PARA();
        alarmPara.ulChannelId = new WinDef.ULONG(Long.parseLong(tripwireAlarmParaItem.getChannelId()));
        alarmPara.bEnable = new WinDef.BOOL(tripwireAlarmParaItem.getEnable().booleanValue());
        alarmPara.enTargetDetecMode = tripwireAlarmParaItem.getTargetDetecMode();
        alarmPara.ulAlarmInterval = new WinDef.ULONG(tripwireAlarmParaItem.getAlarmInterval());
        alarmPara.szReserved = tripwireAlarmParaItem.getReserved() != null && tripwireAlarmParaItem.getReserved().length() > 0 ? tripwireAlarmParaItem.getReserved().getBytes() : new byte[32 - HWPuSDK.LLong.size];
        BaseAreaParam.TripLineList tripLineList = tripwireAlarmParaItem.getLineList();
        HWPuSDK.PU_IGT_TW_LINE_LIST_S stAreaList = new HWPuSDK.PU_IGT_TW_LINE_LIST_S();
        stAreaList.ulLineNum = new WinDef.ULONG(tripLineList.getLineNum());
        IgtLine[] lineList = tripLineList.getLineList();
        for (int i = 0; i < lineList.length; ++i) {
            stAreaList.szTWLineList[i] = this.toHWLine(lineList[i]);
        }
        alarmPara.stlineList = stAreaList;
        return alarmPara;
    }
}

