/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.impl;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.WinDef;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.AlarmTime;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.AudioDectParam;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.BaseAreaParam;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.DeviceRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.AudioDectAlarmParamRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.request.IpcEmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.respond.AudioDectAlarmParamRespond;
import com.zkteco.zkbiosecurity.cuserver.ipc.exception.IpcException;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.AbstractSdkService;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.HWPuSDK;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.SdkInstance;
import com.zkteco.zkbiosecurity.cuserver.ipc.service.AudioDetectionService;
import org.springframework.stereotype.Component;

@Component
public class SdcAudioDetectionServiceImpl
extends AbstractSdkService
implements AudioDetectionService {
    public boolean setAudioDectAlarmParam(DeviceRequest<AudioDectAlarmParamRequest> request) {
        HWPuSDK.PU_AUDIO_DECT_ALARM_PARA puAudioDectAlarmPara = this.transAudioDectAlarmParam((AudioDectAlarmParamRequest)request.getRequest());
        puAudioDectAlarmPara.write();
        Pointer pointer = puAudioDectAlarmPara.getPointer();
        boolean success = SdkInstance.getInstance().IVS_PU_SetAlarmPara(new WinDef.ULONG(Long.parseLong(request.getSession())), 32, pointer);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        return true;
    }

    public AudioDectAlarmParamRespond getAudioDectAlarmParam(DeviceRequest<IpcEmptyRequest> request) {
        HWPuSDK.PU_AUDIO_DECT_ALARM_PARA puAudioDectAlarmPara = new HWPuSDK.PU_AUDIO_DECT_ALARM_PARA();
        puAudioDectAlarmPara.ulChannelId = new WinDef.ULONG(101L);
        puAudioDectAlarmPara.write();
        Pointer pointer = puAudioDectAlarmPara.getPointer();
        boolean success = SdkInstance.getInstance().IVS_PU_GetAlarmPara(new WinDef.ULONG(Long.parseLong(request.getSession())), 32, pointer);
        if (!success) {
            throw new IpcException(this.errorCode(), this.errorDetail());
        }
        puAudioDectAlarmPara = (HWPuSDK.PU_AUDIO_DECT_ALARM_PARA)Structure.newInstance(HWPuSDK.PU_AUDIO_DECT_ALARM_PARA.class, (Pointer)pointer);
        puAudioDectAlarmPara.read();
        return this.toAudioDectAlarmParam(puAudioDectAlarmPara);
    }

    private AudioDectAlarmParamRespond toAudioDectAlarmParam(HWPuSDK.PU_AUDIO_DECT_ALARM_PARA puParam) {
        AudioDectAlarmParamRespond param = new AudioDectAlarmParamRespond();
        param.setChannelId(puParam.ulChannelId.toString());
        param.setAudioDectPara(this.toAudioDectParam(puParam.stAudioDectPara));
        HWPuSDK.PU_ALARM_TIME_LIST stAreaGuardPlan = puParam.stAlarmTimeList;
        BaseAreaParam.AlarmTimeList sdcAlarmTimeList = new BaseAreaParam.AlarmTimeList();
        sdcAlarmTimeList.num = stAreaGuardPlan.ulNum.longValue();
        sdcAlarmTimeList.alarmTimes = new AlarmTime[8];
        HWPuSDK.PU_ALARM_TIME[] stAlarmTime = stAreaGuardPlan.stAlarmTime;
        for (int i = 0; i < stAlarmTime.length; ++i) {
            sdcAlarmTimeList.alarmTimes[i] = this.toHWAlarmTime(stAlarmTime[i]);
        }
        param.setAlarmTimeList(sdcAlarmTimeList);
        return param;
    }

    private HWPuSDK.PU_AUDIO_DECT_ALARM_PARA transAudioDectAlarmParam(AudioDectAlarmParamRequest param) {
        HWPuSDK.PU_AUDIO_DECT_ALARM_PARA puParam = new HWPuSDK.PU_AUDIO_DECT_ALARM_PARA();
        puParam.ulChannelId = new WinDef.ULONG(Long.parseLong(param.getChannelId()));
        puParam.stAudioDectPara = this.transAudioDectParam(param.getAudioDectPara());
        BaseAreaParam.AlarmTimeList sdcAlarmTimeList = param.getAlarmTimeList();
        AlarmTime[] sdcAlarmTimes = sdcAlarmTimeList.alarmTimes;
        HWPuSDK.PU_ALARM_TIME_LIST puAlarmTimeList = new HWPuSDK.PU_ALARM_TIME_LIST();
        puAlarmTimeList.ulNum = new WinDef.ULONG(sdcAlarmTimeList.num);
        for (int i = 0; i < sdcAlarmTimes.length; ++i) {
            puAlarmTimeList.stAlarmTime[i] = this.transHWAlarmTime(sdcAlarmTimes[i]);
        }
        puParam.stAlarmTimeList = puAlarmTimeList;
        return puParam;
    }

    private AudioDectParam toAudioDectParam(HWPuSDK.PU_AUDIO_DECT_PARA param) {
        AudioDectParam audioDectParam = new AudioDectParam();
        audioDectParam.setEnable(Boolean.valueOf(param.bEnable.booleanValue()));
        audioDectParam.setSensitivity(param.ulSensitivity.longValue());
        return audioDectParam;
    }

    private HWPuSDK.PU_AUDIO_DECT_PARA transAudioDectParam(AudioDectParam param) {
        HWPuSDK.PU_AUDIO_DECT_PARA puAudioDectPara = new HWPuSDK.PU_AUDIO_DECT_PARA();
        puAudioDectPara.bEnable = new WinDef.BOOL(param.getEnable().booleanValue());
        puAudioDectPara.ulSensitivity = new WinDef.ULONG(param.getSensitivity());
        return puAudioDectPara;
    }
}

