/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.config;

import com.sun.jna.Native;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.config.ResourceUtil;
import java.io.File;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;

/*
 * Exception performing whole class analysis ignored.
 */
public class LibraryUtil {
    public static String tempDir;
    public static String BIOSECURITY_DLL_FILE;
    public static String BIOSECURITY_SDK_FILE;

    public static void copyToJavaLibraryPath() {
        Resource[] resources;
        String path = LibraryUtil.getDynamicLibName() + "/" + LibraryUtil.getArch() + "/**/*.*";
        for (Resource resource : resources = ResourceUtil.loadResources((String)path)) {
            LibraryUtil.copyResourceToDir((Resource)resource, (String)tempDir);
        }
    }

    public static File copyResourceToDir(Resource dllResource, String destFileName) {
        File destFile = null;
        try {
            InputStream input = dllResource.getInputStream();
            String[] relativePaths = dllResource.getURI().toString().replaceAll("\\\\", "/").split(LibraryUtil.getDynamicLibName() + "/" + LibraryUtil.getArch());
            String relativePath = relativePaths[relativePaths.length - 1];
            if (StringUtils.containsIgnoreCase((CharSequence)System.getProperty("os.name"), (CharSequence)"windows")) {
                relativePath = relativePath.replaceAll("/", "\\\\");
            }
            if ((destFile = new File(destFileName + relativePath)).exists()) {
                destFile.delete();
            }
            FileUtils.copyInputStreamToFile((InputStream)input, (File)destFile);
            return destFile;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getDynamicLibName() {
        if (StringUtils.containsIgnoreCase((CharSequence)System.getProperty("os.name"), (CharSequence)"windows")) {
            return "dll";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)System.getProperty("os.name"), (CharSequence)"linux")) {
            return "so";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)System.getProperty("os.name"), (CharSequence)"mac")) {
            return "dylib";
        }
        return "unknown";
    }

    public static String getDynamicLibRelativePath() {
        return LibraryUtil.getDynamicLibName() + "/" + LibraryUtil.getArch() + "/";
    }

    public static String getDynamicLibAbsolutePath(String dllName) {
        return System.getProperty("jna.library.path") + dllName;
    }

    public static void loadDynamicLib(String absolutePath) {
        System.load(absolutePath);
    }

    public static String getArch() {
        return System.getProperty("sun.arch.data.model");
    }

    public static void loadLibrary(String dllName) {
        System.load(dllName);
    }

    public static Object nativeLoadLibrary(String dllName, Class cls) {
        return Native.loadLibrary((String)dllName, (Class)cls);
    }

    static {
        String sysTemp;
        tempDir = "";
        BIOSECURITY_DLL_FILE = "biosecurity_dll_file";
        BIOSECURITY_SDK_FILE = "biosecurity_sdk_file";
        if (!"pro".equals(System.getProperty("spring.profiles.active")) && !(tempDir = (sysTemp = System.getProperty("java.io.tmpdir")).endsWith(File.separator) ? sysTemp + BIOSECURITY_DLL_FILE : sysTemp + File.separator + BIOSECURITY_DLL_FILE).equals(System.getProperty("jna.library.path"))) {
            File f = new File(tempDir);
            if (!f.exists()) {
                f.mkdir();
            }
            System.setProperty("jna.library.path", tempDir);
            LibraryUtil.copyToJavaLibraryPath();
            System.out.println(tempDir);
        }
    }
}

