/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.config;

import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.config.LibraryService;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.config.LibraryUtil;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.config.ResourceUtil;
import java.io.File;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class LibraryServiceImpl
implements LibraryService {
    private static final Logger logger = LoggerFactory.getLogger(LibraryServiceImpl.class);
    private String tempDir;

    public void init() {
        String sysTemp = System.getProperty("java.io.tmpdir");
        this.tempDir = sysTemp.endsWith(File.separator) ? sysTemp + LibraryUtil.BIOSECURITY_DLL_FILE : sysTemp + File.separator + LibraryUtil.BIOSECURITY_DLL_FILE;
        File f = new File(this.tempDir);
        if (!f.exists()) {
            f.mkdir();
        }
        this.addJavaLibPath(this.tempDir);
    }

    private void addJavaLibPath(String tempDir) {
        System.setProperty("jna.library.path", tempDir);
    }

    public void copyToJavaLibraryPath() {
        Resource[] resources;
        String path = this.getOs() + "/" + this.getArch() + "/**/*.*";
        for (Resource resource : resources = ResourceUtil.loadResources((String)path)) {
            logger.debug("copy {} to {}", (Object)resource.getFilename(), (Object)this.tempDir);
            this.copyResourceToDir(resource, this.tempDir);
        }
    }

    public void loadLibrary(String dllName) {
        String fileName = this.tempDir + File.separator + dllName + "." + this.getOs();
        System.load(fileName);
    }

    public String getOs() {
        if (StringUtils.containsIgnoreCase((CharSequence)System.getProperty("os.name"), (CharSequence)"windows")) {
            return "dll";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)System.getProperty("os.name"), (CharSequence)"linux")) {
            return "so";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)System.getProperty("os.name"), (CharSequence)"mac")) {
            return "dylib";
        }
        return "unknown";
    }

    private String getArch() {
        return System.getProperty("sun.arch.data.model");
    }

    private File copyResourceToDir(Resource dllResource, String destFileName) {
        File destFile = null;
        try {
            InputStream input = dllResource.getInputStream();
            String[] relativePaths = dllResource.getURI().toString().replaceAll("\\\\", "/").split(this.getOs() + "/" + this.getArch());
            String relativePath = relativePaths[relativePaths.length - 1];
            if (StringUtils.containsIgnoreCase((CharSequence)System.getProperty("os.name"), (CharSequence)"windows")) {
                relativePath = relativePath.replaceAll("/", "\\\\");
            }
            if (!(destFile = new File(destFileName + relativePath)).exists()) {
                FileUtils.copyInputStreamToFile((InputStream)input, (File)destFile);
            }
            return destFile;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

