/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.config;

import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.config.LibraryService;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.config.LibraryUtil;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=0)
public class LibraryInit
implements CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(LibraryInit.class);
    @Resource
    private LibraryService libraryService;
    @Value(value="${system.loadSdcLib:false}")
    private boolean loadSdcLib;

    public void run(String ... strings) throws Exception {
        if (this.loadSdcLib) {
            if (System.getProperty("jna.library.path") == null || !System.getProperty("jna.library.path").contains(LibraryUtil.BIOSECURITY_DLL_FILE)) {
                this.libraryService.init();
                this.libraryService.copyToJavaLibraryPath();
            }
        } else {
            logger.info("LibraryInit config not copy lib");
        }
    }
}

