/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.callback.processor;

import com.zkteco.zkbiosecurity.cuserver.ipc.domain.bean.event.FaceMatchEvent;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.HWPuSDK;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.callback.processor.MetadataProcessor;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaceProcessor
implements MetadataProcessor {
    private static final Logger log = LoggerFactory.getLogger(FaceProcessor.class);

    public FaceMatchEvent process(HWPuSDK.PU_UserData[] targetUserData) {
        ArrayList<Integer> faceLibTypes = new ArrayList<Integer>();
        ArrayList<Boolean> matchResults = new ArrayList<Boolean>();
        boolean matchFlag = false;
        log.debug(" ");
        log.debug("Get a face data packet and start processing");
        log.debug(" ");
        FaceMatchEvent faceMatchEvent = new FaceMatchEvent();
        faceMatchEvent.setGender(2);
        block31: for (HWPuSDK.PU_UserData item : targetUserData) {
            int type = item.eType;
            switch (type) {
                case 0x7000200: {
                    log.debug("Face attributes (glasses): {}", (Object)item.unMetaData.uIntValue);
                    faceMatchEvent.setGlasses(item.unMetaData.uIntValue.intValue());
                    continue block31;
                }
                case 0x7000202: {
                    log.debug("Face attributes (age): {}", (Object)item.unMetaData.uIntValue);
                    faceMatchEvent.setAge(item.unMetaData.uIntValue.intValue());
                    continue block31;
                }
                case 117441027: {
                    log.debug("Face attributes (mask): {}", (Object)item.unMetaData.uIntValue);
                    faceMatchEvent.setMouseMask(item.unMetaData.uIntValue.intValue());
                    continue block31;
                }
                case 117441028: {
                    log.debug("Face attributes (emoji): {}", (Object)item.unMetaData.uIntValue);
                    faceMatchEvent.setExpression(item.unMetaData.uIntValue.intValue());
                    continue block31;
                }
                case 0x1000004: {
                    log.debug("");
                    log.debug("Face matching succeeded: {}", (Object)item.unMetaData.bBoolValue);
                    if (matchFlag && !item.unMetaData.bBoolValue.booleanValue()) continue block31;
                    matchFlag = item.unMetaData.bBoolValue.booleanValue();
                    matchResults.add(item.unMetaData.bBoolValue.booleanValue());
                    continue block31;
                }
                case 117440534: {
                    faceMatchEvent.setFaceId(item.unMetaData.IntValue + "");
                    log.debug("Face ID:" + item.unMetaData.IntValue);
                    continue block31;
                }
                case 0x7000020: {
                    log.debug("Face matching rate: {}", (Object)item.unMetaData.uIntValue.intValue());
                    if (!matchFlag || item.unMetaData.uIntValue.intValue() == 0) continue block31;
                    faceMatchEvent.setFaceMatchRate(item.unMetaData.uIntValue.intValue());
                    continue block31;
                }
                case 0x7000022: {
                    log.debug("List library type\uff1a {}", (Object)item.unMetaData.uIntValue.intValue());
                    faceLibTypes.add(item.unMetaData.uIntValue.intValue());
                    continue block31;
                }
                case 117440616: {
                    log.debug("Capture time: {}", (Object)item.unMetaData.uIntValue.intValue());
                    faceMatchEvent.setPicSnapshotTime(item.unMetaData.uIntValue.intValue() + "");
                    continue block31;
                }
                case 117440773: {
                    log.debug("Match rate sent to the metadata gateway: {}", (Object)item.unMetaData.uIntValue.intValue());
                    continue block31;
                }
                case 134217749: {
                    log.debug("Face cutout generation time: {}", (Object)item.unMetaData.uIntValue.intValue());
                    faceMatchEvent.setFacePicTime(item.unMetaData.uIntValue.intValue() + "");
                    continue block31;
                }
                case 0x8000020: {
                    log.debug("Face matting corresponds to the time zone: {}", (Object)item.unMetaData.uIntValue.intValue());
                    continue block31;
                }
                case 134217833: {
                    log.debug("Capture time zone: {}", (Object)item.unMetaData.uIntValue.intValue());
                    continue block31;
                }
                case 0x8000085: {
                    log.debug("Daylight saving time offset time: {}s", (Object)item.unMetaData.uIntValue.intValue());
                    continue block31;
                }
                case 150995073: {
                    log.debug("Face recognition frame color: {}", (Object)item.unMetaData.uIntValue.intValue());
                    continue block31;
                }
                case 0x9000094: {
                    log.debug("Unspecified field: Value is {}", (Object)item.unMetaData.uIntValue.intValue());
                    continue block31;
                }
                case 167772178: {
                    log.debug("Face cutout has been received");
                    if (item.unMetaData.stBinay.pBinaryData != null) {
                        faceMatchEvent.setFacePic(item.unMetaData.stBinay.pBinaryData.getByteArray(0L, item.unMetaData.stBinay.ulBinaryLenth.intValue()));
                        continue block31;
                    }
                    log.debug("The device did not upload a cutout");
                    continue block31;
                }
                case 167772183: {
                    if (item.unMetaData.stBinay.pBinaryData != null) {
                        log.debug("The big picture stream has been received");
                        faceMatchEvent.setFacePanorama(item.unMetaData.stBinay.pBinaryData.getByteArray(0L, item.unMetaData.stBinay.ulBinaryLenth.intValue()));
                        continue block31;
                    }
                    log.debug("The device did not upload a large image");
                    continue block31;
                }
                case 0xA000020: {
                    if (item.unMetaData.stBinay.pBinaryData != null) {
                        log.debug("Feature value of face capture has been received");
                        continue block31;
                    }
                    log.debug("The device did not upload the captured feature value");
                    continue block31;
                }
                case 0xA00007A: {
                    if (item.unMetaData.stBinay.pBinaryData != null) {
                        log.debug("Picture UUID has been received");
                        continue block31;
                    }
                    log.debug("The device did not upload the picture UUID");
                    continue block31;
                }
                case 0xB000011: {
                    log.debug("The position of the small frame of the face cutout: {},{},{},{}", new Object[]{item.unMetaData.stRec.usX, item.unMetaData.stRec.usY, item.unMetaData.stRec.usWidth, item.unMetaData.stRec.usHeight});
                    continue block31;
                }
                case 33554556: {
                    log.debug("Visitor type: {}", (Object)item.unMetaData.uIntValue.intValue());
                    continue block31;
                }
                case 0x7000017: {
                    log.debug("Face ID in the list library: {}", (Object)item.unMetaData.uIntValue.intValue());
                    faceMatchEvent.setFaceLibRecordId(item.unMetaData.uIntValue.intValue() + "");
                    continue block31;
                }
                case 117440771: {
                    log.debug("Statistics of the number of people captured by the current camera: {}", (Object)item.unMetaData.uIntValue.intValue());
                    continue block31;
                }
                case 117440772: {
                    log.debug("Number of people captured in the entire service: {}", (Object)item.unMetaData.uIntValue.intValue());
                    continue block31;
                }
                case 167772180: {
                    if (item.unMetaData.stBinay.pBinaryData != null) {
                        log.debug("The matching picture in the face library has been received");
                        faceMatchEvent.setFacePicInLib(item.unMetaData.stBinay.pBinaryData.getByteArray(0L, item.unMetaData.stBinay.ulBinaryLenth.intValue()));
                        continue block31;
                    }
                    log.debug("The device does not upload a face library picture");
                    continue block31;
                }
                case 167772181: {
                    log.debug("List library name: {}", (Object)this.byteToString(item.unMetaData.stBinay.pBinaryData.getByteArray(0L, item.unMetaData.stBinay.ulBinaryLenth.intValue())));
                    faceMatchEvent.setLibName(this.byteToString(item.unMetaData.stBinay.pBinaryData.getByteArray(0L, item.unMetaData.stBinay.ulBinaryLenth.intValue())));
                    continue block31;
                }
                case 167772283: {
                    if (item.unMetaData.stBinay.pBinaryData != null) {
                        log.debug("ID card MD 5\uff0c {}", (Object)this.byteToString(item.unMetaData.stBinay.pBinaryData.getByteArray(0L, item.unMetaData.stBinay.ulBinaryLenth.intValue())));
                        continue block31;
                    }
                    log.debug("The device does not upload the ID card MD 5");
                    continue block31;
                }
                case 0x12000001: {
                    log.debug("Face information: {}", (Object)this.byteToString(item.unMetaData.stFaceInfo.name));
                    faceMatchEvent.setName(this.byteToString(item.unMetaData.stFaceInfo.name));
                    faceMatchEvent.setGender(item.unMetaData.stFaceInfo.iGender);
                    faceMatchEvent.setBirth(this.byteToString(item.unMetaData.stFaceInfo.birthday));
                    faceMatchEvent.setProvince(this.byteToString(item.unMetaData.stFaceInfo.province));
                    faceMatchEvent.setCity(this.byteToString(item.unMetaData.stFaceInfo.city));
                    faceMatchEvent.setCardType(item.unMetaData.stFaceInfo.iCardType);
                    faceMatchEvent.setCardId(this.byteToString(item.unMetaData.stFaceInfo.cardID));
                    continue block31;
                }
            }
        }
        log.debug(" ");
        log.debug("Get a face data packet and end processing");
        for (int i = 0; i < matchResults.size(); ++i) {
            if (!((Boolean)matchResults.get(i)).booleanValue()) continue;
            if (matchResults.size() == faceLibTypes.size()) {
                faceMatchEvent.setFaceLibType(((Integer)faceLibTypes.get(i)).intValue());
                break;
            }
            faceMatchEvent.setFaceLibType(((Integer)faceLibTypes.get(0)).intValue());
            break;
        }
        return faceMatchEvent;
    }

    public boolean supports(int type) {
        return type == 2;
    }

    private String byteToString(byte[] bytes) {
        int length = 0;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != 0) continue;
            length = i;
            break;
        }
        String s = null;
        s = new String(bytes, 0, length, StandardCharsets.UTF_8);
        return s;
    }
}

