/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.callback;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.ptr.PointerByReference;
import com.zkteco.zkbiosecurity.cuserver.ipc.callback.MetadataCallback;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.bean.event.MetadataEvent;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.HWPuSDK;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.SdkInstance;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.callback.MetadataDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdcMetadataCallback
implements HWPuSDK.pfRealDataCallBack {
    private static final Logger log = LoggerFactory.getLogger(SdcMetadataCallback.class);
    private final MetadataCallback eventCallback;
    private final MetadataDispatcher metadataDispatcher = new MetadataDispatcher();

    public SdcMetadataCallback(MetadataCallback callback) {
        this.eventCallback = callback;
    }

    public Pointer invoke(Pointer szBuffer, NativeLong lSize, Pointer pUsrData) {
        if (szBuffer != null) {
            String session = pUsrData.getString(0L);
            HWPuSDK.PU_META_DATA targetMetaData = new HWPuSDK.PU_META_DATA();
            PointerByReference targetPointer = new PointerByReference(targetMetaData.getPointer());
            boolean isOk = SdkInstance.getInstance().IVS_User_GetMetaData(szBuffer, new WinDef.ULONG(lSize.longValue()), 2, targetPointer);
            if (isOk) {
                if (targetPointer.getValue() != null) {
                    targetMetaData.getPointer().write(0L, targetPointer.getValue().getByteArray(0L, targetMetaData.size()), 0, targetMetaData.size());
                    targetMetaData.read();
                    if (targetMetaData.pstMetaUserData != null) {
                        HWPuSDK.PU_UserData[] targetUserData = (HWPuSDK.PU_UserData[])targetMetaData.pstMetaUserData.toArray(targetMetaData.usValidNumber.intValue());
                        SdkInstance.getInstance().IVS_User_FreeMetaData(targetPointer);
                        MetadataEvent result = this.metadataDispatcher.process(session, targetUserData);
                        if (result.getTarget() != null) {
                            this.eventCallback.processMetadata(result);
                        }
                    }
                }
                SdkInstance.getInstance().IVS_User_FreeMetaData(targetPointer);
            }
        }
        return null;
    }
}

