/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.callback;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.callback.SdcAlarmEventCallback;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.callback.SdcMetadataCallback;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class CallbackManager {
    private static final Logger log = LoggerFactory.getLogger(CallbackManager.class);
    private static final Map<String, SdcAlarmEventCallback> alarmCallbackMap = new ConcurrentHashMap();
    private static final Map<String, Pointer> alarmPointerMap = new ConcurrentHashMap();
    private static final Map<String, SdcMetadataCallback> metaCallbackMap = new ConcurrentHashMap();
    private static final Map<String, Pointer> metaPointerMap = new ConcurrentHashMap();

    public static void addAlarmCallback(String sessionId, SdcAlarmEventCallback eventCallback) {
        Assert.notNull((Object)sessionId, (String)"Device can not be null");
        Assert.notNull((Object)eventCallback, (String)"Callback can not be null");
        alarmCallbackMap.put(sessionId, eventCallback);
        Memory pointer = new Memory(33L);
        pointer.setString(0L, sessionId);
        alarmPointerMap.put(sessionId, pointer);
        log.debug("Add a new callback, id={}, callback={}", (Object)sessionId, (Object)eventCallback);
    }

    public static void removeAlarmCallback(String sessionId) {
        Assert.notNull((Object)sessionId, (String)"Device can not be null!");
        alarmCallbackMap.remove(sessionId);
        alarmPointerMap.remove(sessionId);
    }

    public static Pointer getAlarmPointer(String id) {
        return (Pointer)alarmPointerMap.get(id);
    }

    public static void addMetaCallback(String sessionId, SdcMetadataCallback eventCallback) {
        Assert.notNull((Object)sessionId, (String)"sessionId can not be null");
        Assert.notNull((Object)eventCallback, (String)"Callback can not be null");
        metaCallbackMap.put(sessionId, eventCallback);
        Memory pointer = new Memory(10L);
        pointer.setString(0L, sessionId);
        metaPointerMap.put(sessionId, pointer);
        log.debug("Add a new meta callback, session id={}, callback={}", (Object)sessionId, (Object)eventCallback);
    }

    public static void removeMetaCallback(String sessionId) {
        Assert.notNull((Object)sessionId, (String)"Device can not be null!");
        metaCallbackMap.remove(sessionId);
        metaPointerMap.remove(sessionId);
        log.debug("Remove meta callback from session {}", (Object)sessionId);
    }

    public static Pointer getMetaPointer(String id) {
        return (Pointer)metaPointerMap.get(id);
    }
}

