/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk;

import com.sun.jna.Native;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.HWPuSDK;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.util.SystemOsUtil;
import com.zkteco.zkbiosecurity.cuserver.ipc.service.EnvironmentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class SdkInstance
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(SdkInstance.class);
    private static HWPuSDK hwPuSDK;
    @Autowired
    private EnvironmentService environmentService;
    @Value(value="${system.loadSdcLib:false}")
    private boolean loadSdcLib;

    public static HWPuSDK getInstance() {
        return hwPuSDK;
    }

    public void run(String ... args) {
        try {
            if (this.loadSdcLib) {
                log.debug("jna.library.path is {}", (Object)System.getProperty("jna.library.path"));
                boolean loadLibrary = false;
                if (SystemOsUtil.isWindow()) {
                    hwPuSDK = (HWPuSDK)Native.loadLibrary((String)"HWPuSDK", HWPuSDK.class);
                    loadLibrary = true;
                } else if (SystemOsUtil.isLinux()) {
                    hwPuSDK = (HWPuSDK)Native.loadLibrary((String)"hwpusdk", HWPuSDK.class);
                    loadLibrary = true;
                }
                if (loadLibrary) {
                    log.info("SDC SDK init success");
                    this.environmentService.prepare();
                }
            } else {
                log.info("config not load sdc library");
            }
        }
        catch (Exception e) {
            log.error("SDC SDK init fail", (Throwable)e);
        }
    }
}

