/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk;

import com.sun.jna.NativeLong;
import com.sun.jna.platform.win32.WinDef;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.AlarmTime;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.IgaArea;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.IgtPoint;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.PTZCurrentLocation;
import com.zkteco.zkbiosecurity.cuserver.ipc.domain.Time;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.HWPuSDK;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.SdkInstance;

public abstract class AbstractSdkService {
    public String errorDetail() {
        long errorCode = SdkInstance.getInstance().IVS_PU_GetLastError();
        String errMsg = new StringBuilder("{'error code' : ").append(errorCode).append(", 'error message' : '") + SdkInstance.getInstance().IVS_PU_GetErrorMsg(errorCode) + "'}";
        return errMsg;
    }

    protected String errorCode() {
        return String.valueOf(SdkInstance.getInstance().IVS_PU_GetLastError());
    }

    protected String errorMsg() {
        String errorCode = this.errorCode();
        return SdkInstance.getInstance().IVS_PU_GetErrorMsg(Long.valueOf(errorCode).longValue());
    }

    public HWPuSDK.PU_ALARM_TIME transHWAlarmTime(AlarmTime alarmTime) {
        HWPuSDK.PU_ALARM_TIME puAlarmTime = new HWPuSDK.PU_ALARM_TIME();
        puAlarmTime.ulCycleType = new WinDef.ULONG(alarmTime.getCycleType());
        puAlarmTime.ulPeriod = new WinDef.ULONG(alarmTime.getPeriod());
        puAlarmTime.stStart = this.transHWTime(alarmTime.getStart());
        puAlarmTime.stEnd = this.transHWTime(alarmTime.getEnd());
        return puAlarmTime;
    }

    public AlarmTime toHWAlarmTime(HWPuSDK.PU_ALARM_TIME alarmTime) {
        AlarmTime puAlarmTime = new AlarmTime();
        puAlarmTime.setCycleType(alarmTime.ulCycleType.longValue());
        puAlarmTime.setPeriod(alarmTime.ulPeriod.longValue());
        puAlarmTime.setStart(this.toHWTime(alarmTime.stStart));
        puAlarmTime.setEnd(this.toHWTime(alarmTime.stEnd));
        return puAlarmTime;
    }

    public IgaArea toIgaArea(HWPuSDK.PU_IGT_AREA igtArea) {
        IgaArea enterArea = new IgaArea();
        enterArea.setPointNum(igtArea.uPointNum);
        enterArea.setPoint(new IgtPoint[10]);
        HWPuSDK.PU_IGT_POINT_S[] stPoint = igtArea.stPoint;
        for (int i = 0; i < stPoint.length; ++i) {
            enterArea.getPoint()[i] = this.toIgtPoint(stPoint[i]);
        }
        enterArea.setAreaIndex(igtArea.ulAreaIndex.longValue());
        enterArea.enable = igtArea.bEnable.booleanValue();
        enterArea.setAreaName(new String(igtArea.szAreaName).trim());
        enterArea.setLocation(this.toPTZCurrentLocation(igtArea.stLocation));
        return enterArea;
    }

    public HWPuSDK.PU_IGT_AREA transIgaArea(IgaArea enterArea) {
        HWPuSDK.PU_IGT_AREA igtArea = new HWPuSDK.PU_IGT_AREA();
        igtArea.uPointNum = enterArea.getPointNum();
        IgtPoint[] sdcIgtPoints = enterArea.getPoint();
        HWPuSDK.PU_IGT_POINT_S[] stPoint = new HWPuSDK.PU_IGT_POINT_S[10];
        for (int i = 0; i < sdcIgtPoints.length; ++i) {
            stPoint[i] = this.transIgtPoint(sdcIgtPoints[i]);
        }
        igtArea.stPoint = stPoint;
        igtArea.ulAreaIndex = new WinDef.ULONG(enterArea.getAreaIndex());
        igtArea.bEnable = new WinDef.BOOL(enterArea.enable);
        igtArea.szAreaName = enterArea.getAreaName() != null && enterArea.getAreaName().length() > 0 ? enterArea.getAreaName().getBytes() : new byte[36];
        igtArea.stLocation = this.transPTZCurrentLocation(enterArea.getLocation());
        return igtArea;
    }

    public PTZCurrentLocation toPTZCurrentLocation(HWPuSDK.PU_PTZ_CURRENT_LOCATION ptzLocation) {
        PTZCurrentLocation ptzCurrentLocation = new PTZCurrentLocation();
        ptzCurrentLocation.lPTZHorDegree = ptzLocation.lPTZHorDegree.intValue();
        ptzCurrentLocation.lPTZVerDegree = ptzLocation.lPTZVerDegree.intValue();
        ptzCurrentLocation.ulLenMultiple = ptzLocation.ulLenMultiple.longValue();
        ptzCurrentLocation.ulDotLenMultiple = ptzLocation.ulDotLenMultiple.longValue();
        ptzCurrentLocation.ulZoomRatio = ptzLocation.ulZoomRatio.longValue();
        ptzCurrentLocation.ulDotZoomRatio = ptzLocation.ulDotZoomRatio.longValue();
        ptzCurrentLocation.lPTZDotHorDegree = ptzLocation.lPTZDotHorDegree.intValue();
        ptzCurrentLocation.lPTZDotVerDegree = ptzLocation.lPTZDotVerDegree.intValue();
        return ptzCurrentLocation;
    }

    public HWPuSDK.PU_PTZ_CURRENT_LOCATION transPTZCurrentLocation(PTZCurrentLocation ptzCurrentLocation) {
        HWPuSDK.PU_PTZ_CURRENT_LOCATION ptzLocation = new HWPuSDK.PU_PTZ_CURRENT_LOCATION();
        ptzLocation.lPTZHorDegree = new NativeLong((long)ptzCurrentLocation.lPTZHorDegree);
        ptzLocation.lPTZVerDegree = new NativeLong((long)ptzCurrentLocation.lPTZVerDegree);
        ptzLocation.ulLenMultiple = new WinDef.ULONG(ptzCurrentLocation.ulLenMultiple);
        ptzLocation.ulDotLenMultiple = new WinDef.ULONG(ptzCurrentLocation.ulDotLenMultiple);
        ptzLocation.ulZoomRatio = new WinDef.ULONG(ptzCurrentLocation.ulZoomRatio);
        ptzLocation.ulDotZoomRatio = new WinDef.ULONG(ptzCurrentLocation.ulDotZoomRatio);
        ptzLocation.lPTZDotHorDegree = new NativeLong((long)ptzCurrentLocation.lPTZDotHorDegree);
        ptzLocation.lPTZDotVerDegree = new NativeLong((long)ptzCurrentLocation.lPTZDotVerDegree);
        return ptzLocation;
    }

    public IgtPoint toIgtPoint(HWPuSDK.PU_IGT_POINT_S igtPoint) {
        IgtPoint igtPoint1 = new IgtPoint();
        igtPoint1.setPointPosX(igtPoint.usPointPosX);
        igtPoint1.setPointPosY(igtPoint.usPointPosY);
        return igtPoint1;
    }

    public HWPuSDK.PU_IGT_POINT_S transIgtPoint(IgtPoint igtPoint) {
        HWPuSDK.PU_IGT_POINT_S puIgtPointS = new HWPuSDK.PU_IGT_POINT_S();
        puIgtPointS.usPointPosX = igtPoint.getPointPosX();
        puIgtPointS.usPointPosY = igtPoint.getPointPosY();
        return puIgtPointS;
    }

    private HWPuSDK.PU_TIME_S transHWTime(Time puTime) {
        HWPuSDK.PU_TIME_S puTimeS = new HWPuSDK.PU_TIME_S();
        puTimeS.szYear = puTime.szYear != null && puTime.szYear.length() > 0 ? puTime.szYear.getBytes() : new byte[5];
        puTimeS.szMonth = puTime.szMonth != null && puTime.szMonth.length() > 0 ? puTime.szMonth.getBytes() : new byte[3];
        puTimeS.szDay = puTime.szDay != null && puTime.szDay.length() > 0 ? puTime.szDay.getBytes() : new byte[3];
        puTimeS.szHour = puTime.szHour != null && puTime.szHour.length() > 0 ? puTime.szHour.getBytes() : new byte[3];
        puTimeS.szMinute = puTime.szMinute != null && puTime.szMinute.length() > 0 ? puTime.szMinute.getBytes() : new byte[3];
        puTimeS.szSecond = puTime.szSecond != null && puTime.szSecond.length() > 0 ? puTime.szSecond.getBytes() : new byte[3];
        return puTimeS;
    }

    private Time toHWTime(HWPuSDK.PU_TIME_S puTimeS) {
        Time puTime = new Time();
        puTime.setSzYear(new String(puTimeS.szYear).trim());
        puTime.setSzMonth(new String(puTimeS.szMonth).trim());
        puTime.setSzDay(new String(puTimeS.szDay).trim());
        puTime.setSzHour(new String(puTimeS.szHour).trim());
        puTime.setSzMinute(new String(puTimeS.szMinute).trim());
        puTime.setSzSecond(new String(puTimeS.szSecond).trim());
        return puTime;
    }

    public AlarmTime toAlarmTime(HWPuSDK.PU_ALARM_TIME_S puAlarmTimeS) {
        AlarmTime alarmTime = new AlarmTime();
        alarmTime.setCycleType((long)puAlarmTimeS.ulCycleType.intValue());
        alarmTime.setPeriod((long)puAlarmTimeS.ulPeriod.intValue());
        alarmTime.setStart(this.toHWTime(puAlarmTimeS.stStart));
        alarmTime.setEnd(this.toHWTime(puAlarmTimeS.stEnd));
        return alarmTime;
    }

    public HWPuSDK.PU_ALARM_TIME_S transAlarmTime(AlarmTime alarmTimeS) {
        HWPuSDK.PU_ALARM_TIME_S puAlarmTimeS = new HWPuSDK.PU_ALARM_TIME_S();
        puAlarmTimeS.ulCycleType = new NativeLong(alarmTimeS.getCycleType());
        puAlarmTimeS.ulPeriod = new NativeLong(alarmTimeS.getPeriod());
        puAlarmTimeS.stStart = this.transHWTime(alarmTimeS.getStart());
        puAlarmTimeS.stEnd = this.transHWTime(alarmTimeS.getEnd());
        return puAlarmTimeS;
    }
}

