/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.dto.request.sdc;

import com.alibaba.fastjson.annotation.JSONField;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.BehaviorSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.sdc.BehaviorSetRequestSdc;
import com.zkteco.zkbiosecurity.cuserver.dto.request.sdc.bean.Line;
import com.zkteco.zkbiosecurity.cuserver.dto.request.sdc.bean.Point;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.bean.Nvr800AreaItem;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.bean.Nvr800LineItem;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.bean.PointItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class BehaviorSetRequestSdc {
    @JSONField(name="alarmTime")
    private Integer alarmTime;
    @JSONField(name="enable")
    private Integer enable;
    @JSONField(name="targetRecMode")
    private Integer targetRecMode;
    @JSONField(name="ulRemainTime")
    private Integer ulRemainTime;
    @JSONField(name="sensitivity")
    private Integer sensitivity;
    @JSONField(name="objFilterFlag")
    private Integer objFilterFlag;
    @JSONField(name="areas")
    private Areas areas;
    @JSONField(name="lines")
    private Lines lines;
    @JSONField(name="alarmType")
    private Integer alarmType;

    public static BehaviorSetRequestSdc convert(BehaviorSetRequest behaviorSetRequest) {
        List lineList;
        BehaviorSetRequestSdc behaviorSetRequestSdc = new BehaviorSetRequestSdc();
        behaviorSetRequestSdc.setAlarmTime(behaviorSetRequest.getAlarmInterval());
        if (behaviorSetRequest.getEnable() == null) {
            behaviorSetRequestSdc.setEnable(Integer.valueOf(1));
        } else {
            behaviorSetRequestSdc.setEnable(Integer.valueOf(behaviorSetRequest.getEnable() != false ? 1 : 0));
        }
        if ("Center".equals(behaviorSetRequest.getRecognizeMode())) {
            behaviorSetRequestSdc.setTargetRecMode(Integer.valueOf(0));
        }
        behaviorSetRequestSdc.setUlRemainTime(behaviorSetRequest.getToleranceTime());
        behaviorSetRequestSdc.setSensitivity(behaviorSetRequest.getSensitivity());
        int objFilterFlag = 0;
        List detectTypes = behaviorSetRequest.getDetectType();
        for (String detectType : detectTypes) {
            if ("Pedestrian".equals(detectType)) {
                ++objFilterFlag;
                continue;
            }
            if ("Vehicle".equals(detectType)) {
                objFilterFlag += 2;
                continue;
            }
            if (!"NonVehicle".equals(detectType)) continue;
            objFilterFlag += 4;
        }
        behaviorSetRequestSdc.setObjFilterFlag(Integer.valueOf(objFilterFlag));
        List areaList = behaviorSetRequest.getAreaList();
        if (!CollectionUtils.isEmpty((Collection)areaList)) {
            Areas areas = new Areas();
            ArrayList<Areas.Area> sdcAreaList = new ArrayList<Areas.Area>();
            for (Nvr800AreaItem nvr800AreaItem : areaList) {
                Areas.Area area = new Areas.Area();
                area.setIndex(Integer.valueOf(nvr800AreaItem.getIndex()));
                area.setEnable(Integer.valueOf(nvr800AreaItem.getEnable() != false ? 1 : 0));
                area.setPointNum(nvr800AreaItem.getPointNum());
                area.setAreaName(nvr800AreaItem.getAreaName());
                List pointList = nvr800AreaItem.getPointList();
                ArrayList<Point> sdcPoint = new ArrayList<Point>();
                for (PointItem pointItem : pointList) {
                    Point point = new Point();
                    point.setPointX(pointItem.getPointX());
                    point.setPointY(pointItem.getPointY());
                    sdcPoint.add(point);
                }
                area.setPoint(sdcPoint);
                area.setPointNum(Integer.valueOf(sdcPoint.size()));
                Areas.Area.Location location = new Areas.Area.Location();
                if (nvr800AreaItem.getLocation() != null) {
                    location.setXDegree(nvr800AreaItem.getLocation().getXDegree());
                    location.setYDegree(nvr800AreaItem.getLocation().getYDegree());
                    location.setDZoomRatio(nvr800AreaItem.getLocation().getDZoomRatio());
                    location.setPos(nvr800AreaItem.getLocation().getPos());
                    location.setVideoRotation(nvr800AreaItem.getLocation().getVideoRotation());
                    area.setLocation(location);
                }
                sdcAreaList.add(area);
            }
            areas.setArea(sdcAreaList);
            areas.setAreaNum(Integer.valueOf(sdcAreaList.size()));
            behaviorSetRequestSdc.setAreas(areas);
        }
        if (!CollectionUtils.isEmpty((Collection)(lineList = behaviorSetRequest.getLineList()))) {
            Lines lines = new Lines();
            ArrayList<Line> sdcLines = new ArrayList<Line>();
            for (Nvr800LineItem nvr800LineItem : lineList) {
                Line line = new Line();
                if ("A<->B".equals(nvr800LineItem.getRuleType())) {
                    line.setDirection(Integer.valueOf(0));
                } else if ("A->B".equals(nvr800LineItem.getRuleType())) {
                    line.setDirection(Integer.valueOf(1));
                } else if ("B->A".equals(nvr800LineItem.getRuleType())) {
                    line.setDirection(Integer.valueOf(1));
                }
                if (nvr800LineItem.getEnable() != null) {
                    line.setEnable(Integer.valueOf(nvr800LineItem.getEnable() != false ? 1 : 0));
                } else {
                    line.setEnable(Integer.valueOf(1));
                }
                line.setIndex(nvr800LineItem.getIndex());
                line.setLineName(nvr800LineItem.getLineName());
                Point pointS = new Point();
                pointS.setPointX(nvr800LineItem.getX1());
                pointS.setPointY(nvr800LineItem.getY1());
                line.setPosS(pointS);
                Point pointE = new Point();
                pointE.setPointX(nvr800LineItem.getX2());
                pointE.setPointY(nvr800LineItem.getY2());
                line.setPosE(pointE);
                sdcLines.add(line);
            }
            lines.setLineList(sdcLines);
            lines.setLineNum(Integer.valueOf(sdcLines.size()));
            behaviorSetRequestSdc.setLines(lines);
        }
        return behaviorSetRequestSdc;
    }

    public Integer getAlarmTime() {
        return this.alarmTime;
    }

    public Integer getEnable() {
        return this.enable;
    }

    public Integer getTargetRecMode() {
        return this.targetRecMode;
    }

    public Integer getUlRemainTime() {
        return this.ulRemainTime;
    }

    public Integer getSensitivity() {
        return this.sensitivity;
    }

    public Integer getObjFilterFlag() {
        return this.objFilterFlag;
    }

    public Areas getAreas() {
        return this.areas;
    }

    public Lines getLines() {
        return this.lines;
    }

    public Integer getAlarmType() {
        return this.alarmType;
    }

    public void setAlarmTime(Integer alarmTime) {
        this.alarmTime = alarmTime;
    }

    public void setEnable(Integer enable) {
        this.enable = enable;
    }

    public void setTargetRecMode(Integer targetRecMode) {
        this.targetRecMode = targetRecMode;
    }

    public void setUlRemainTime(Integer ulRemainTime) {
        this.ulRemainTime = ulRemainTime;
    }

    public void setSensitivity(Integer sensitivity) {
        this.sensitivity = sensitivity;
    }

    public void setObjFilterFlag(Integer objFilterFlag) {
        this.objFilterFlag = objFilterFlag;
    }

    public void setAreas(Areas areas) {
        this.areas = areas;
    }

    public void setLines(Lines lines) {
        this.lines = lines;
    }

    public void setAlarmType(Integer alarmType) {
        this.alarmType = alarmType;
    }
}

