/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.dto;

import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import javax.servlet.http.HttpServletRequest;

public class MsgType {
    HttpMethodEnum httpMethod;
    String uri;
    boolean fullUrl = false;

    public MsgType(HttpMethodEnum httpMethod, String uri) {
        this(httpMethod, uri, false);
    }

    public MsgType(HttpMethodEnum httpMethod, String uri, boolean fullUrl) {
        this.httpMethod = httpMethod;
        this.uri = uri;
        this.fullUrl = fullUrl;
    }

    public static MsgType parse(HttpServletRequest request) throws SDKException {
        String requestURI = request.getRequestURI();
        String method = request.getMethod();
        if ("GET".equals(method)) {
            return new MsgType(HttpMethodEnum.HTTP_METHOD_GET, requestURI);
        }
        if ("POST".equals(method)) {
            return new MsgType(HttpMethodEnum.HTTP_METHOD_POST, requestURI);
        }
        if ("DELETE".equals(method)) {
            return new MsgType(HttpMethodEnum.HTTP_METHOD_DELETE, requestURI);
        }
        if ("PATCH".equals(method)) {
            return new MsgType(HttpMethodEnum.HTTP_METHOD_PATCH, requestURI);
        }
        throw new SDKException("1", "unsupported http method[" + method + "]");
    }

    public String getUri() {
        return this.uri;
    }

    public HttpMethodEnum getMethod() {
        return this.httpMethod;
    }

    public boolean isFullUrl() {
        return this.fullUrl;
    }
}

