/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.controller;

import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.enums.DeviceTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.IService;

public interface BaseController<T extends IService<?>> {
    public T getIvs3800Server();

    public T getIvs1800Server();

    public T getNvr800Server();

    default public T getSdcServer() {
        return null;
    }

    default public T getSdcServer(int implType) {
        return null;
    }

    default public T getCloudServer() {
        return null;
    }

    default public T getZKNVRServer() {
        return null;
    }

    default public T getZKIPCServer() {
        return null;
    }

    default public T getTIANDYServer() {
        return null;
    }

    default public T getHIKVISIONServer() {
        return null;
    }

    default public T getOnvifServer() {
        return null;
    }

    default public T getDHNVRServer() {
        return null;
    }

    default public T getServer(VcmReqBaseInfo vcmInfo) {
        if (DeviceTypeEnum.IVS1800.val() == vcmInfo.getVcmType().intValue()) {
            return (T)this.getIvs1800Server();
        }
        if (DeviceTypeEnum.NVR800.val() == vcmInfo.getVcmType().intValue()) {
            return (T)this.getNvr800Server();
        }
        if (DeviceTypeEnum.IVS3800.val() == vcmInfo.getVcmType().intValue()) {
            return (T)this.getIvs3800Server();
        }
        if (DeviceTypeEnum.SDC.val() == vcmInfo.getVcmType().intValue()) {
            return (T)this.getSdcServer(vcmInfo.getSdcType());
        }
        if (DeviceTypeEnum.CLOUD.val() == vcmInfo.getVcmType().intValue()) {
            return (T)this.getCloudServer();
        }
        if (DeviceTypeEnum.ZKNVR.val() == vcmInfo.getVcmType().intValue()) {
            return (T)this.getZKNVRServer();
        }
        if (DeviceTypeEnum.ZKIPC.val() == vcmInfo.getVcmType().intValue()) {
            return (T)this.getZKIPCServer();
        }
        if (DeviceTypeEnum.TIANDY.val() == vcmInfo.getVcmType().intValue()) {
            return (T)this.getTIANDYServer();
        }
        if (DeviceTypeEnum.HIKVISION.val() == vcmInfo.getVcmType().intValue()) {
            return (T)this.getHIKVISIONServer();
        }
        if (DeviceTypeEnum.ONVIFNVR.val() == vcmInfo.getVcmType().intValue()) {
            return (T)this.getOnvifServer();
        }
        if (DeviceTypeEnum.ONVIFIPC.val() == vcmInfo.getVcmType().intValue()) {
            return (T)this.getOnvifServer();
        }
        if (DeviceTypeEnum.DHNVR.val() == vcmInfo.getVcmType().intValue()) {
            return (T)this.getDHNVRServer();
        }
        throw new InvokeException("500", "param_error");
    }
}

