/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.config;

import com.zkteco.zkbiosecurity.cuserver.config.SSLWebServerConfig;
import org.apache.catalina.connector.Connector;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SSLWebServerConfig {
    private static final Logger log = LoggerFactory.getLogger(SSLWebServerConfig.class);
    @Value(value="${server.port}")
    private int port;

    @Bean
    public ServletWebServerFactory servletContainer() {
        1 tomcat = new /* Unavailable Anonymous Inner Class!! */;
        tomcat.addContextCustomizers(new TomcatContextCustomizer[]{context -> {
            SecurityCollection collection = new SecurityCollection();
            collection.addMethod("PUT");
            collection.addMethod("DELETE");
            collection.addMethod("HEAD");
            collection.addMethod("OPTIONS");
            collection.addMethod("TRACE");
            collection.addPattern("/*");
            SecurityConstraint constraint = new SecurityConstraint();
            constraint.addCollection(collection);
            constraint.setAuthConstraint(true);
            context.addConstraint(constraint);
        }});
        Connector connector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
        connector.setPort(this.port + 1);
        tomcat.addAdditionalTomcatConnectors(new Connector[]{connector});
        return tomcat;
    }
}

