/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.config;

import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.InitRequest;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ConfigHolder {
    private static final Map<String, Object> CONFIG_MAP = new HashMap();

    public static void set(InitRequest initRequest) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{initRequest.getIp()})) {
            CONFIG_MAP.put("ip", initRequest.getIp());
        }
        if (StringUtils.isNotBlank((CharSequence)initRequest.getHttpPort())) {
            CONFIG_MAP.put("httpPort", initRequest.getHttpPort());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{initRequest.getHttpSchema()})) {
            CONFIG_MAP.put("httpSchema", initRequest.getHttpSchema());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{initRequest.getTimeZone()})) {
            CONFIG_MAP.put("timeZone", initRequest.getTimeZone());
        }
        if (initRequest.getDebugLog() != null) {
            CONFIG_MAP.put("debugLog", initRequest.getDebugLog());
        }
        if (initRequest.getAccessLog() != null) {
            CONFIG_MAP.put("accessLog", initRequest.getAccessLog());
        }
        if (initRequest.getReady() != null) {
            CONFIG_MAP.put("ready", initRequest.getReady());
        }
        if (initRequest.getNatEnabled() != null) {
            CONFIG_MAP.put("natEnabled", initRequest.getNatEnabled());
        }
        if (initRequest.getSnapSwitch() != null) {
            CONFIG_MAP.put("snapSwitch", initRequest.getSnapSwitch());
        }
    }

    public static Map<String, Object> get() {
        return CONFIG_MAP;
    }

    public static String getIp() {
        if (CONFIG_MAP.containsKey("ip")) {
            return CONFIG_MAP.get("ip").toString();
        }
        return "";
    }

    public static String getIpByParentDeviceId(String parentDeviceId) {
        if (CONFIG_MAP.containsKey(parentDeviceId)) {
            return CONFIG_MAP.get(parentDeviceId).toString();
        }
        if (CONFIG_MAP.containsKey("ip")) {
            return CONFIG_MAP.get("ip").toString();
        }
        return "";
    }

    public static void putIpByParentDeviceId(String parentDeviceId, String ip) {
        if (StringUtils.isNotBlank((CharSequence)parentDeviceId) && StringUtils.isNotBlank((CharSequence)ip)) {
            CONFIG_MAP.put(parentDeviceId, ip);
        }
    }

    public static void removeIpByParentDeviceId(String parentDeviceId) {
        if (StringUtils.isNotBlank((CharSequence)parentDeviceId)) {
            CONFIG_MAP.remove(parentDeviceId);
        }
    }

    public static String getPort() {
        if (CONFIG_MAP.containsKey("httpPort")) {
            return CONFIG_MAP.get("httpPort").toString();
        }
        return "58097";
    }

    public static String getHttpSchema() {
        if (CONFIG_MAP.containsKey("httpSchema")) {
            return CONFIG_MAP.get("httpSchema").toString();
        }
        return "https";
    }

    public static String getTimeZone() {
        if (CONFIG_MAP.containsKey("timeZone")) {
            return CONFIG_MAP.get("timeZone").toString();
        }
        return "GMT";
    }

    public static void setReady(Boolean ready) {
        if (ready == null) {
            return;
        }
        CONFIG_MAP.put("ready", ready);
    }

    public static void setSearchMastDeviceFlag(boolean flag) {
        CONFIG_MAP.put("searchMastDeviceFlag", flag);
    }

    public static boolean getSearchMastDeviceFlag() {
        return Boolean.parseBoolean(((Object)CONFIG_MAP.getOrDefault("searchMastDeviceFlag", false)).toString());
    }

    public static boolean isDebugLog() {
        return Boolean.parseBoolean(CONFIG_MAP.get("debugLog").toString());
    }

    public static boolean isAccessLog() {
        return Boolean.parseBoolean(CONFIG_MAP.get("accessLog").toString());
    }

    public static boolean isReady() {
        return Boolean.parseBoolean(CONFIG_MAP.get("ready").toString());
    }

    public static boolean getNatEnabled() {
        if (CONFIG_MAP.containsKey("natEnabled")) {
            return Boolean.parseBoolean(CONFIG_MAP.get("natEnabled").toString());
        }
        return false;
    }

    public static boolean getSnapSwitch() {
        if (CONFIG_MAP.containsKey("snapSwitch")) {
            return Boolean.parseBoolean(CONFIG_MAP.get("snapSwitch").toString());
        }
        return false;
    }

    static {
        CONFIG_MAP.put("ip", "127.0.0.1");
        CONFIG_MAP.put("httpPort", "58097");
        CONFIG_MAP.put("httpSchema", "https");
        CONFIG_MAP.put("timeZone", "GMT+8:00");
        CONFIG_MAP.put("debugLog", false);
        CONFIG_MAP.put("accessLog", false);
        CONFIG_MAP.put("ready", true);
        CONFIG_MAP.put("searchMastDeviceFlag", false);
        CONFIG_MAP.put("snapSwitch", true);
    }
}

