/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.aspect;

import com.zkteco.zkbiosecurity.cuserver.dto.RestResult;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
@Order(value=-2147483648)
public class CustomerExceptionAdvice {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomerExceptionAdvice.class);

    @ExceptionHandler(value={InvokeException.class})
    public RestResult processUnauthenticatedException(NativeWebRequest request, InvokeException ie) {
        return RestResult.error((String)ie.getCode(), (String)ie.getMessage(), (Object)ie.getMessage(), (Object)(Objects.nonNull(ie.getOriginalValue()) ? ie.getOriginalValue() : ""));
    }

    @ExceptionHandler(value={HttpMessageConversionException.class})
    public RestResult parameterTypeException(HttpMessageConversionException exception, HttpServletRequest request) {
        LOGGER.error("process param type error", (Throwable)exception);
        return RestResult.error((String)"500", (String)"cu_param_convert_error", (Object)"cu_param_convert_error");
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public RestResult validationBodyException(MethodArgumentNotValidException exception) {
        LOGGER.error("process param deal error", (Throwable)exception);
        return RestResult.error((String)"500", (String)"param_error", (Object)"param_error");
    }

    @ExceptionHandler(value={RuntimeException.class})
    public RestResult processRuntimeException(NativeWebRequest request, Exception e) {
        LOGGER.error("process unknown exception error", (Throwable)e);
        return RestResult.error((String)"500", (String)"unknown_error", (Object)"unknown_error");
    }

    @ExceptionHandler(value={Exception.class})
    public RestResult processException(HttpServletRequest req, Exception e) {
        if (e instanceof NoHandlerFoundException) {
            return RestResult.error((String)"500", (String)"cu_path_not_found", (Object)"cu_path_not_found");
        }
        LOGGER.error("process top exception error", (Throwable)e);
        return RestResult.error((String)"500", (String)"unknown_error", (Object)"unknown_error");
    }

    private String getContentStream(HttpServletRequest request) {
        String param = "";
        if (Objects.isNull(request)) {
            return param;
        }
        StringBuilder responseStrBuilder = new StringBuilder();
        try {
            String inputStr;
            BufferedReader streamReader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), StandardCharsets.UTF_8));
            while ((inputStr = streamReader.readLine()) != null) {
                responseStrBuilder.append(inputStr);
            }
            param = responseStrBuilder.toString();
        }
        catch (Exception e) {
            LOGGER.error("get content stream error,URI:" + request.getRequestURI() + ",content:" + responseStrBuilder.toString(), (Throwable)e);
        }
        return param;
    }
}

