/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v2;

import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.PresetPositionRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.PresetPositionRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.v2.PresetPositionV2Service;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9884\u7f6e\u4f4d"})
@RestController
@RequestMapping(value={"/rest/ics/v2/zk/presetPosition"})
public class PresetPositionV2Controller
implements BaseController<PresetPositionV2Service<?>> {
    @Autowired
    private PresetPositionV2Service<IServerType.IVS1800> presetPositionIvs1800V2Service;
    @Autowired
    private PresetPositionV2Service<IServerType.NVR800> presetPositionNvr800V2Service;
    @Autowired
    private PresetPositionV2Service<IServerType.ZKNVR> presetPositionZkNvrV2Service;
    @Autowired
    private PresetPositionV2Service<IServerType.Onvif> onvifPresetPositionV2Service;

    @ApiOperation(value="\u6dfb\u52a0\u9884\u7f6e\u4f4d")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ContentResponse<String, PresetPositionRespond> add(@RequestBody ParamBean<PresetPositionRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        PresetPositionRequest req = (PresetPositionRequest)obj.getRequestBody();
        PresetPositionRespond result = ((PresetPositionV2Service)this.getServer(vcmInfo)).add(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u5220\u9664\u9884\u7f6e\u4f4d")
    @RequestMapping(value={"/del"}, method={RequestMethod.POST})
    public ContentResponse<String, PresetPositionRespond> del(@RequestBody ParamBean<PresetPositionRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        PresetPositionRequest req = (PresetPositionRequest)obj.getRequestBody();
        PresetPositionRespond result = ((PresetPositionV2Service)this.getServer(vcmInfo)).del(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u4fee\u6539\u9884\u7f6e\u4f4d")
    @RequestMapping(value={"/upt"}, method={RequestMethod.POST})
    public ContentResponse<String, PresetPositionRespond> upt(@RequestBody ParamBean<PresetPositionRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        PresetPositionRequest req = (PresetPositionRequest)obj.getRequestBody();
        PresetPositionRespond result = ((PresetPositionV2Service)this.getServer(vcmInfo)).upt(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u9884\u7f6e\u4f4d\u5217\u8868")
    @RequestMapping(value={"/list"}, method={RequestMethod.POST})
    public ContentResponse<String, Map<String, List<PresetPositionRespond>>> list(@RequestBody ParamBean<PresetPositionRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        PresetPositionRequest req = (PresetPositionRequest)obj.getRequestBody();
        List list = ((PresetPositionV2Service)this.getServer(vcmInfo)).list(vcmInfo, req);
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("ptzPresetInfoList", list);
        return ResultHelper.success(map);
    }

    public PresetPositionV2Service<?> getIvs3800Server() {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public PresetPositionV2Service<?> getIvs1800Server() {
        return this.presetPositionIvs1800V2Service;
    }

    public PresetPositionV2Service<?> getNvr800Server() {
        return this.presetPositionNvr800V2Service;
    }

    public PresetPositionV2Service<?> getZKNVRServer() {
        return this.presetPositionZkNvrV2Service;
    }

    public PresetPositionV2Service<?> getOnvifServer() {
        return this.onvifPresetPositionV2Service;
    }
}

