/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v2;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.api.v1.FaceRepositoryController;
import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.picturesearch.FaceSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.v2.request.cu.picturesearch.FaceSearchV2Request;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.v2.PictureSearchV2Service;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u68c0\u7d22-\u76ee\u6807\u68c0\u7d22"})
@RestController
@RequestMapping(value={"/rest/ics/v2/zk/picture"})
public class PictureSearchV2Controller
implements BaseController<PictureSearchV2Service<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FaceRepositoryController.class);
    @Autowired
    private PictureSearchV2Service<IServerType.NVR800> pictureSearchV2Nvr800Service;
    @Autowired
    private PictureSearchV2Service<IServerType.IVS1800> pictureSearchV2Ivs1800Service;

    @ApiOperation(value="\u76ee\u6807\u68c0\u7d22")
    @RequestMapping(value={"/faceSearch"}, method={RequestMethod.POST})
    public ContentResponse<String, FaceSearchRespond> faceSearch(@RequestBody ParamBean<FaceSearchV2Request> obj) {
        if (!CollectionUtils.isEmpty((Collection)obj.getVcmInfos())) {
            ArrayList<CompletableFuture<List>> futureList = new ArrayList<CompletableFuture<List>>();
            FaceSearchRespond respond = new FaceSearchRespond();
            FaceSearchV2Request request = (FaceSearchV2Request)obj.getRequestBody();
            JSONArray exArray = new JSONArray();
            for (VcmReqBaseInfo vcmInfo : obj.getVcmInfos()) {
                CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> {
                    try {
                        ParamBean paramBean = new ParamBean();
                        FaceSearchV2Request faceSearchV2Request = new FaceSearchV2Request();
                        BeanUtils.copyProperties((Object)request, (Object)faceSearchV2Request);
                        faceSearchV2Request.setCameraList(request.getChannelCode().getJSONArray(vcmInfo.getDomainCode()).toJavaList(String.class));
                        paramBean.setVcmInfo(vcmInfo);
                        paramBean.setRequestBody((Object)faceSearchV2Request);
                        FaceSearchRespond config = ((PictureSearchV2Service)this.getServer(vcmInfo)).faceSearch(paramBean);
                        return config.getPeoplefaces();
                    }
                    catch (Exception e) {
                        LOGGER.error("CompletableFuture face search error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
                        JSONObject exObject = new JSONObject();
                        exObject.put("domainCode", (Object)vcmInfo.getDomainCode());
                        exObject.put("resultCode", (Object)e.getMessage());
                        exArray.add((Object)exObject);
                        return new ArrayList();
                    }
                });
                futureList.add(future);
            }
            respond.setExceptionInfo(exArray);
            ArrayList faceList = new ArrayList();
            CompletionStage allFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).whenComplete((v, t) -> futureList.forEach(temp -> {
                PictureSearchV2Controller pictureSearchV2Controller = this;
                synchronized (pictureSearchV2Controller) {
                    faceList.addAll(temp.getNow(null));
                }
            }));
            try {
                ((CompletableFuture)allFuture).get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("face complex CompletableFuture get error", (Throwable)e);
            }
            List resultList = faceList.stream().sorted((o1, o2) -> {
                LocalDateTime time2;
                LocalDateTime time1 = LocalDateTime.ofEpochSecond(Long.parseLong(o1.getRecordTime()), 0, OffsetDateTime.now().getOffset());
                if (time1.isAfter(time2 = LocalDateTime.ofEpochSecond(Long.parseLong(o2.getRecordTime()), 0, OffsetDateTime.now().getOffset()))) {
                    return -1;
                }
                if (time1.isBefore(time2)) {
                    return 1;
                }
                return 0;
            }).collect(Collectors.toList());
            LOGGER.info("face complex result size:" + resultList.size());
            if (resultList.size() > ((FaceSearchV2Request)obj.getRequestBody()).getSearchCount()) {
                respond.setPeoplefaces(resultList.subList(0, ((FaceSearchV2Request)obj.getRequestBody()).getSearchCount()));
            } else {
                respond.setPeoplefaces(resultList);
            }
            respond.setTotal(Integer.valueOf(respond.getPeoplefaces().size()));
            respond.setCount(respond.getPeoplefaces().size());
            return ResultHelper.success((Object)respond);
        }
        FaceSearchRespond config = ((PictureSearchV2Service)this.getServer(obj.getVcmInfo())).faceSearch(obj);
        return ResultHelper.success((Object)config);
    }

    @ApiOperation(value="\u4ee5\u56fe\u641c\u56fe")
    @RequestMapping(value={"/faceSearchByImage"}, method={RequestMethod.POST})
    public ContentResponse<String, FaceSearchRespond> faceSearchByImage(@RequestBody ParamBean<FaceSearchV2Request> obj) {
        if (!CollectionUtils.isEmpty((Collection)obj.getVcmInfos())) {
            ArrayList<CompletableFuture<List>> futureList = new ArrayList<CompletableFuture<List>>();
            FaceSearchRespond respond = new FaceSearchRespond();
            JSONArray exArray = new JSONArray();
            for (VcmReqBaseInfo vcmInfo : obj.getVcmInfos()) {
                CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> {
                    try {
                        ParamBean paramBean = new ParamBean();
                        FaceSearchV2Request faceSearchV2Request = new FaceSearchV2Request();
                        BeanUtils.copyProperties((Object)obj.getRequestBody(), (Object)faceSearchV2Request);
                        faceSearchV2Request.setCameraList(faceSearchV2Request.getChannelCode().getJSONArray(vcmInfo.getDomainCode()).toJavaList(String.class));
                        paramBean.setVcmInfo(vcmInfo);
                        paramBean.setRequestBody((Object)faceSearchV2Request);
                        FaceSearchRespond config = ((PictureSearchV2Service)this.getServer(vcmInfo)).faceSearchByImage(paramBean);
                        return config.getPeoplefaces();
                    }
                    catch (Exception e) {
                        LOGGER.error("face search by image device error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
                        JSONObject exObject = new JSONObject();
                        exObject.put("domainCode", (Object)vcmInfo.getDomainCode());
                        exObject.put("resultCode", (Object)e.getMessage());
                        exArray.add((Object)exObject);
                        return new ArrayList();
                    }
                });
                futureList.add(future);
            }
            respond.setExceptionInfo(exArray);
            ArrayList faceList = new ArrayList();
            CompletionStage allFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[futureList.size()])).whenComplete((v, t) -> futureList.forEach(temp -> {
                PictureSearchV2Controller pictureSearchV2Controller = this;
                synchronized (pictureSearchV2Controller) {
                    faceList.addAll(temp.getNow(null));
                }
            }));
            try {
                ((CompletableFuture)allFuture).get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("face by image complex CompletableFuture get error", (Throwable)e);
            }
            List resultList = faceList.stream().sorted((o1, o2) -> {
                LocalDateTime time2;
                LocalDateTime time1 = LocalDateTime.ofEpochSecond(Long.parseLong(o1.getRecordTime()), 0, OffsetDateTime.now().getOffset());
                if (time1.isAfter(time2 = LocalDateTime.ofEpochSecond(Long.parseLong(o2.getRecordTime()), 0, OffsetDateTime.now().getOffset()))) {
                    return -1;
                }
                if (time1.isBefore(time2)) {
                    return 1;
                }
                return 0;
            }).collect(Collectors.toList());
            LOGGER.info("face by image result size:" + resultList.size());
            if (resultList.size() > ((FaceSearchV2Request)obj.getRequestBody()).getSearchCount()) {
                respond.setPeoplefaces(resultList.subList(0, ((FaceSearchV2Request)obj.getRequestBody()).getSearchCount()));
            } else {
                respond.setPeoplefaces(resultList);
            }
            respond.setTotal(Integer.valueOf(respond.getPeoplefaces().size()));
            respond.setCount(respond.getPeoplefaces().size());
            return ResultHelper.success((Object)respond);
        }
        FaceSearchRespond config = ((PictureSearchV2Service)this.getServer(obj.getVcmInfo())).faceSearchByImage(obj);
        return ResultHelper.success((Object)config);
    }

    public PictureSearchV2Service<IServerType.NVR800> getIvs3800Server() {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public PictureSearchV2Service<IServerType.IVS1800> getIvs1800Server() {
        return this.pictureSearchV2Ivs1800Service;
    }

    public PictureSearchV2Service<IServerType.NVR800> getNvr800Server() {
        return this.pictureSearchV2Nvr800Service;
    }
}

