/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v2;

import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.GuardPointSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.PTZControlRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.GuardPointRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.PTZControlRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.v2.PTZV2Service;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e91\u53f0\u63a7\u5236"})
@RestController
@RequestMapping(value={"/rest/ics/v2/zk/ptz"})
public class PTZV2Controller
implements BaseController<PTZV2Service<?>> {
    @Autowired
    private PTZV2Service<IServerType.IVS1800> ptzIvs1800V2Service;
    @Autowired
    private PTZV2Service<IServerType.NVR800> ptzNvr800V2Service;
    @Autowired
    private PTZV2Service<IServerType.ZKNVR> ptzZKNvrV2ServiceImpl;
    @Autowired
    private PTZV2Service<IServerType.Cloud> ptzCloudService;
    @Autowired
    private PTZV2Service<IServerType.Onvif> onvifPTZV2Service;

    @ApiOperation(value="\u4e91\u53f0\u63a7\u5236\u64cd\u4f5c")
    @RequestMapping(value={"/control"}, method={RequestMethod.POST})
    public ContentResponse<String, PTZControlRespond> control(@RequestBody ParamBean<PTZControlRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        PTZControlRequest req = (PTZControlRequest)obj.getRequestBody();
        PTZControlRespond result = ((PTZV2Service)this.getServer(vcmInfo)).control(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u770b\u5b88\u4f4d")
    @RequestMapping(value={"/guardPoint/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setGuardPoint(@RequestBody ParamBean<GuardPointSetRequest> obj) {
        Boolean result = ((PTZV2Service)this.getServer(obj.getVcmInfo())).setGuardPoint(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u770b\u5b88\u4f4d")
    @RequestMapping(value={"/guardPoint/get"}, method={RequestMethod.POST})
    public ContentResponse<String, GuardPointRespond> getGuardPoint(@RequestBody ParamBean<ChannelRequest> obj) {
        GuardPointRespond result = ((PTZV2Service)this.getServer(obj.getVcmInfo())).getGuardPoint(obj);
        return ResultHelper.success((Object)result);
    }

    public PTZV2Service<IServerType.IVS3800> getIvs3800Server() {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public PTZV2Service<IServerType.IVS1800> getIvs1800Server() {
        return this.ptzIvs1800V2Service;
    }

    public PTZV2Service<IServerType.NVR800> getNvr800Server() {
        return this.ptzNvr800V2Service;
    }

    public PTZV2Service<IServerType.SDC> getSdcServer() {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public PTZV2Service<IServerType.ZKNVR> getZKNVRServer() {
        return this.ptzZKNvrV2ServiceImpl;
    }

    public PTZV2Service<IServerType.Cloud> getCloudServer() {
        return this.ptzCloudService;
    }

    public PTZV2Service<?> getOnvifServer() {
        return this.onvifPTZV2Service;
    }
}

