/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v2;

import com.zkteco.zkbiosecurity.cuserver.aspect.IcsCheck;
import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.FaceRepositoryRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepositoryRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepositorySearchRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.v2.FaceRepositoryManagementV2Service;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u4eba\u8138\u5e93\u7ba1\u7406"})
@Controller
@RequestMapping(value={"/rest/ics/v2/zk/faceRepository"})
public class FaceRepositoryV2Controller
implements BaseController<FaceRepositoryManagementV2Service<?>> {
    @Autowired
    private FaceRepositoryManagementV2Service<IServerType.IVS1800> faceRepositoryManagementIvs1800V2Service;
    @Autowired
    private FaceRepositoryManagementV2Service<IServerType.NVR800> faceRepositoryManagementNvr800V2Service;
    @Autowired
    private FaceRepositoryManagementV2Service<IServerType.SDC> faceRepositoryManagementV2ServiceSdc;

    @ApiOperation(value="\u65b0\u589e\u4eba\u8138\u5e93")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @ResponseBody
    public ContentResponse<String, FaceRepositoryRespond> addFaceRepository(@RequestBody ParamBean<FaceRepositoryRequest> obj) {
        FaceRepositoryRespond respond = ((FaceRepositoryManagementV2Service)this.getServer(obj.getVcmInfo())).add(obj.getVcmInfo(), (FaceRepositoryRequest)obj.getRequestBody());
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u5220\u9664\u4eba\u8138\u5e93")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public ContentResponse<String, FaceRepositoryRespond> deleteFaceRepository(@RequestBody ParamBean<FaceRepositoryRequest> obj) {
        return ResultHelper.success((Object)new FaceRepositoryRespond(obj.getVcmInfo().getVcmIp(), ((FaceRepositoryManagementV2Service)this.getServer(obj.getVcmInfo())).delete(obj.getVcmInfo(), (FaceRepositoryRequest)obj.getRequestBody())));
    }

    @ApiOperation(value="\u66f4\u65b0\u4eba\u8138\u5e93")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    @ResponseBody
    @IcsCheck
    public ContentResponse<String, FaceRepositoryRespond> updateFaceRepository(@RequestBody ParamBean<FaceRepositoryRequest> obj) {
        FaceRepositoryRespond respond = ((FaceRepositoryManagementV2Service)this.getServer(obj.getVcmInfo())).update(obj.getVcmInfo(), (FaceRepositoryRequest)obj.getRequestBody());
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u67e5\u8be2\u4eba\u8138\u5e93")
    @RequestMapping(value={"/search"}, method={RequestMethod.POST})
    @ResponseBody
    public ContentResponse<String, FaceRepositorySearchRespond> searchFaceRepository(@RequestBody ParamBean<FaceRepositoryRequest> obj) {
        return ResultHelper.success((Object)((FaceRepositoryManagementV2Service)this.getServer(obj.getVcmInfo())).search(obj.getVcmInfo(), (FaceRepositoryRequest)obj.getRequestBody()));
    }

    public FaceRepositoryManagementV2Service<?> getIvs3800Server() {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public FaceRepositoryManagementV2Service<?> getIvs1800Server() {
        return this.faceRepositoryManagementIvs1800V2Service;
    }

    public FaceRepositoryManagementV2Service<?> getNvr800Server() {
        return this.faceRepositoryManagementNvr800V2Service;
    }

    public FaceRepositoryManagementV2Service<?> getSdcServer(int implType) {
        return this.faceRepositoryManagementV2ServiceSdc;
    }
}

