/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v2;

import com.zkteco.zkbiosecurity.cuserver.config.ConfigHolder;
import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.MasterDeviceSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.v2.request.cu.device.CameraAddV2Request;
import com.zkteco.zkbiosecurity.cuserver.dto.v2.respond.cu.device.CameraAddV2Respond;
import com.zkteco.zkbiosecurity.cuserver.enums.DeviceTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SmartDaraHelpService;
import com.zkteco.zkbiosecurity.cuserver.service.v2.DeviceManageV2Service;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8bbe\u5907\u7ba1\u7406V2"})
@RestController
@RequestMapping(value={"/rest/ics/v2/zk/device"})
public class DeviceV2Controller
implements BaseController<DeviceManageV2Service<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceV2Controller.class);
    @Autowired
    private DeviceManageV2Service<IServerType.IVS1800> deviceManageIvs1800Service;
    @Autowired
    private DeviceManageV2Service<IServerType.NVR800> deviceManageNvr800Service;
    @Autowired
    private DeviceManageV2Service<IServerType.ZKNVR> deviceManageZkNvrV2Service;
    @Autowired
    private DeviceManageV2Service<IServerType.Tiandy> deviceManageTIANDYV2Service;
    @Autowired
    private DeviceManageV2Service<IServerType.HIKVISION> deviceManageHIKVISONV2Service;
    @Autowired
    private DeviceManageV2Service<IServerType.Onvif> onvifDeviceManageV2Service;
    @Autowired
    private SmartDaraHelpService smartDaraHelpService;

    @ApiOperation(value="\u6279\u91cf\u6dfb\u52a0\u6444\u50cf\u673a")
    @RequestMapping(value={"/cameras/add"}, method={RequestMethod.POST})
    public ContentResponse<String, CameraAddV2Respond> addCamera(@RequestBody ParamBean<CameraAddV2Request> obj) {
        CameraAddV2Respond cameraAddRespond = ((DeviceManageV2Service)this.getServer(obj.getVcmInfo())).addCamera(obj);
        return ResultHelper.success((Object)cameraAddRespond);
    }

    @ApiOperation(value="\u641c\u7d22\u4e3b\u8bbe\u5907")
    @PostMapping(value={"/device/searchMasterDevice"})
    public ContentResponse<String, Boolean> searchMasterDevice(@RequestBody ParamBean<MasterDeviceSearchRequest> obj) {
        if (ConfigHolder.getSearchMastDeviceFlag()) {
            return ResultHelper.success((Object)true);
        }
        CompletableFuture.runAsync(() -> {
            ConfigHolder.setSearchMastDeviceFlag((boolean)true);
            try {
                if (!CollectionUtils.isEmpty((Collection)((MasterDeviceSearchRequest)obj.getRequestBody()).getSearchType()) && ((MasterDeviceSearchRequest)obj.getRequestBody()).getSearchType().contains(DeviceTypeEnum.NVR800.val())) {
                    this.deviceManageNvr800Service.searchMasterDevice((MasterDeviceSearchRequest)obj.getRequestBody());
                }
                this.smartDaraHelpService.searchParentDeviceByMultiCast();
            }
            catch (Exception e) {
                LOGGER.error("search master device error", (Throwable)e);
            }
            finally {
                ConfigHolder.setSearchMastDeviceFlag((boolean)false);
            }
        });
        return ResultHelper.success((Object)true);
    }

    @ApiOperation(value="\u6fc0\u6d3b\u4e3b\u8bbe\u5907")
    @PostMapping(value={"/device/activateParentDevice"})
    public ContentResponse<String, Boolean> updateParentDeviceIp(@RequestBody ParamBean<MasterDeviceSearchRequest> obj) {
        Boolean result = this.smartDaraHelpService.activateParentDevice((MasterDeviceSearchRequest)obj.getRequestBody());
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u4fee\u6539\u4e3b\u8bbe\u5907IP")
    @PostMapping(value={"/device/changeParentDeviceIp"})
    public ContentResponse<String, Boolean> changeParentDeviceIp(@RequestBody ParamBean<MasterDeviceSearchRequest> obj) {
        Boolean result = this.smartDaraHelpService.changeParentDeviceIp((MasterDeviceSearchRequest)obj.getRequestBody());
        return ResultHelper.success((Object)result);
    }

    public DeviceManageV2Service<IServerType.IVS3800> getIvs3800Server() {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public DeviceManageV2Service<IServerType.IVS1800> getIvs1800Server() {
        return this.deviceManageIvs1800Service;
    }

    public DeviceManageV2Service<IServerType.NVR800> getNvr800Server() {
        return this.deviceManageNvr800Service;
    }

    public DeviceManageV2Service<IServerType.ZKNVR> getZKNVRServer() {
        return this.deviceManageZkNvrV2Service;
    }

    public DeviceManageV2Service<IServerType.Tiandy> getTIANDYServer() {
        return this.deviceManageTIANDYV2Service;
    }

    public DeviceManageV2Service<IServerType.HIKVISION> getHIKVISIONServer() {
        return this.deviceManageHIKVISONV2Service;
    }
}

