/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v1;

import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RecordConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoBookMarkRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoBookMarkSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoLockInfoListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoLockInfoRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RecordConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RecordStatusRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoBookMarkRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoLockInfoListRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoLockInfoRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.VideoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5f55\u50cf"})
@RestController
@RequestMapping(value={"/rest/ics/v1/zk/video"})
public class VideoController
implements BaseController<VideoService<?>> {
    @Autowired
    private VideoService<IServerType.IVS1800> videoIvs1800Service;
    @Autowired
    private VideoService<IServerType.NVR800> videoNvr800Service;
    @Autowired
    private VideoService<IServerType.Cloud> videoCloudService;
    @Autowired
    private VideoService<IServerType.ZKNVR> videoZKNvrService;
    @Autowired
    private VideoService<IServerType.ZKIPC> videoZKIpcService;
    @Autowired
    private VideoService<IServerType.Tiandy> videoTIANDYService;
    @Autowired
    private VideoService<IServerType.HIKVISION> videoHIKVSIONService;
    @Autowired
    private VideoService<IServerType.DHNVR> videoDHNvrService;

    @ApiOperation(value="\u5f55\u50cf\u5217\u8868")
    @RequestMapping(value={"/list"}, method={RequestMethod.POST})
    public ContentResponse<String, VideoRespond> videoList(@RequestBody ParamBean<VideoListRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        VideoListRequest req = (VideoListRequest)obj.getRequestBody();
        VideoRespond result = ((VideoService)this.getServer(vcmInfo)).videoList(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u5f00\u59cb\u5f55\u50cf")
    @RequestMapping(value={"/start"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> videoStart(@RequestBody ParamBean<VideoRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        VideoRequest req = (VideoRequest)obj.getRequestBody();
        Boolean result = ((VideoService)this.getServer(vcmInfo)).videoStart(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u505c\u6b62\u5f55\u50cf")
    @RequestMapping(value={"/stop"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> videoStop(@RequestBody ParamBean<VideoRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        VideoRequest req = (VideoRequest)obj.getRequestBody();
        Boolean result = ((VideoService)this.getServer(vcmInfo)).videoStop(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f55\u50cf\u6807\u7b7e")
    @RequestMapping(value={"/getVideoBookmark"}, method={RequestMethod.POST})
    public ContentResponse<String, List<VideoBookMarkRespond>> getVideoTag(@RequestBody ParamBean<VideoBookMarkSearchRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        VideoBookMarkSearchRequest req = (VideoBookMarkSearchRequest)obj.getRequestBody();
        List result = ((VideoService)this.getServer(vcmInfo)).getVideoBookmark(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u65b0\u589e\u5f55\u50cf\u6807\u7b7e")
    @RequestMapping(value={"/createVideoBookmark"}, method={RequestMethod.POST})
    public ContentResponse<String, Map<String, Long>> createVideoBookmark(@RequestBody ParamBean<VideoBookMarkRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        VideoBookMarkRequest req = (VideoBookMarkRequest)obj.getRequestBody();
        String result = ((VideoService)this.getServer(vcmInfo)).createVideoBookmark(vcmInfo, req);
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        if (result.contains("#")) {
            String[] array = result.split("#");
            resultMap.put("id", Long.parseLong(array[0]));
            resultMap.put("labelId", Long.parseLong(array[1]));
        } else {
            resultMap.put("id", Long.valueOf(result));
        }
        return ResultHelper.success(resultMap);
    }

    @ApiOperation(value="\u4fee\u6539\u5f55\u50cf\u6807\u7b7e")
    @RequestMapping(value={"/uptVideoBookmark"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> uptVideoBookmark(@RequestBody ParamBean<VideoBookMarkRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        VideoBookMarkRequest req = (VideoBookMarkRequest)obj.getRequestBody();
        boolean result = ((VideoService)this.getServer(vcmInfo)).uptVideoBookmark(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u5220\u9664\u5f55\u50cf\u6807\u7b7e")
    @RequestMapping(value={"/delVideoBookmark"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> delVideoBookmark(@RequestBody ParamBean<VideoBookMarkRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        VideoBookMarkRequest req = (VideoBookMarkRequest)obj.getRequestBody();
        boolean result = ((VideoService)this.getServer(vcmInfo)).delVideoBookmark(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f55\u50cf\u9501\u5b9a\u4fe1\u606f")
    @RequestMapping(value={"/getVideoLockInfo"}, method={RequestMethod.POST})
    public ContentResponse<String, VideoLockInfoListRespond> getVideoLockInfo(@RequestBody ParamBean<VideoLockInfoListRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        VideoLockInfoListRequest req = (VideoLockInfoListRequest)obj.getRequestBody();
        VideoLockInfoListRespond result = ((VideoService)this.getServer(vcmInfo)).getVideoLockInfo(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u65b0\u589e\u5f55\u50cf\u9501\u5b9a\u4fe1\u606f")
    @RequestMapping(value={"/createVideoLockInfo"}, method={RequestMethod.POST})
    public ContentResponse<String, VideoLockInfoRespond> createVideoLockInfo(@RequestBody ParamBean<VideoLockInfoRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        VideoLockInfoRequest req = (VideoLockInfoRequest)obj.getRequestBody();
        VideoLockInfoRespond result = ((VideoService)this.getServer(vcmInfo)).createVideoLockInfo(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u4fee\u6539\u5f55\u50cf\u9501\u5b9a\u4fe1\u606f")
    @RequestMapping(value={"/uptVideoLockInfo"}, method={RequestMethod.POST})
    public ContentResponse<String, VideoLockInfoRespond> uptVideoLockInfo(@RequestBody ParamBean<VideoLockInfoRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        VideoLockInfoRequest req = (VideoLockInfoRequest)obj.getRequestBody();
        VideoLockInfoRespond result = ((VideoService)this.getServer(vcmInfo)).uptVideoLockInfo(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f55\u50cf\u72b6\u6001")
    @RequestMapping(value={"/status"}, method={RequestMethod.POST})
    public ContentResponse<String, Map<String, List<RecordStatusRespond>>> getStatus(@RequestBody ParamBean<ChannelListRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        List result = ((VideoService)this.getServer(vcmInfo)).getRecordStatus(obj);
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("recordStatusList", result);
        return ResultHelper.success(map);
    }

    @ApiOperation(value="\u5220\u9664\u5f55\u50cf\u9501\u5b9a\u4fe1\u606f")
    @RequestMapping(value={"/delVideoLockInfo"}, method={RequestMethod.POST})
    public ContentResponse<String, VideoLockInfoRespond> delVideoLockInfo(@RequestBody ParamBean<VideoLockInfoRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        VideoLockInfoRequest req = (VideoLockInfoRequest)obj.getRequestBody();
        VideoLockInfoRespond result = ((VideoService)this.getServer(vcmInfo)).delVideoLockInfo(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f55\u50cf\u914d\u7f6e")
    @RequestMapping(value={"/config/get"}, method={RequestMethod.POST})
    public ContentResponse<String, RecordConfigRespond> getConfig(@RequestBody ParamBean<ChannelRequest> obj) {
        RecordConfigRespond result = ((VideoService)this.getServer(obj.getVcmInfo())).getConfig(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u5f55\u50cf\u914d\u7f6e")
    @RequestMapping(value={"/config/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setConfig(@RequestBody ParamBean<RecordConfigRequest> obj) {
        boolean result = ((VideoService)this.getServer(obj.getVcmInfo())).setConfig(obj);
        return ResultHelper.success((Object)result);
    }

    public VideoService<IServerType.IVS3800> getIvs3800Server() {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public VideoService<IServerType.IVS1800> getIvs1800Server() {
        return this.videoIvs1800Service;
    }

    public VideoService<IServerType.NVR800> getNvr800Server() {
        return this.videoNvr800Service;
    }

    public VideoService<IServerType.Cloud> getCloudServer() {
        return this.videoCloudService;
    }

    public VideoService<IServerType.ZKNVR> getZKNVRServer() {
        return this.videoZKNvrService;
    }

    public VideoService<IServerType.ZKIPC> getZKIPCServer() {
        return this.videoZKIpcService;
    }

    public VideoService<IServerType.DHNVR> getDHNVRServer() {
        return this.videoDHNvrService;
    }

    public VideoService<IServerType.Tiandy> getTIANDYServer() {
        return this.videoTIANDYService;
    }

    public VideoService<IServerType.HIKVISION> getHIKVISIONServer() {
        return this.videoHIKVSIONService;
    }
}

