/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v1;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.RestResult;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.vehicleRepository.VehicleRepositoryRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.vehicleRepository.VehicleRepositoryAddRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.vehicleRepository.VehicleRepositoryDelRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.vehicleRepository.VehicleRepositorySearchRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.VehicleRepositoryManagementService;
import io.swagger.annotations.Api;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u68c0\u7d22-\u8f66\u8f86\u68c0\u7d22"})
@RestController
@RequestMapping(value={"/rest/ics/v1/zk/vehicleList"})
public class VehicleListLibraryController
implements BaseController<VehicleRepositoryManagementService<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VehicleListLibraryController.class);
    @Autowired
    private VehicleRepositoryManagementService<IServerType.IVS1800> vehicleRepositoryManagementIVS1800Service;
    @Autowired
    private VehicleRepositoryManagementService<IServerType.NVR800> vehicleRepositoryManagementNVR800Service;

    @RequestMapping(value={"/search"}, method={RequestMethod.POST})
    public ContentResponse<String, VehicleRepositorySearchRespond> searchVehicleList(@RequestBody ParamBean<VehicleRepositoryRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        VehicleRepositoryRequest req = (VehicleRepositoryRequest)obj.getRequestBody();
        VehicleRepositorySearchRespond result = ((VehicleRepositoryManagementService)this.getServer(vcmInfo)).search(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ContentResponse<String, VehicleRepositoryAddRespond> addVehicleList(@RequestBody ParamBean<VehicleRepositoryRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        VehicleRepositoryRequest req = (VehicleRepositoryRequest)obj.getRequestBody();
        VehicleRepositoryAddRespond result = ((VehicleRepositoryManagementService)this.getServer(vcmInfo)).addVehicleListLibrary(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @RequestMapping(value={"/del"}, method={RequestMethod.POST})
    public ContentResponse<String, VehicleRepositoryDelRespond> delVehicleList(@RequestBody ParamBean<VehicleRepositoryRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        VehicleRepositoryRequest req = (VehicleRepositoryRequest)obj.getRequestBody();
        VehicleRepositoryDelRespond result = ((VehicleRepositoryManagementService)this.getServer(vcmInfo)).delVehicleListLibrary(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ContentResponse<String, RestResult> updateVehicleList(@RequestBody ParamBean<VehicleRepositoryRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        VehicleRepositoryRequest req = (VehicleRepositoryRequest)obj.getRequestBody();
        RestResult result = ((VehicleRepositoryManagementService)this.getServer(vcmInfo)).updateVehicleListLibrary(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @RequestMapping(value={"/addInfo"}, method={RequestMethod.POST})
    public ContentResponse<String, VehicleRepositoryAddRespond> addVehicleListInfo(@RequestBody ParamBean<VehicleRepositoryRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        VehicleRepositoryRequest req = (VehicleRepositoryRequest)obj.getRequestBody();
        VehicleRepositoryAddRespond result = ((VehicleRepositoryManagementService)this.getServer(vcmInfo)).addVehicleInformation(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @RequestMapping(value={"/delInfo"}, method={RequestMethod.POST})
    public ContentResponse<String, VehicleRepositoryDelRespond> delVehicleListInfo(@RequestBody ParamBean<VehicleRepositoryRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        VehicleRepositoryRequest req = (VehicleRepositoryRequest)obj.getRequestBody();
        VehicleRepositoryDelRespond result = ((VehicleRepositoryManagementService)this.getServer(vcmInfo)).delVehicleInformation(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @RequestMapping(value={"/updateInfo"}, method={RequestMethod.POST})
    public ContentResponse<String, JSONObject> updateVehicleListInfo(@RequestBody ParamBean<VehicleRepositoryRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        VehicleRepositoryRequest req = (VehicleRepositoryRequest)obj.getRequestBody();
        JSONObject result = ((VehicleRepositoryManagementService)this.getServer(vcmInfo)).updateVehicleInformation(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @RequestMapping(value={"/searchInfo"}, method={RequestMethod.POST})
    public ContentResponse<String, VehicleRepositorySearchRespond> searchVehicleListInfo(@RequestBody ParamBean<VehicleRepositoryRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        VehicleRepositoryRequest req = (VehicleRepositoryRequest)obj.getRequestBody();
        VehicleRepositorySearchRespond result = ((VehicleRepositoryManagementService)this.getServer(vcmInfo)).searchVehicleInformation(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @RequestMapping(value={"/retrieval"}, method={RequestMethod.POST})
    public ContentResponse<String, VehicleRepositorySearchRespond> vehicleDynamicRetrieval(@RequestBody ParamBean<VehicleRepositoryRequest> obj) {
        if (!CollectionUtils.isEmpty((Collection)obj.getVcmInfos())) {
            VehicleRepositorySearchRespond respond = new VehicleRepositorySearchRespond();
            ArrayList<CompletableFuture<List>> futureList = new ArrayList<CompletableFuture<List>>();
            for (VcmReqBaseInfo vcmInfo : obj.getVcmInfos()) {
                CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> {
                    try {
                        ParamBean paramBean = new ParamBean();
                        paramBean.setVcmInfo(vcmInfo);
                        paramBean.setRequestBody(obj.getRequestBody());
                        ((VehicleRepositoryRequest)paramBean.getRequestBody()).getCondition().setCameraCode(((VehicleRepositoryRequest)obj.getRequestBody()).getCondition().getChannelCode().getString(vcmInfo.getDomainCode()));
                        VehicleRepositorySearchRespond result = ((VehicleRepositoryManagementService)this.getServer(vcmInfo)).vehicleDynamicRetrieval(vcmInfo, (VehicleRepositoryRequest)paramBean.getRequestBody());
                        return result.getVehicleList();
                    }
                    catch (Exception e) {
                        LOGGER.error("CompletableFuture vehicle search error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
                        return new ArrayList();
                    }
                });
                futureList.add(future);
            }
            ArrayList vehicleList = new ArrayList();
            CompletionStage allFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).whenComplete((v, t) -> futureList.forEach(temp -> {
                VehicleListLibraryController vehicleListLibraryController = this;
                synchronized (vehicleListLibraryController) {
                    vehicleList.addAll(temp.getNow(null));
                }
            }));
            try {
                ((CompletableFuture)allFuture).get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("vehicle complex CompletableFuture get error", (Throwable)e);
            }
            List resultList = vehicleList.stream().sorted((o1, o2) -> {
                LocalDateTime time2;
                LocalDateTime time1 = LocalDateTime.ofEpochSecond(Long.parseLong(o1.getImageTimestamp()), 0, OffsetDateTime.now().getOffset());
                if (time1.isAfter(time2 = LocalDateTime.ofEpochSecond(Long.parseLong(o2.getImageTimestamp()), 0, OffsetDateTime.now().getOffset()))) {
                    return -1;
                }
                if (time1.isBefore(time2)) {
                    return 1;
                }
                return 0;
            }).collect(Collectors.toList());
            LOGGER.info("vehicle complex result size:" + resultList.size());
            if (resultList.size() > ((VehicleRepositoryRequest)obj.getRequestBody()).getSearchCount()) {
                respond.setVehicleList(resultList.subList(0, ((VehicleRepositoryRequest)obj.getRequestBody()).getSearchCount()));
            } else {
                respond.setVehicleList(resultList);
            }
            respond.setTotal(String.valueOf(respond.getVehicleList().size()));
            return ResultHelper.success((Object)respond);
        }
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        VehicleRepositoryRequest req = (VehicleRepositoryRequest)obj.getRequestBody();
        VehicleRepositorySearchRespond result = ((VehicleRepositoryManagementService)this.getServer(vcmInfo)).vehicleDynamicRetrieval(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @RequestMapping(value={"/imgDownload"}, method={RequestMethod.POST})
    public ContentResponse<String, JSONObject> dynamicLibraryPictureDownload(@RequestBody ParamBean<VehicleRepositoryRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        VehicleRepositoryRequest req = (VehicleRepositoryRequest)obj.getRequestBody();
        JSONObject result = ((VehicleRepositoryManagementService)this.getServer(vcmInfo)).dynamicLibraryPictureDownload(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @RequestMapping(value={"/updatePlateList"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> batchChangePlateList(@RequestBody ParamBean<VehicleRepositoryRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        VehicleRepositoryRequest req = (VehicleRepositoryRequest)obj.getRequestBody();
        Boolean result = ((VehicleRepositoryManagementService)this.getServer(vcmInfo)).batchChangePlateList(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    public VehicleRepositoryManagementService<?> getIvs3800Server() {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public VehicleRepositoryManagementService<?> getIvs1800Server() {
        return this.vehicleRepositoryManagementIVS1800Service;
    }

    public VehicleRepositoryManagementService<?> getNvr800Server() {
        return this.vehicleRepositoryManagementNVR800Service;
    }
}

