/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v1;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cloud.RenewalTokenRequestCloud;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChangePasswordRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.LoginRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.UserInfoRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.UserTokenRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cloud.EntUserInfoRespondCloud;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cloud.OrgInfoRespondCloud;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.BaseRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.user.LoginRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.user.UserRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.UserManageService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SdcServiceType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Set;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7528\u6237\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/rest/ics/v1/zk/user"})
public class UserController
implements BaseController<UserManageService<?>> {
    @Autowired
    private UserManageService<IServerType.IVS1800> userManageIvs1800Service;
    @Autowired
    private UserManageService<IServerType.NVR800> userManageNvr800Service;
    @Autowired
    private UserManageService<IServerType.Cloud> userManageCloudService;
    @Autowired
    private UserManageService<IServerType.ZKNVR> userManageZKNvrService;
    @Autowired
    private Set<UserManageService<IServerType.SDC>> userManageServiceSdcSet;
    @Autowired
    private UserManageService<IServerType.Tiandy> userManageTIANDYService;
    @Autowired
    private UserManageService<IServerType.HIKVISION> userManageHIKVISIONService;
    @Autowired
    private UserManageService<IServerType.Onvif> userManageOnvifService;
    @Autowired
    private UserManageService<IServerType.ZKIPC> userManageZKIpcService;
    @Autowired
    private UserManageService<IServerType.DHNVR> userManageDHNvrService;

    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u521d\u6b21\u767b\u9646")
    @RequestMapping(value={"/first"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> firstLogin(@RequestBody ParamBean<EmptyRequest> obj) {
        Boolean result = ((UserManageService)this.getServer(obj.getVcmInfo())).firstLogin(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u767b\u5f55\u63a5\u53e3")
    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    public ContentResponse<String, LoginRespond> login(@RequestBody ParamBean<LoginRequest> obj) {
        LoginRespond loginRespond = ((UserManageService)this.getServer(obj.getVcmInfo())).login(obj);
        return ResultHelper.success((Object)loginRespond);
    }

    @ApiOperation(value="\u767b\u51fa")
    @RequestMapping(value={"/logout"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> logout(@RequestBody ParamBean<EmptyRequest> obj) {
        boolean result = ((UserManageService)this.getServer(obj.getVcmInfo())).logout(obj.getVcmInfo());
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u4fdd\u6d3b")
    @RequestMapping(value={"/keepAlive"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> keepAlive(@RequestBody ParamBean<EmptyRequest> obj) {
        boolean success = ((UserManageService)this.getServer(obj.getVcmInfo())).keepAlive(obj);
        return ResultHelper.success((Object)success);
    }

    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801")
    @RequestMapping(value={"/firstChange"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> firstChange(@RequestBody ParamBean<ChangePasswordRequest> obj) {
        boolean result = ((UserManageService)this.getServer(obj.getVcmInfo())).firstChange(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e91\u7ec4\u7ec7\u5217\u8868")
    @RequestMapping(value={"/cloudOrgList"}, method={RequestMethod.POST})
    public ContentResponse<String, List<OrgInfoRespondCloud>> getCloudOrgList(@RequestBody ParamBean<EmptyRequest> obj) {
        List resultList = ((UserManageService)this.getServer(obj.getVcmInfo())).getCloudOrgList(obj.getVcmInfo());
        return ResultHelper.success((Object)resultList);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e91\u670d\u52a1\u767b\u5f55\u8d26\u53f7\u4fe1\u606f")
    @RequestMapping(value={"/getCloudUserInfo"}, method={RequestMethod.POST})
    public ContentResponse<String, JSONObject> getCloudUserInfo(@RequestBody ParamBean<EmptyRequest> obj) {
        JSONObject newToken = ((UserManageService)this.getServer(obj.getVcmInfo())).getCloudUserInfo(obj);
        return ResultHelper.success((Object)newToken);
    }

    @ApiOperation(value="\u4ee4\u724c\u7eed\u7ea6")
    @RequestMapping(value={"/renewalToken"}, method={RequestMethod.POST})
    public ContentResponse<String, String> renewalToken(@RequestBody ParamBean<RenewalTokenRequestCloud> obj) {
        String newToken = ((UserManageService)this.getServer(obj.getVcmInfo())).renewalToken(obj);
        return ResultHelper.success((Object)newToken);
    }

    @ApiOperation(value="\u83b7\u53d6\u767b\u9646token")
    @RequestMapping(value={"/getToken"}, method={RequestMethod.POST})
    public ContentResponse<String, UserRespond> getToken(@RequestBody ParamBean<UserTokenRequest> obj) {
        UserRespond respond = ((UserManageService)this.getServer(obj.getVcmInfo())).getToken(obj);
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"/getUserInfo"}, method={RequestMethod.POST})
    public ContentResponse<String, UserRespond> getUserInfo(@RequestBody ParamBean<UserInfoRequest> obj) {
        UserRespond respond = ((UserManageService)this.getServer(obj.getVcmInfo())).getUserInfo(obj.getVcmInfo(), (UserInfoRequest)obj.getRequestBody());
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u534e\u4e3a\u4e91\u767b\u9646")
    @PostMapping(value={"/loginCloud"})
    public ContentResponse<String, LoginRespond> loginCloud(@RequestBody ParamBean<LoginRequest> obj) {
        LoginRespond respond = ((UserManageService)this.getServer(obj.getVcmInfo())).loginCloud(obj.getVcmInfo(), (LoginRequest)obj.getRequestBody());
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u4e91\u670d\u52a1\u4e2a\u4eba\u7248\u4f01\u4e1a\u7248\u672c\u7edf\u4e00\u767b\u5f55")
    @RequestMapping(value={"/cloudLogin"}, method={RequestMethod.POST})
    public ContentResponse<String, LoginRespond> cloudLogin(@RequestBody ParamBean<LoginRequest> obj) {
        LoginRespond loginRespond = ((UserManageService)this.getServer(obj.getVcmInfo())).cloudLogin(obj);
        return ResultHelper.success((Object)loginRespond);
    }

    @ApiOperation(value="\u4e91\u670d\u52a1\u63a5\u53e3 \u4f01\u4e1a\u7248\u4e2a\u4eba\u7248\u6574\u5408 \u83b7\u53d6\u4e2a\u4eba\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"/getEntCloudUserInfo"}, method={RequestMethod.POST})
    public ContentResponse<String, EntUserInfoRespondCloud> getEntCloudUserInfo(@RequestBody ParamBean<EmptyRequest> obj) {
        EntUserInfoRespondCloud cloudDevice = ((UserManageService)this.getServer(obj.getVcmInfo())).getEntCloudUserInfo(obj);
        return ResultHelper.success((Object)cloudDevice);
    }

    @ApiOperation(value="\u4e91\u670d\u52a1\u63a5\u53e3 \u4f01\u4e1a\u7248\u4e2a\u4eba\u7248\u6574\u5408 \u7528\u6237\u767b\u51fa")
    @RequestMapping(value={"/cloudLogout"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> cloudLogout(@RequestBody ParamBean<EmptyRequest> obj) {
        boolean result = ((UserManageService)this.getServer(obj.getVcmInfo())).cloudLogout(obj.getVcmInfo());
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u901a\u8fc7\u8d26\u53f7\u5bc6\u7801\u83b7\u53d6OMU_PORTRAL \u4e3b\u8bbe\u5907\u767b\u9646token")
    @RequestMapping(value={"/getTokenByPwd"}, method={RequestMethod.POST})
    public ContentResponse<String, UserRespond> getTokenByPwd(@RequestBody ParamBean<UserTokenRequest> obj) {
        UserRespond respond = ((UserManageService)this.getServer(obj.getVcmInfo())).getTokenByPwd(obj);
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u83b7\u53d6\u514d\u5bc6\u767b\u9646Web\u9875\u9762\u7684\u4e00\u6b21\u6027\u7968\u636e,\u914d\u5957\u5de5\u5177Restful\u63a5\u53e3\u767b\u9646\u540e\uff0c\u901a\u8fc7\u6b64\u63a5\u53e3\u83b7\u53d6\u514d\u5bc6\u767b\u9646Web\u7968\u636e\uff0c\u5b9e\u73b0\u8df3\u8f6c\u767b\u9646")
    @RequestMapping(value={"/getSDCWebToken"}, method={RequestMethod.POST})
    public ContentResponse<String, UserRespond> getSDCWebToken(@RequestBody ParamBean<ChannelRequest> obj) {
        UserRespond respond = ((UserManageService)this.getServer(obj.getVcmInfo())).getSDCWebToken(obj);
        return ResultHelper.success((Object)respond);
    }

    @PostMapping(value={"/getCloudTicket"})
    public ContentResponse<String, UserRespond> getCloudTicket(@RequestBody ParamBean<EmptyRequest> obj) {
        return ResultHelper.success((Object)((UserManageService)this.getServer(obj.getVcmInfo())).getCloudTicket(obj.getVcmInfo()));
    }

    @PostMapping(value={"/getTokenByTicket"})
    public ContentResponse<String, UserRespond> getTokenByTicket(@RequestBody ParamBean<UserTokenRequest> obj) {
        return ResultHelper.success((Object)((UserManageService)this.getServer(obj.getVcmInfo())).getTokenByTicket(obj.getVcmInfo(), (UserTokenRequest)obj.getRequestBody()));
    }

    @PostMapping(value={"/checkToken"})
    public BaseRespond checkToken(@RequestBody ParamBean<EmptyRequest> obj) {
        return ((UserManageService)this.getServer(obj.getVcmInfo())).checkToken(obj.getVcmInfo());
    }

    public UserManageService<IServerType.IVS3800> getIvs3800Server() {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public UserManageService<IServerType.IVS1800> getIvs1800Server() {
        return this.userManageIvs1800Service;
    }

    public UserManageService<IServerType.NVR800> getNvr800Server() {
        return this.userManageNvr800Service;
    }

    public UserManageService<IServerType.Cloud> getCloudServer() {
        return this.userManageCloudService;
    }

    public UserManageService<IServerType.ZKNVR> getZKNVRServer() {
        return this.userManageZKNvrService;
    }

    public UserManageService<IServerType.Tiandy> getTIANDYServer() {
        return this.userManageTIANDYService;
    }

    public UserManageService<IServerType.HIKVISION> getHIKVISIONServer() {
        return this.userManageHIKVISIONService;
    }

    public UserManageService<IServerType.DHNVR> getDHNVRServer() {
        return this.userManageDHNvrService;
    }

    public UserManageService<?> getSdcServer(int implType) {
        for (UserManageService userManageService : this.userManageServiceSdcSet) {
            SdcServiceType sdkType = AopUtils.getTargetClass((Object)userManageService).getAnnotation(SdcServiceType.class);
            if (sdkType == null || sdkType.value() != implType) continue;
            return userManageService;
        }
        return null;
    }

    public UserManageService<?> getOnvifServer() {
        return this.userManageOnvifService;
    }

    public UserManageService<?> getZKIPCServer() {
        return this.userManageZKIpcService;
    }
}

