/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v1;

import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.upgrade.CheckRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.upgrade.UpgradeRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.PageRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.upgrade.CheckRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.upgrade.UpgradeRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.UpgradeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5347\u7ea7\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/rest/ics/v1/zk/upgrade"})
public class UpgradeController
implements BaseController<UpgradeService<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeController.class);
    @Autowired
    private UpgradeService<IServerType.NVR800> upgradeNvr800Service;
    @Autowired
    private UpgradeService<IServerType.IVS1800> upgradeIvs1800Service;

    @ApiOperation(value="\u83b7\u53d6\u5347\u7ea7token")
    @PostMapping(value={"/getUpgradeToken"})
    public CheckRespond getUpgradeToken(@RequestBody ParamBean<CheckRequest> obj) {
        return ((UpgradeService)this.getServer(obj.getVcmInfo())).getUpgradeToken(obj.getVcmInfo(), (CheckRequest)obj.getRequestBody());
    }

    @ApiOperation(value="\u5347\u7ea7NVR800")
    @PostMapping(value={"/upgradeNvr800"})
    public ContentResponse<String, UpgradeRespond> upgradeNvr800(@RequestBody ParamBean<UpgradeRequest> obj) {
        UpgradeRespond respond = ((UpgradeService)this.getServer(obj.getVcmInfo())).upgradeNvr800(obj.getVcmInfo(), (UpgradeRequest)obj.getRequestBody());
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u4e0a\u4f20\u5347\u7ea7\u5305\uff0cIVS1800\u4e13\u7528")
    @PostMapping(value={"/uploadPackage"})
    public UpgradeRespond uploadPackage(@RequestBody ParamBean<UpgradeRequest> obj) {
        return ((UpgradeService)this.getServer(obj.getVcmInfo())).uploadPackage(obj.getVcmInfo(), (UpgradeRequest)obj.getRequestBody());
    }

    @ApiOperation(value="\u57fa\u7840\u6821\u9a8c\uff0cIVS1800\u4e13\u7528")
    @PostMapping(value={"/baseCheck"})
    public ContentResponse<String, UpgradeRespond> baseCheck(@RequestBody ParamBean<UpgradeRequest> obj) {
        UpgradeRespond respond = ((UpgradeService)this.getServer(obj.getVcmInfo())).baseCheck(obj.getVcmInfo(), (UpgradeRequest)obj.getRequestBody());
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u57fa\u7840\u6821\u9a8c\uff0cIVS1800\u4e13\u7528")
    @PostMapping(value={"/signCheck"})
    public ContentResponse<String, UpgradeRespond> signCheck(@RequestBody ParamBean<UpgradeRequest> obj) {
        UpgradeRespond respond = ((UpgradeService)this.getServer(obj.getVcmInfo())).signCheck(obj.getVcmInfo(), (UpgradeRequest)obj.getRequestBody());
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u57fa\u7840\u6821\u9a8c\uff0cIVS1800\u4e13\u7528")
    @PostMapping(value={"/sendCheck"})
    public ContentResponse<String, UpgradeRespond> sendCheck(@RequestBody ParamBean<UpgradeRequest> obj) {
        UpgradeRespond respond = ((UpgradeService)this.getServer(obj.getVcmInfo())).sendCheck(obj.getVcmInfo(), (UpgradeRequest)obj.getRequestBody());
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u83b7\u53d6\u5347\u7ea7\u68c0\u6d4b\u7ed3\u679c\uff0cIVS1800\u4e13\u7528")
    @PostMapping(value={"/getCheckResult"})
    public UpgradeRespond getCheckResult(@RequestBody ParamBean<UpgradeRequest> obj) {
        return ((UpgradeService)this.getServer(obj.getVcmInfo())).getCheckResult(obj.getVcmInfo(), (UpgradeRequest)obj.getRequestBody());
    }

    @ApiOperation(value="\u57fa\u7840\u6821\u9a8c\uff0cIVS1800\u4e13\u7528")
    @PostMapping(value={"/queryProcess"})
    public ContentResponse<String, UpgradeRespond> queryProcess(@RequestBody ParamBean<UpgradeRequest> obj) {
        UpgradeRespond respond = ((UpgradeService)this.getServer(obj.getVcmInfo())).queryProcess(obj.getVcmInfo(), (UpgradeRequest)obj.getRequestBody());
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u7528\u6237\u4fdd\u6d3b\uff0cIVS1800\u4e13\u7528")
    @PostMapping(value={"/heartBeat"})
    public ContentResponse<String, UpgradeRespond> heartBeat(@RequestBody ParamBean<UpgradeRequest> obj) {
        UpgradeRespond respond = ((UpgradeService)this.getServer(obj.getVcmInfo())).heartBeat(obj.getVcmInfo(), (UpgradeRequest)obj.getRequestBody());
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u4e8c\u6b21\u5bc6\u7801\u9274\u6743\u63a5\u53e3\uff0cIVS1800\u4e13\u7528")
    @PostMapping(value={"/doubleCheck"})
    public ContentResponse<String, UpgradeRespond> doubleCheck(@RequestBody ParamBean<UpgradeRequest> obj) {
        UpgradeRespond respond = ((UpgradeService)this.getServer(obj.getVcmInfo())).doubleCheck(obj.getVcmInfo(), (UpgradeRequest)obj.getRequestBody());
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u5220\u9664\u5b89\u88c5\u5305\u53ca\u8be5\u76ee\u5f55\u4e0b\u7684\u5176\u4ed6\u6587\u4ef6")
    @PostMapping(value={"/removePackages"})
    public ContentResponse<String, Boolean> removePackages(@RequestBody ParamBean<UpgradeRequest> obj) {
        Boolean respond = ((UpgradeService)this.getServer(obj.getVcmInfo())).removePackages(obj.getVcmInfo());
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u83b7\u53d6\u5347\u7ea7\u524d\u7684\u72b6\u6001\uff0cIVS1800\u4e13\u7528")
    @PostMapping(value={"/getUpgradeStatus"})
    public ContentResponse<String, PageRespond<UpgradeRespond>> getUpgradeStatus(@RequestBody ParamBean<UpgradeRequest> obj) {
        ArrayList<UpgradeRespond> respondList = new ArrayList<UpgradeRespond>();
        if (!CollectionUtils.isEmpty((Collection)obj.getVcmInfos())) {
            ArrayList<CompletableFuture<UpgradeRespond>> futureList = new ArrayList<CompletableFuture<UpgradeRespond>>();
            PageRespond respond = new PageRespond();
            for (VcmReqBaseInfo vcmInfo : obj.getVcmInfos()) {
                CompletableFuture<UpgradeRespond> future = CompletableFuture.supplyAsync(() -> {
                    try {
                        UpgradeRequest upgradeRequest = new UpgradeRequest();
                        return ((UpgradeService)this.getServer(vcmInfo)).getUpgradeStatus(vcmInfo, upgradeRequest);
                    }
                    catch (Exception e) {
                        LOGGER.error("CompletableFuture face search error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
                        return new UpgradeRespond();
                    }
                });
                futureList.add(future);
            }
            CompletionStage allFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).whenComplete((v, t) -> futureList.forEach(temp -> {
                UpgradeController upgradeController = this;
                synchronized (upgradeController) {
                    respondList.add(temp.getNow(null));
                }
            }));
            try {
                ((CompletableFuture)allFuture).get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("face complex CompletableFuture get error", (Throwable)e);
            }
            respond.setTotal(respondList.size());
            respond.setData(respondList);
            return ResultHelper.success((Object)respond);
        }
        PageRespond respond = new PageRespond();
        UpgradeRespond upgradeRespond = ((UpgradeService)this.getServer(obj.getVcmInfo())).getUpgradeStatus(obj.getVcmInfo(), (UpgradeRequest)obj.getRequestBody());
        respondList.add(upgradeRespond);
        respond.setData(respondList);
        respond.setTotal(1);
        respond.setPage(1);
        return ResultHelper.success((Object)respond);
    }

    public UpgradeService<?> getIvs3800Server() {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public UpgradeService<?> getIvs1800Server() {
        return this.upgradeIvs1800Service;
    }

    public UpgradeService<?> getNvr800Server() {
        return this.upgradeNvr800Service;
    }
}

