/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v1;

import com.alibaba.fastjson.JSONArray;
import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligentAnalysis.AlgorithmRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.thirdAlgorithm.InstallAlgorithmRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.thirdAlgorithm.ThirdAlgorithmRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.BaseRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.PageRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.AlgorithmRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.thirdAlgorithm.AlgorithmConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.thirdAlgorithm.AlgorithmSpaceRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.thirdAlgorithm.DeviceAlgorithmRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.thirdAlgorithm.InstallAlgorithmRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.thirdAlgorithm.InstallLicenseRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.thirdAlgorithm.ThirdAlgorithmRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.ThirdAlgorithmService;
import com.zkteco.zkbiosecurity.cuserver.utils.FileUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7b2c\u4e09\u65b9\u7b97\u6cd5"})
@RestController
@RequestMapping(value={"/rest/ics/v1/zk/thirdAlgorithm"})
public class ThirdAlgorithmController
implements BaseController<ThirdAlgorithmService<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdAlgorithmController.class);
    @Autowired
    private ThirdAlgorithmService<IServerType.Cloud> cloudThirdAlgorithmService;
    @Autowired
    private ThirdAlgorithmService<IServerType.IVS1800> ivs1800ThirdAlgorithmService;
    @Autowired
    private ThirdAlgorithmService<IServerType.NVR800> nvr800ThirdAlgorithmService;

    @ApiOperation(value="\u83b7\u53d6\u5df2\u8d2d\u4e70\u7b97\u6cd5\u5217\u8868")
    @PostMapping(value={"/getBoughtAlgorithm"})
    public ContentResponse<String, PageRespond<ThirdAlgorithmRespond>> getBoughtAlgorithm(@RequestBody ParamBean<ThirdAlgorithmRequest> obj) {
        PageRespond respond = ((ThirdAlgorithmService)this.getServer(obj.getVcmInfo())).getBoughtAlgorithm(obj.getVcmInfo(), (ThirdAlgorithmRequest)obj.getRequestBody());
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u6839\u636e\u7b97\u6cd5ID\u83b7\u53d6\u7b97\u6cd5\u8be6\u60c5")
    @PostMapping(value={"/getAlgorithmById"})
    public ContentResponse<String, ThirdAlgorithmRespond> getAlgorithmById(@RequestBody ParamBean<ThirdAlgorithmRequest> obj) {
        ThirdAlgorithmRespond respond = ((ThirdAlgorithmService)this.getServer(obj.getVcmInfo())).getAlgorithmById(obj.getVcmInfo(), (ThirdAlgorithmRequest)obj.getRequestBody());
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u83b7\u53d6\u8bbe\u5907\u7b2c\u4e09\u65b9\u7b97\u6cd5\u5217\u8868")
    @PostMapping(value={"/getDeviceAlgorithm"})
    public ContentResponse<String, PageRespond<DeviceAlgorithmRespond>> getDeviceAlgorithm(@RequestBody ParamBean<EmptyRequest> obj) {
        PageRespond respond = ((ThirdAlgorithmService)this.getServer(obj.getVcmInfo())).getDeviceAlgorithm(obj.getVcmInfo());
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u4e0a\u4f20\u7b97\u6cd5\u5305")
    @PostMapping(value={"/uploadDeviceAlgorithm"})
    public ContentResponse<String, List<InstallAlgorithmRespond>> uploadDeviceAlgorithm(@RequestParam(value="vcmInfos") String vcmInfos, @RequestParam(value="file") MultipartFile algorithmFile, @RequestParam(value="fileName") String fileName, @RequestParam(value="fileSize") String fileSize, @RequestParam(value="currentChunk") String currentChunk, @RequestParam(value="totalChunk") String totalChunk, @RequestParam(value="timestamp") String timestamp) {
        JSONArray vcmInfoArray = JSONArray.parseArray((String)vcmInfos);
        if (CollectionUtils.isEmpty((Collection)vcmInfoArray)) {
            throw new InvokeException("500", "param_error");
        }
        ArrayList<CompletableFuture<InstallAlgorithmRespond>> futureList = new ArrayList<CompletableFuture<InstallAlgorithmRespond>>();
        File file = FileUtil.saveMultipartFile((String)"upload/algorithm/local/", (String)fileName, (MultipartFile)algorithmFile);
        int i = 0;
        while (i < vcmInfoArray.size()) {
            int finalI = i++;
            CompletableFuture<InstallAlgorithmRespond> future = CompletableFuture.supplyAsync(() -> {
                VcmReqBaseInfo vcmReqBaseInfo = (VcmReqBaseInfo)vcmInfoArray.getJSONObject(finalI).toJavaObject(VcmReqBaseInfo.class);
                return ((ThirdAlgorithmService)this.getServer(vcmReqBaseInfo)).uploadDeviceAlgorithm(vcmReqBaseInfo, fileName, fileSize, currentChunk, totalChunk, timestamp, file);
            });
            futureList.add(future);
        }
        ArrayList respondList = new ArrayList();
        CompletionStage allFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).whenComplete((v, t) -> futureList.forEach(temp -> {
            ThirdAlgorithmController thirdAlgorithmController = this;
            synchronized (thirdAlgorithmController) {
                respondList.add(temp.getNow(null));
            }
        }));
        try {
            ((CompletableFuture)allFuture).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("upload algorithm package CompletableFuture error", (Throwable)e);
        }
        FileUtil.deleteFile((File)file);
        return ResultHelper.success(respondList);
    }

    @ApiOperation(value="\u66ff\u6362\u7b97\u6cd5\u5305")
    @PostMapping(value={"/replaceDeviceAlgorithm"})
    public ContentResponse<String, List<InstallAlgorithmRespond>> replaceDeviceAlgorithm(@RequestParam(value="vcmInfos") String vcmInfos, @RequestParam(value="file") MultipartFile algorithmFile, @RequestParam(value="fileName") String fileName, @RequestParam(value="algorithmName") String algorithmName, @RequestParam(value="algorithmStatus") String algorithmStatus, @RequestParam(value="fileSize") String fileSize, @RequestParam(value="currentChunk") String currentChunk, @RequestParam(value="totalChunk") String totalChunk, @RequestParam(value="timestamp") String timestamp) {
        JSONArray vcmInfoArray = JSONArray.parseArray((String)vcmInfos);
        if (CollectionUtils.isEmpty((Collection)vcmInfoArray)) {
            throw new InvokeException("500", "param_error");
        }
        ArrayList<CompletableFuture<InstallAlgorithmRespond>> futureList = new ArrayList<CompletableFuture<InstallAlgorithmRespond>>();
        File file = FileUtil.saveMultipartFile((String)"upload/algorithm/upgrade/", (String)fileName, (MultipartFile)algorithmFile);
        int i = 0;
        while (i < vcmInfoArray.size()) {
            int finalI = i++;
            CompletableFuture<InstallAlgorithmRespond> future = CompletableFuture.supplyAsync(() -> {
                VcmReqBaseInfo vcmReqBaseInfo = (VcmReqBaseInfo)vcmInfoArray.getJSONObject(finalI).toJavaObject(VcmReqBaseInfo.class);
                return ((ThirdAlgorithmService)this.getServer(vcmReqBaseInfo)).replaceDeviceAlgorithm(vcmReqBaseInfo, fileName, fileSize, currentChunk, totalChunk, timestamp, algorithmName, algorithmStatus, file);
            });
            futureList.add(future);
        }
        ArrayList respondList = new ArrayList();
        CompletionStage allFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).whenComplete((v, t) -> futureList.forEach(temp -> {
            ThirdAlgorithmController thirdAlgorithmController = this;
            synchronized (thirdAlgorithmController) {
                respondList.add(temp.getNow(null));
            }
        }));
        try {
            ((CompletableFuture)allFuture).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("replace algorithm package CompletableFuture error", (Throwable)e);
        }
        FileUtil.deleteFile((File)file);
        return ResultHelper.success(respondList);
    }

    @ApiOperation(value="\u5b89\u88c5\u7b97\u6cd5")
    @PostMapping(value={"/installAlgorithm"})
    public ContentResponse<String, InstallAlgorithmRespond> installAlgorithm(@RequestBody ParamBean<ThirdAlgorithmRequest> obj) {
        InstallAlgorithmRespond respond = ((ThirdAlgorithmService)this.getServer(obj.getVcmInfo())).installAlgorithm(obj.getVcmInfo(), (ThirdAlgorithmRequest)obj.getRequestBody());
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u7b97\u6cd5\u5378\u8f7d")
    @PostMapping(value={"/uninstallAlgorithm"})
    public ContentResponse<String, Boolean> uninstallAlgorithm(@RequestBody ParamBean<ThirdAlgorithmRequest> obj) {
        Boolean result = ((ThirdAlgorithmService)this.getServer(obj.getVcmInfo())).uninstallAlgorithm(obj.getVcmInfo(), (ThirdAlgorithmRequest)obj.getRequestBody());
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u7b97\u6cd5\u505c\u7528")
    @PostMapping(value={"/operateAlgorithm"})
    public ContentResponse<String, Boolean> operateAlgorithm(@RequestBody ParamBean<ThirdAlgorithmRequest> obj) {
        Boolean result = ((ThirdAlgorithmService)this.getServer(obj.getVcmInfo())).operateAlgorithm(obj.getVcmInfo(), (ThirdAlgorithmRequest)obj.getRequestBody());
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u4e0a\u4f20License")
    @PostMapping(value={"/uploadDeviceLicense"})
    public ContentResponse<String, List<InstallLicenseRespond>> uploadDeviceLicense(@RequestParam(value="vcmInfos") String vcmInfos, @RequestParam(value="file") MultipartFile licenseFile, @RequestParam(value="fileName") String fileName, @RequestParam(value="fileSize") String fileSize, @RequestParam(value="algorithmName") String algorithmName) {
        JSONArray vcmInfoArray = JSONArray.parseArray((String)vcmInfos);
        if (CollectionUtils.isEmpty((Collection)vcmInfoArray)) {
            throw new InvokeException("500", "param_error");
        }
        ArrayList<CompletableFuture<InstallLicenseRespond>> futureList = new ArrayList<CompletableFuture<InstallLicenseRespond>>();
        File file = FileUtil.saveMultipartFile((String)"upload/license/local/", (String)fileName, (MultipartFile)licenseFile);
        int i = 0;
        while (i < vcmInfoArray.size()) {
            int finalI = i++;
            CompletableFuture<InstallLicenseRespond> future = CompletableFuture.supplyAsync(() -> {
                VcmReqBaseInfo vcmReqBaseInfo = (VcmReqBaseInfo)vcmInfoArray.getJSONObject(finalI).toJavaObject(VcmReqBaseInfo.class);
                return ((ThirdAlgorithmService)this.getServer(vcmReqBaseInfo)).uploadDeviceLicense(vcmReqBaseInfo, fileName, fileSize, algorithmName, file);
            });
            futureList.add(future);
        }
        ArrayList respondList = new ArrayList();
        CompletionStage allFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).whenComplete((v, t) -> futureList.forEach(temp -> {
            ThirdAlgorithmController thirdAlgorithmController = this;
            synchronized (thirdAlgorithmController) {
                respondList.add(temp.getNow(null));
            }
        }));
        try {
            ((CompletableFuture)allFuture).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("upload license package CompletableFuture error", (Throwable)e);
        }
        FileUtil.deleteFile((File)file);
        return ResultHelper.success(respondList);
    }

    @ApiOperation(value="\u83b7\u53d6\u89e3\u538b\u8fdb\u5ea6")
    @PostMapping(value={"/getUploadResult"})
    public ContentResponse<String, List<BaseRespond>> getUploadResult(@RequestBody ParamBean<ThirdAlgorithmRequest> obj) {
        if (CollectionUtils.isEmpty((Collection)obj.getVcmInfos())) {
            throw new InvokeException("500", "param_error");
        }
        ArrayList<CompletableFuture<BaseRespond>> futureList = new ArrayList<CompletableFuture<BaseRespond>>();
        for (VcmReqBaseInfo vcmReqBaseInfo : obj.getVcmInfos()) {
            CompletableFuture<BaseRespond> future = CompletableFuture.supplyAsync(() -> {
                BaseRespond baseRespond;
                try {
                    baseRespond = ((ThirdAlgorithmService)this.getServer(vcmReqBaseInfo)).getUploadResult(vcmReqBaseInfo, (ThirdAlgorithmRequest)obj.getRequestBody());
                }
                catch (Exception e) {
                    LOGGER.error("CompletableFuture get upload error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
                    baseRespond = new BaseRespond();
                    if (e instanceof InvokeException) {
                        baseRespond.setResultCode(((InvokeException)((Object)((Object)e))).getCode());
                    } else {
                        baseRespond.setResultCode("unknown_error");
                    }
                    baseRespond.setDomainCode(vcmReqBaseInfo.getDomainCode());
                    baseRespond.setParentDeviceId(vcmReqBaseInfo.getParentDeviceId());
                }
                return baseRespond;
            });
            futureList.add(future);
        }
        ArrayList respondList = new ArrayList();
        CompletionStage allFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).whenComplete((v, t) -> futureList.forEach(temp -> {
            ThirdAlgorithmController thirdAlgorithmController = this;
            synchronized (thirdAlgorithmController) {
                respondList.add(temp.getNow(null));
            }
        }));
        try {
            ((CompletableFuture)allFuture).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("upload get result CompletableFuture error", (Throwable)e);
        }
        return ResultHelper.success(respondList);
    }

    @ApiOperation(value="\u5220\u9664\u7b97\u6cd5\u5305")
    @PostMapping(value={"/deleteDeviceAlgorithm"})
    public ContentResponse<String, Boolean> deleteDeviceAlgorithm(@RequestBody ParamBean<ThirdAlgorithmRequest> obj) {
        Boolean result = ((ThirdAlgorithmService)this.getServer(obj.getVcmInfo())).deleteDeviceAlgorithm(obj.getVcmInfo(), (ThirdAlgorithmRequest)obj.getRequestBody());
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u7b97\u6cd5\u5305\u4e0b\u8f7d\u94fe\u63a5")
    @PostMapping(value={"/getAlgorithmPackageUrl"})
    public ContentResponse<String, ThirdAlgorithmRespond> getAlgorithmPackageUrl(@RequestBody ParamBean<ThirdAlgorithmRequest> obj) {
        ThirdAlgorithmRespond respond = ((ThirdAlgorithmService)this.getServer(obj.getVcmInfo())).getAlgorithmPackageUrl(obj.getVcmInfo(), (ThirdAlgorithmRequest)obj.getRequestBody());
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u83b7\u53d6license\u4e0b\u8f7d\u94fe\u63a5")
    @PostMapping(value={"/getLicensePackageUrl"})
    public ContentResponse<String, ThirdAlgorithmRespond> getLicensePackageUrl(@RequestBody ParamBean<ThirdAlgorithmRequest> obj) {
        ThirdAlgorithmRespond respond = ((ThirdAlgorithmService)this.getServer(obj.getVcmInfo())).getLicensePackageUrl(obj.getVcmInfo(), (ThirdAlgorithmRequest)obj.getRequestBody());
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u4e0a\u4f20\u6444\u50cf\u673a\u7b97\u6cd5\u5305")
    @PostMapping(value={"/uploadSdcAlgorithmPackage"})
    public InstallAlgorithmRespond uploadSdcAlgorithmPackage(@RequestBody ParamBean<InstallAlgorithmRequest> obj) {
        return ((ThirdAlgorithmService)this.getServer(obj.getVcmInfo())).uploadSdcAlgorithmPackage(obj.getVcmInfo(), (InstallAlgorithmRequest)obj.getRequestBody());
    }

    @ApiOperation(value="\u5b89\u88c5\u6444\u50cf\u673a\u7b2c\u4e09\u65b9\u7b97\u6cd5\u5305")
    @PostMapping(value={"/installSdcAlgorithm"})
    public InstallAlgorithmRespond installSdcAlgorithm(@RequestBody ParamBean<InstallAlgorithmRequest> obj) {
        LOGGER.info("install sdc algorithm IP: {}", (Object)obj.getVcmInfo().getVcmIp());
        return ((ThirdAlgorithmService)this.getServer(obj.getVcmInfo())).installSdcAlgorithm(obj.getVcmInfo(), (InstallAlgorithmRequest)obj.getRequestBody());
    }

    @ApiOperation(value="\u64cd\u4f5c\u6444\u50cf\u673a\u7b2c\u4e09\u65b9\u7b97\u6cd5\u5305")
    @PostMapping(value={"/operateSdcAlgorithm"})
    public InstallAlgorithmRespond operateSdcAlgorithm(@RequestBody ParamBean<InstallAlgorithmRequest> obj) {
        return ((ThirdAlgorithmService)this.getServer(obj.getVcmInfo())).operateSdcAlgorithm(obj.getVcmInfo(), (InstallAlgorithmRequest)obj.getRequestBody());
    }

    @ApiOperation(value="\u83b7\u53d6\u6444\u50cf\u673a\u7b97\u6cd5\u4e0b\u8f7d\u94fe\u63a5")
    @PostMapping(value={"/getAlgorithmPackageInfo"})
    public ContentResponse<String, ThirdAlgorithmRespond> getAlgorithmPackageInfo(@RequestBody ParamBean<ThirdAlgorithmRequest> obj) {
        ThirdAlgorithmRespond respond = ((ThirdAlgorithmService)this.getServer(obj.getVcmInfo())).getAlgorithmPackageInfo(obj.getVcmInfo(), (ThirdAlgorithmRequest)obj.getRequestBody());
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u5206\u914dlicense")
    @PostMapping(value={"/assignLicense"})
    public ContentResponse<String, ThirdAlgorithmRespond> assignLicense(@RequestBody ParamBean<ThirdAlgorithmRequest> obj) {
        ThirdAlgorithmRespond respond = ((ThirdAlgorithmService)this.getServer(obj.getVcmInfo())).assignLicense(obj.getVcmInfo(), (ThirdAlgorithmRequest)obj.getRequestBody());
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u83b7\u53d6license")
    @PostMapping(value={"/getLicense"})
    public ContentResponse<String, ThirdAlgorithmRespond> getLicense(@RequestBody ParamBean<ThirdAlgorithmRequest> obj) {
        ThirdAlgorithmRespond respond = ((ThirdAlgorithmService)this.getServer(obj.getVcmInfo())).getLicense(obj.getVcmInfo(), (ThirdAlgorithmRequest)obj.getRequestBody());
        return ResultHelper.success((Object)respond);
    }

    @PostMapping(value={"/clearSpace"})
    public InstallAlgorithmRespond clearSpace(@RequestBody ParamBean<InstallAlgorithmRequest> obj) {
        return ((ThirdAlgorithmService)this.getServer(obj.getVcmInfo())).clearSpace(obj.getVcmInfo(), (InstallAlgorithmRequest)obj.getRequestBody());
    }

    @PostMapping(value={"/getAlgorithmVersions"})
    public ContentResponse<String, List<ThirdAlgorithmRespond>> getAlgorithmVersions(@RequestBody ParamBean<ThirdAlgorithmRequest> obj) {
        List respondList = ((ThirdAlgorithmService)this.getServer(obj.getVcmInfo())).getAlgorithmVersions(obj.getVcmInfo(), (ThirdAlgorithmRequest)obj.getRequestBody());
        return ResultHelper.success((Object)respondList);
    }

    @PostMapping(value={"/getAlgorithmLang"})
    public ContentResponse<String, AlgorithmConfigRespond> getAlgorithmLang(@RequestBody ParamBean<ThirdAlgorithmRequest> obj) {
        AlgorithmConfigRespond respond = ((ThirdAlgorithmService)this.getServer(obj.getVcmInfo())).getAlgorithmLang(obj.getVcmInfo(), (ThirdAlgorithmRequest)obj.getRequestBody());
        return ResultHelper.success((Object)respond);
    }

    @PostMapping(value={"/getThirdWebInfo"})
    public ContentResponse<String, AlgorithmConfigRespond> getThirdWebInfo(@RequestBody ParamBean<ThirdAlgorithmRequest> obj) {
        AlgorithmConfigRespond respond = ((ThirdAlgorithmService)this.getServer(obj.getVcmInfo())).getThirdWebInfo(obj.getVcmInfo());
        return ResultHelper.success((Object)respond);
    }

    @PostMapping(value={"/getAlgorithmSpace"})
    public AlgorithmSpaceRespond getAlgorithmSpace(@RequestBody ParamBean<EmptyRequest> obj) {
        return ((ThirdAlgorithmService)this.getServer(obj.getVcmInfo())).getAlgorithmSpace(obj.getVcmInfo());
    }

    @PostMapping(value={"/clearAlgorithmSpace"})
    public BaseRespond clearAlgorithmSpace(@RequestBody ParamBean<EmptyRequest> obj) {
        return ((ThirdAlgorithmService)this.getServer(obj.getVcmInfo())).clearAlgorithmSpace(obj.getVcmInfo());
    }

    @PostMapping(value={"/syncAlgorithmName"})
    public ContentResponse<String, AlgorithmRespond> syncAlgorithmName(@RequestBody ParamBean<AlgorithmRequest> obj) {
        AlgorithmRespond respond = ((ThirdAlgorithmService)this.getServer(obj.getVcmInfo())).syncAlgorithmName(obj.getVcmInfo(), (AlgorithmRequest)obj.getRequestBody());
        return ResultHelper.success((Object)respond);
    }

    public ThirdAlgorithmService<?> getIvs3800Server() {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public ThirdAlgorithmService<?> getIvs1800Server() {
        return this.ivs1800ThirdAlgorithmService;
    }

    public ThirdAlgorithmService<?> getNvr800Server() {
        return this.nvr800ThirdAlgorithmService;
    }

    public ThirdAlgorithmService<?> getCloudServer() {
        return this.cloudThirdAlgorithmService;
    }
}

