/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v1;

import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.LoginRequest;
import com.zkteco.zkbiosecurity.cuserver.service.TestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/ics/v1/zk/test"})
public class TestController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestController.class);
    @Autowired
    private TestService testService;

    @PostMapping(value={"/request"})
    public ContentResponse<String, Boolean> testRequest(@RequestBody ParamBean<LoginRequest> obj) {
        try {
            String token = ((LoginRequest)obj.getRequestBody()).getUserName();
            this.testService.test(token);
        }
        catch (Exception e) {
            LOGGER.error("test operate error", (Throwable)e);
        }
        return ResultHelper.success((Object)true);
    }

    @PostMapping(value={"/login"})
    public ContentResponse<String, Boolean> login(@RequestBody ParamBean<LoginRequest> obj) {
        try {
            this.testService.login();
        }
        catch (Exception e) {
            LOGGER.error("test operate error", (Throwable)e);
        }
        return ResultHelper.success((Object)true);
    }
}

