/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v1;

import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligentAnalysis.AlgorithmRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.taskManagement.TaskManagementRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.AlgorithmRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.taskManagement.TaskManagementSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.TaskManagementService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u667a\u80fd\u5206\u6790\u4efb\u52a1"})
@RestController
@RequestMapping(value={"/rest/ics/v1/zk/task"})
public class TaskManagementController
implements BaseController<TaskManagementService<?>> {
    @Autowired
    private TaskManagementService<IServerType.IVS1800> taskManagementService;

    @ApiOperation(value="\u667a\u80fd\u5206\u6790\u4efb\u52a1\u5217\u8868\u67e5\u8be2")
    @RequestMapping(value={"/search"}, method={RequestMethod.POST})
    public ContentResponse<String, TaskManagementSearchRespond> searchTaskList(@RequestBody ParamBean<TaskManagementRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        TaskManagementRequest req = (TaskManagementRequest)obj.getRequestBody();
        TaskManagementSearchRespond result = ((TaskManagementService)this.getServer(vcmInfo)).search(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u521b\u5efa\u5206\u6790\u4efb\u52a1")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ContentResponse<String, TaskManagementSearchRespond> addTaskList(@RequestBody ParamBean<TaskManagementRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        TaskManagementRequest req = (TaskManagementRequest)obj.getRequestBody();
        TaskManagementSearchRespond result = ((TaskManagementService)this.getServer(vcmInfo)).add(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u6279\u91cf\u521b\u5efa\u5206\u6790\u4efb\u52a1")
    @RequestMapping(value={"/batchAdd"}, method={RequestMethod.POST})
    public ContentResponse<String, TaskManagementSearchRespond> batchAddition(@RequestBody ParamBean<TaskManagementRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        TaskManagementRequest req = (TaskManagementRequest)obj.getRequestBody();
        TaskManagementSearchRespond result = ((TaskManagementService)this.getServer(vcmInfo)).batchAddition(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u5220\u9664\u667a\u80fd\u5206\u6790\u4efb\u52a1")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ContentResponse<String, TaskManagementSearchRespond> delete(@RequestBody ParamBean<TaskManagementRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        TaskManagementRequest req = (TaskManagementRequest)obj.getRequestBody();
        TaskManagementSearchRespond result = ((TaskManagementService)this.getServer(vcmInfo)).delete(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u505c\u6b62\u667a\u80fd\u5206\u6790\u4efb\u52a1")
    @RequestMapping(value={"/stop"}, method={RequestMethod.POST})
    public ContentResponse<String, TaskManagementSearchRespond> stop(@RequestBody ParamBean<TaskManagementRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        TaskManagementRequest req = (TaskManagementRequest)obj.getRequestBody();
        TaskManagementSearchRespond result = ((TaskManagementService)this.getServer(vcmInfo)).stop(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u91cd\u542f\u667a\u80fd\u5206\u6790\u4efb\u52a1")
    @RequestMapping(value={"/restart"}, method={RequestMethod.POST})
    public ContentResponse<String, TaskManagementSearchRespond> restart(@RequestBody ParamBean<TaskManagementRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        TaskManagementRequest req = (TaskManagementRequest)obj.getRequestBody();
        TaskManagementSearchRespond result = ((TaskManagementService)this.getServer(vcmInfo)).restart(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u4fee\u6539\u667a\u80fd\u5206\u6790\u4efb\u52a1")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ContentResponse<String, TaskManagementSearchRespond> update(@RequestBody ParamBean<TaskManagementRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        TaskManagementRequest req = (TaskManagementRequest)obj.getRequestBody();
        TaskManagementSearchRespond result = ((TaskManagementService)this.getServer(vcmInfo)).update(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u667a\u80fd\u5206\u6790\u4efb\u52a1-\u67e5\u8be2\u7b97\u6cd5\u4fe1\u606f")
    @RequestMapping(value={"/loadAlgorithm"}, method={RequestMethod.POST})
    public ContentResponse<String, AlgorithmRespond> loadAlgorithm(@RequestBody ParamBean<AlgorithmRequest> obj) {
        AlgorithmRespond respond = ((TaskManagementService)this.getServer(obj.getVcmInfo())).loadAlgorithm(obj.getVcmInfo(), (AlgorithmRequest)obj.getRequestBody());
        return ResultHelper.success((Object)respond);
    }

    public TaskManagementService<?> getIvs3800Server() {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public TaskManagementService<?> getIvs1800Server() {
        return this.taskManagementService;
    }

    public TaskManagementService<?> getNvr800Server() {
        throw new InvokeException("500", "cu_device_not_support");
    }
}

