/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v1;

import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.SystemConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.TimeConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.TimeConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.SystemConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SystemConfigService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SdcServiceType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Set;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e3b\u8bbe\u5907\u7cfb\u7edf\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/rest/ics/v1/zk/systemConfig"})
public class SystemConfigController
implements BaseController<SystemConfigService<?>> {
    @Autowired
    private SystemConfigService<IServerType.IVS1800> systemConfigIvs1800Service;
    @Autowired
    private SystemConfigService<IServerType.NVR800> systemConfigNvr800Service;
    @Autowired
    private SystemConfigService<IServerType.ZKNVR> systemConfigZKNvrService;
    @Autowired
    private SystemConfigService<IServerType.ZKIPC> systemConfigZKIpcService;
    @Autowired
    private Set<SystemConfigService<IServerType.SDC>> systemConfigSdcServiceSet;
    @Autowired
    private SystemConfigService<IServerType.Tiandy> systemConfigTIANDYService;
    @Autowired
    private SystemConfigService<IServerType.Onvif> onvifSystemConfigService;

    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570")
    @RequestMapping(value={"/system/get"}, method={RequestMethod.POST})
    public ContentResponse<String, SystemConfigRespond> getSystemConfig(@RequestBody ParamBean<EmptyRequest> obj) {
        SystemConfigRespond respond = ((SystemConfigService)this.getServer(obj.getVcmInfo())).getSystemConfig(obj);
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u7cfb\u7edf\u53c2\u6570")
    @RequestMapping(value={"/system/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setSystemConfig(@RequestBody ParamBean<SystemConfigRequest> obj) {
        boolean result = ((SystemConfigService)this.getServer(obj.getVcmInfo())).setSystemConfig(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u65f6\u95f4\u914d\u7f6e")
    @RequestMapping(value={"/date/get"}, method={RequestMethod.POST})
    public ContentResponse<String, TimeConfigRespond> getDateConfig(@RequestBody ParamBean<EmptyRequest> obj) {
        TimeConfigRespond timeConfigRespond = ((SystemConfigService)this.getServer(obj.getVcmInfo())).getDateConfig(obj);
        return ResultHelper.success((Object)timeConfigRespond);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u7cfb\u7edf\u65f6\u95f4\u914d\u7f6e")
    @RequestMapping(value={"/date/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setDateConfig(@RequestBody ParamBean<TimeConfigRequest> obj) {
        boolean result = ((SystemConfigService)this.getServer(obj.getVcmInfo())).setTimeConfig(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6NTP\u914d\u7f6e")
    @PostMapping(value={"/date/getNtp"})
    public ContentResponse<String, TimeConfigRespond> getNtpConfig(@RequestBody ParamBean<EmptyRequest> obj) {
        TimeConfigRespond respond = ((SystemConfigService)this.getServer(obj.getVcmInfo())).getNtpConfig(obj);
        return ResultHelper.success((Object)respond);
    }

    public SystemConfigService<IServerType.IVS3800> getIvs3800Server() {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public SystemConfigService<IServerType.IVS1800> getIvs1800Server() {
        return this.systemConfigIvs1800Service;
    }

    public SystemConfigService<IServerType.NVR800> getNvr800Server() {
        return this.systemConfigNvr800Service;
    }

    public SystemConfigService<IServerType.ZKNVR> getZKNVRServer() {
        return this.systemConfigZKNvrService;
    }

    public SystemConfigService<IServerType.ZKIPC> getZKIPCServer() {
        return this.systemConfigZKIpcService;
    }

    public SystemConfigService<IServerType.Tiandy> getTIANDYServer() {
        return this.systemConfigTIANDYService;
    }

    public SystemConfigService<?> getSdcServer(int implType) {
        for (SystemConfigService systemConfigService : this.systemConfigSdcServiceSet) {
            SdcServiceType sdkType = AopUtils.getTargetClass((Object)systemConfigService).getAnnotation(SdcServiceType.class);
            if (sdkType == null || sdkType.value() != implType) continue;
            return systemConfigService;
        }
        return null;
    }

    public SystemConfigService<?> getOnvifServer() {
        return this.onvifSystemConfigService;
    }
}

