/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v1;

import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.common.SnapshotRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.SnapshotRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SnapshotService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SdcServiceType;
import io.swagger.annotations.Api;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u624b\u52a8\u6293\u56fe"})
@RestController
@RequestMapping(value={"/rest/ics/v1/zk/snapshot"})
public class SnapshotController
implements BaseController<SnapshotService<?>> {
    @Autowired
    private SnapshotService<IServerType.IVS1800> snapshotIvs1800Service;
    @Autowired
    private SnapshotService<IServerType.NVR800> snapshotNvr800Service;
    @Autowired
    private SnapshotService<IServerType.ZKNVR> snapshotZKNvrServiceImpl;
    @Autowired
    private SnapshotService<IServerType.ZKIPC> snapshotZKIpcService;
    @Autowired
    private Set<SnapshotService<IServerType.SDC>> snapshotSdcServiceSet;
    @Autowired
    private SnapshotService<IServerType.Tiandy> snapshotTIANDYService;
    @Autowired
    private SnapshotService<IServerType.Onvif> snapshotOnvifService;
    @Autowired
    private SnapshotService<IServerType.HIKVISION> snapshotHIKVISIONService;
    @Autowired
    private SnapshotService<IServerType.DHNVR> snapshotDHNvrService;

    @RequestMapping(value={"/create"})
    public ContentResponse<String, SnapshotRespond> createSnapshot(@RequestBody ParamBean<SnapshotRequest> obj, HttpServletResponse httpResponse) throws SDKException {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        SnapshotRequest req = (SnapshotRequest)obj.getRequestBody();
        SnapshotRespond result = ((SnapshotService)this.getServer(vcmInfo)).createSnapshot(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    public SnapshotService<IServerType.IVS3800> getIvs3800Server() {
        return null;
    }

    public SnapshotService<IServerType.IVS1800> getIvs1800Server() {
        return this.snapshotIvs1800Service;
    }

    public SnapshotService<IServerType.NVR800> getNvr800Server() {
        return this.snapshotNvr800Service;
    }

    public SnapshotService<IServerType.ZKNVR> getZKNVRServer() {
        return this.snapshotZKNvrServiceImpl;
    }

    public SnapshotService<IServerType.ZKIPC> getZKIPCServer() {
        return this.snapshotZKIpcService;
    }

    public SnapshotService<IServerType.Tiandy> getTIANDYServer() {
        return this.snapshotTIANDYService;
    }

    public SnapshotService<IServerType.Onvif> getOnvifServer() {
        return this.snapshotOnvifService;
    }

    public SnapshotService<IServerType.HIKVISION> getHIKVISIONServer() {
        return this.snapshotHIKVISIONService;
    }

    public SnapshotService<IServerType.DHNVR> getDHNVRServer() {
        return this.snapshotDHNvrService;
    }

    public SnapshotService<?> getSdcServer(int implType) {
        for (SnapshotService snapshotService : this.snapshotSdcServiceSet) {
            SdcServiceType sdkType = AopUtils.getTargetClass((Object)snapshotService).getAnnotation(SdcServiceType.class);
            if (sdkType == null || sdkType.value() != implType) continue;
            return snapshotService;
        }
        return null;
    }
}

