/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v1;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.smartdatasubscribes.SmartDataSubscribesRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.smartdatasubscribes.SubscribesBaseRespond;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SmartDataSubscribesService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u667a\u80fd\u6570\u636e\u8ba2\u9605\u63a8\u9001 IVS1800\u63a5\u53e3"})
@Controller
@RequestMapping(value={"/rest/ics/v1/zk/subscribes"})
public class SmartDataSubscribesController
implements BaseController<SmartDataSubscribesService<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartDataSubscribesController.class);
    @Autowired
    private SmartDataSubscribesService<IServerType.IVS1800> ivs1800SmartDataSubscribesService;

    @ApiOperation(value="\u6dfb\u52a0/\u4fee\u6539\u667a\u80fd\u6570\u636e\u8ba2\u9605")
    @RequestMapping(value={"/addOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public ContentResponse<String, SubscribesBaseRespond> addOrUpdate(@RequestBody ParamBean<SmartDataSubscribesRequest> obj) {
        return ResultHelper.success((Object)((SmartDataSubscribesService)this.getServer(obj.getVcmInfo())).addOrUpdate(obj.getVcmInfo(), (SmartDataSubscribesRequest)obj.getRequestBody()));
    }

    @ApiOperation(value="\u5220\u9664\u8ba2\u9605")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public ContentResponse<String, SubscribesBaseRespond> delete(@RequestBody ParamBean<SmartDataSubscribesRequest> obj) {
        return ResultHelper.success((Object)((SmartDataSubscribesService)this.getServer(obj.getVcmInfo())).delete(obj.getVcmInfo(), (SmartDataSubscribesRequest)obj.getRequestBody()));
    }

    @RequestMapping(value={"/push/{domainCode}"}, method={RequestMethod.POST})
    @ResponseBody
    public void subscribesCallback(@RequestBody String requestData, @PathVariable String domainCode) {
        ValueFilter valueFilter = (object, name, value) -> {
            if ("data".equalsIgnoreCase(name) && ObjectUtils.isNotEmpty((Object)value)) {
                return "base64";
            }
            return value;
        };
        try {
            JSONObject data = JSONObject.parseObject((String)requestData);
            LOGGER.info("IVS 1800 push smart receive data, domainCode:{},data:{}", (Object)domainCode, (Object)JSON.toJSONString((Object)data, (SerializeFilter)valueFilter, (SerializerFeature[])new SerializerFeature[0]));
            this.ivs1800SmartDataSubscribesService.push(data, domainCode);
        }
        catch (Exception e) {
            LOGGER.error("IVS 1800 push smart alarm error", (Throwable)e);
        }
    }

    public SmartDataSubscribesService<?> getIvs3800Server() {
        return null;
    }

    public SmartDataSubscribesService<?> getIvs1800Server() {
        return this.ivs1800SmartDataSubscribesService;
    }

    public SmartDataSubscribesService<?> getNvr800Server() {
        return null;
    }
}

