/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v1;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.aspect.IcsCheck;
import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.ScheduleSetRequest;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.ScheduleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8ba1\u5212\u8868 NVR800\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/rest/ics/v1/zk/schedule"})
public class ScheduleController
implements BaseController<ScheduleService<?>> {
    @Autowired
    private ScheduleService<IServerType.NVR800> scheduleNvr800Service;

    @ApiOperation(value="\u83b7\u53d6\u5f55\u50cf\u8ba1\u5212\u8868")
    @IcsCheck
    @RequestMapping(value={"/record/get"}, method={RequestMethod.POST})
    public ContentResponse<String, JSONObject> getRecord(@RequestBody ParamBean<ChannelRequest> obj) {
        JSONObject result = ((ScheduleService)this.getServer(obj.getVcmInfo())).getRecordSchedule(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u544a\u8b66\u8ba1\u5212\u8868")
    @IcsCheck
    @RequestMapping(value={"/alarm/get"}, method={RequestMethod.POST})
    public ContentResponse<String, JSONObject> getAlarm(@RequestBody ParamBean<ChannelRequest> obj) {
        JSONObject result = ((ScheduleService)this.getServer(obj.getVcmInfo())).getAlarmSchedule(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u90ae\u4ef6\u8ba1\u5212\u8868")
    @IcsCheck
    @RequestMapping(value={"/email/get"}, method={RequestMethod.POST})
    public ContentResponse<String, JSONObject> getEmail(@RequestBody ParamBean<ChannelRequest> obj) {
        JSONObject result = ((ScheduleService)this.getServer(obj.getVcmInfo())).getEmailSchedule(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u5f55\u50cf\u8ba1\u5212\u8868")
    @IcsCheck
    @RequestMapping(value={"/record/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setRecord(@RequestBody ParamBean<ScheduleSetRequest> obj) {
        boolean result = ((ScheduleService)this.getServer(obj.getVcmInfo())).setRecordSchedule(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u544a\u8b66\u8ba1\u5212\u8868")
    @IcsCheck
    @RequestMapping(value={"/alarm/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setAlarm(@RequestBody ParamBean<ScheduleSetRequest> obj) {
        boolean result = ((ScheduleService)this.getServer(obj.getVcmInfo())).setAlarmSchedule(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u90ae\u4ef6\u8ba1\u5212\u8868")
    @IcsCheck
    @RequestMapping(value={"/email/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setEmail(@RequestBody ParamBean<ScheduleSetRequest> obj) {
        boolean result = ((ScheduleService)this.getServer(obj.getVcmInfo())).setEmailSchedule(obj);
        return ResultHelper.success((Object)result);
    }

    public ScheduleService<IServerType.IVS3800> getIvs3800Server() {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public ScheduleService<IServerType.IVS1800> getIvs1800Server() {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public ScheduleService<IServerType.NVR800> getNvr800Server() {
        return this.scheduleNvr800Service;
    }
}

