/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v1;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPPlayBackRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPRealPlayRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPVideoDownloadRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPVoiceRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPPlayBackRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPRealPlayRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPVideoDownloadRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPVoiceRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.RTSPService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SdcServiceType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Set;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"RTSP\u6d41"})
@RestController
@RequestMapping(value={"/rest/ics/v1/zk/rtsp"})
public class RTSPController
implements BaseController<RTSPService<?>> {
    @Autowired
    private RTSPService<IServerType.IVS1800> rtspIvs1800Service;
    @Autowired
    private RTSPService<IServerType.NVR800> rtspNVR800Service;
    @Autowired
    private RTSPService<IServerType.Cloud> rtspCloudService;
    @Autowired
    private RTSPService<IServerType.ZKNVR> rtspZKNvrService;
    @Autowired
    private Set<RTSPService<IServerType.SDC>> rtspServiceSdcSet;
    @Autowired
    private RTSPService<IServerType.Tiandy> rtspTIANDYService;
    @Autowired
    private RTSPService<IServerType.HIKVISION> rtspHIKVISIONService;
    @Autowired
    private RTSPService<IServerType.Onvif> rtspOnvifService;
    @Autowired
    private RTSPService<IServerType.ZKIPC> rtspZKIpcService;
    @Autowired
    private RTSPService<IServerType.DHNVR> rtspDHNvrService;

    @ApiOperation(value="\u83b7\u53d6\u5b9e\u65f6\u7801\u6d41")
    @RequestMapping(value={"/realPlay"}, method={RequestMethod.POST})
    public ContentResponse<String, RTSPRealPlayRespond> realPlay(@RequestBody ParamBean<RTSPRealPlayRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        RTSPRealPlayRequest req = (RTSPRealPlayRequest)obj.getRequestBody();
        RTSPRealPlayRespond result = ((RTSPService)this.getServer(vcmInfo)).realPlay(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u56de\u653e\u7801\u6d41")
    @RequestMapping(value={"/playBack"}, method={RequestMethod.POST})
    public ContentResponse<String, RTSPPlayBackRespond> playBack(@RequestBody ParamBean<RTSPPlayBackRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        RTSPPlayBackRequest req = (RTSPPlayBackRequest)obj.getRequestBody();
        RTSPPlayBackRespond result = ((RTSPService)this.getServer(vcmInfo)).playBack(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e91\u670d\u52a1\u8bbe\u5907\u7aef\u5f55\u50cf\u5217\u8868\u8fde\u63a5\u4fe1\u606f")
    @RequestMapping(value={"/getP2PConnectInfo"}, method={RequestMethod.POST})
    public ContentResponse<String, JSONObject> getP2PConnectInfo(@RequestBody ParamBean<RTSPRealPlayRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        RTSPRealPlayRequest req = (RTSPRealPlayRequest)obj.getRequestBody();
        JSONObject result = ((RTSPService)this.getServer(vcmInfo)).getP2PConnectInfo(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u8bed\u97f3\u5bf9\u8bb2\u7801\u6d41")
    @RequestMapping(value={"/voice"}, method={RequestMethod.POST})
    public ContentResponse<String, RTSPVoiceRespond> voice(@RequestBody ParamBean<RTSPVoiceRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        RTSPVoiceRequest req = (RTSPVoiceRequest)obj.getRequestBody();
        RTSPVoiceRespond result = ((RTSPService)this.getServer(vcmInfo)).voice(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u5e7f\u64ad\u7801\u6d41")
    @RequestMapping(value={"/broadcast"}, method={RequestMethod.POST})
    public ContentResponse<String, RTSPVoiceRespond> broadcast(@RequestBody ParamBean<RTSPVoiceRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        RTSPVoiceRequest req = (RTSPVoiceRequest)obj.getRequestBody();
        RTSPVoiceRespond result = ((RTSPService)this.getServer(vcmInfo)).broadcast(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u5f55\u50cf\u4e0b\u8f7d")
    @RequestMapping(value={"/videoDownload"}, method={RequestMethod.POST})
    public ContentResponse<String, RTSPVideoDownloadRespond> videoDownload(@RequestBody ParamBean<RTSPVideoDownloadRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        RTSPVideoDownloadRequest req = (RTSPVideoDownloadRequest)obj.getRequestBody();
        RTSPVideoDownloadRespond result = ((RTSPService)this.getServer(vcmInfo)).videoDownload(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="rtsp\u9274\u6743\u4fe1\u606f\u8bbe\u7f6e")
    @RequestMapping(value={"/rtspAuthSet"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> rtspAuthSet(@RequestBody ParamBean<RTSPRealPlayRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        RTSPRealPlayRequest req = (RTSPRealPlayRequest)obj.getRequestBody();
        Boolean result = ((RTSPService)this.getServer(vcmInfo)).rtspAuthSet(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    public RTSPService<?> getIvs3800Server() {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public RTSPService<IServerType.IVS1800> getIvs1800Server() {
        return this.rtspIvs1800Service;
    }

    public RTSPService<IServerType.NVR800> getNvr800Server() {
        return this.rtspNVR800Service;
    }

    public RTSPService<IServerType.Cloud> getCloudServer() {
        return this.rtspCloudService;
    }

    public RTSPService<IServerType.ZKNVR> getZKNVRServer() {
        return this.rtspZKNvrService;
    }

    public RTSPService<IServerType.Tiandy> getTIANDYServer() {
        return this.rtspTIANDYService;
    }

    public RTSPService<IServerType.HIKVISION> getHIKVISIONServer() {
        return this.rtspHIKVISIONService;
    }

    public RTSPService<IServerType.ZKIPC> getZKIPCServer() {
        return this.rtspZKIpcService;
    }

    public RTSPService<IServerType.DHNVR> getDHNVRServer() {
        return this.rtspDHNvrService;
    }

    public RTSPService<?> getSdcServer(int implType) {
        for (RTSPService rtspService : this.rtspServiceSdcSet) {
            SdcServiceType sdkType = AopUtils.getTargetClass((Object)rtspService).getAnnotation(SdcServiceType.class);
            if (sdkType == null || sdkType.value() != implType) continue;
            return rtspService;
        }
        return null;
    }

    public RTSPService<?> getOnvifServer() {
        return this.rtspOnvifService;
    }
}

