/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v1;

import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.PresetPositionRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.PresetPositionRespond;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.PresetPositionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9884\u7f6e\u4f4d"})
@RestController
@RequestMapping(value={"/rest/ics/v1/zk/presetPosition"})
public class PresetPositionController
implements BaseController<PresetPositionService<?>> {
    @Autowired
    private PresetPositionService<IServerType.IVS1800> presetPositionIvs1800Service;
    @Autowired
    private PresetPositionService<IServerType.NVR800> presetPositionNvr800Service;
    @Autowired
    private PresetPositionService<IServerType.SDC> presetPositionSdcService;

    @ApiOperation(value="\u6dfb\u52a0\u9884\u7f6e\u4f4d")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ContentResponse<String, PresetPositionRespond> add(@RequestBody ParamBean<PresetPositionRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        PresetPositionRequest req = (PresetPositionRequest)obj.getRequestBody();
        PresetPositionRespond result = ((PresetPositionService)this.getServer(vcmInfo)).add(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u5220\u9664\u9884\u7f6e\u4f4d")
    @RequestMapping(value={"/del"}, method={RequestMethod.POST})
    public ContentResponse<String, PresetPositionRespond> del(@RequestBody ParamBean<PresetPositionRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        PresetPositionRequest req = (PresetPositionRequest)obj.getRequestBody();
        PresetPositionRespond result = ((PresetPositionService)this.getServer(vcmInfo)).del(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u4fee\u6539\u9884\u7f6e\u4f4d")
    @RequestMapping(value={"/upt"}, method={RequestMethod.POST})
    public ContentResponse<String, PresetPositionRespond> upt(@RequestBody ParamBean<PresetPositionRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        PresetPositionRequest req = (PresetPositionRequest)obj.getRequestBody();
        PresetPositionRespond result = ((PresetPositionService)this.getServer(vcmInfo)).upt(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u9884\u7f6e\u4f4d\u5217\u8868")
    @RequestMapping(value={"/list"}, method={RequestMethod.POST})
    public ContentResponse<String, Map<String, List<PresetPositionRespond>>> list(@RequestBody ParamBean<PresetPositionRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        PresetPositionRequest req = (PresetPositionRequest)obj.getRequestBody();
        List list = ((PresetPositionService)this.getServer(vcmInfo)).list(vcmInfo, req);
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("ptzPresetInfoList", list);
        return ResultHelper.success(map);
    }

    public PresetPositionService<IServerType.IVS3800> getIvs3800Server() {
        return null;
    }

    public PresetPositionService<IServerType.IVS1800> getIvs1800Server() {
        return this.presetPositionIvs1800Service;
    }

    public PresetPositionService<IServerType.NVR800> getNvr800Server() {
        return this.presetPositionNvr800Service;
    }

    public PresetPositionService<IServerType.SDC> getSdcServer() {
        return this.presetPositionSdcService;
    }
}

