/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v1;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.picturesearch.DataDictionaryRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.picturesearch.FaceImageSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.picturesearch.FaceSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.picturesearch.HumanSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.picturesearch.PerInfoSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.picturesearch.PicturePlaybackRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.picturesearch.DataDictionaryRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.picturesearch.FaceSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.picturesearch.HumanSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.picturesearch.PicturePlaybackRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.PictureSearchService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u56fe\u7247\u641c\u7d22"})
@RestController
@RequestMapping(value={"/rest/ics/v1/zk/picture"})
public class PictureSearchController
implements BaseController<PictureSearchService<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PictureSearchController.class);
    @Autowired
    private PictureSearchService<IServerType.NVR800> pictureSearchNvr800Service;
    @Autowired
    private PictureSearchService<IServerType.IVS1800> pictureSearchIvs1800Service;

    @ApiOperation(value="\u56fe\u7247\u56de\u653e\uff08\u8d44\u6599\u4e2d\u5fc3\uff09 NVR800\u63a5\u53e3")
    @RequestMapping(value={"/playback"}, method={RequestMethod.POST})
    public ContentResponse<String, PicturePlaybackRespond> picturePlayback(@RequestBody ParamBean<PicturePlaybackRequest> obj) {
        PicturePlaybackRespond config = ((PictureSearchService)this.getServer(obj.getVcmInfo())).picturePlayback(obj);
        return ResultHelper.success((Object)config);
    }

    @ApiOperation(value="\u4eba\u8138\u68c0\u7d22\u603b\u6570\u91cf\uff08\u4e0d\u5305\u542b\u56fe\u7247\uff09 NVR800\u63a5\u53e3")
    @RequestMapping(value={"/faceSearch"}, method={RequestMethod.POST})
    public ContentResponse<String, FaceSearchRespond> faceSearch(@RequestBody ParamBean<FaceSearchRequest> obj) {
        FaceSearchRespond config = ((PictureSearchService)this.getServer(obj.getVcmInfo())).faceSearch(obj);
        return ResultHelper.success((Object)config);
    }

    @ApiOperation(value="\u6839\u636e\u4eba\u8138UUID\u68c0\u7d22\u4eba\u8138\u4fe1\u606f\uff08\u5305\u542b\u56fe\u7247\uff09 NVR800\u63a5\u53e3")
    @RequestMapping(value={"/faceImageSearch"}, method={RequestMethod.POST})
    public ContentResponse<String, FaceSearchRespond> faceImageSearch(@RequestBody ParamBean<FaceImageSearchRequest> obj) {
        FaceSearchRespond config = ((PictureSearchService)this.getServer(obj.getVcmInfo())).faceImageSearch(obj);
        return ResultHelper.success((Object)config);
    }

    @ApiOperation(value="\u4eba\u8138\u68c0\u7d22\u4ee5\u56fe\u6536\u56fe NVR800\u63a5\u53e3")
    @RequestMapping(value={"/faceSearchByImage"}, method={RequestMethod.POST})
    public ContentResponse<String, FaceSearchRespond> faceSearchByImage(@RequestBody ParamBean<FaceSearchRequest> obj) {
        FaceSearchRespond config = ((PictureSearchService)this.getServer(obj.getVcmInfo())).faceSearchByImage(obj);
        return ResultHelper.success((Object)config);
    }

    @ApiOperation(value="\u56de\u5934\u5ba2 NVR800\u63a5\u53e3")
    @RequestMapping(value={"/getReturnFace"}, method={RequestMethod.POST})
    public ContentResponse<String, JSONArray> getReturnFace(@RequestBody ParamBean<FaceSearchRequest> obj) {
        JSONArray config = ((PictureSearchService)this.getServer(obj.getVcmInfo())).getReturnFace(obj);
        return ResultHelper.success((Object)config);
    }

    @ApiOperation(value="\u56de\u5934\u5ba2\u603b\u6570 NVR800\u63a5\u53e3")
    @RequestMapping(value={"/getFaceSearchCount"}, method={RequestMethod.POST})
    public ContentResponse<String, JSONArray> getFaceSearchCount(@RequestBody ParamBean<FaceSearchRequest> obj) {
        JSONArray config = ((PictureSearchService)this.getServer(obj.getVcmInfo())).getFaceSearchCount(obj);
        return ResultHelper.success((Object)config);
    }

    @ApiOperation(value="\u56de\u5934\u5ba2 NVR800\u63a5\u53e3")
    @RequestMapping(value={"/getFilterSnapedFace"}, method={RequestMethod.POST})
    public ContentResponse<String, JSONArray> getFilterSnapedFace(@RequestBody ParamBean<FaceSearchRequest> obj) {
        JSONArray config = ((PictureSearchService)this.getServer(obj.getVcmInfo())).getFilterSnapedFace(obj);
        return ResultHelper.success((Object)config);
    }

    @ApiOperation(value="\u56de\u5934\u5ba2 NVR800\u63a5\u53e3")
    @RequestMapping(value={"/getSnapedFacesById"}, method={RequestMethod.POST})
    public ContentResponse<String, JSONArray> getSnapedFacesById(@RequestBody ParamBean<FaceSearchRequest> obj) {
        JSONArray config = ((PictureSearchService)this.getServer(obj.getVcmInfo())).getSnapedFacesById(obj);
        return ResultHelper.success((Object)config);
    }

    @ApiOperation(value="\u8eab\u4efd\u786e\u8ba4\u6bd4\u5bf9 IVS1800\u63a5\u53e3")
    @RequestMapping(value={"/getPerInfoByBase64"}, method={RequestMethod.POST})
    public ContentResponse<String, JSONObject> getPerInfoByBase64(@RequestBody ParamBean<PerInfoSearchRequest> obj) {
        JSONObject result = ((PictureSearchService)this.getServer(obj.getVcmInfo())).getPerInfoByBase64(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u4eba\u4f53\u68c0\u7d22\u56fe\u7247")
    @RequestMapping(value={"/getHumanSearch"}, method={RequestMethod.POST})
    public ContentResponse<String, HumanSearchRespond> getHumanDynamicRetrieval(@RequestBody ParamBean<HumanSearchRequest> obj) {
        if (!CollectionUtils.isEmpty((Collection)obj.getVcmInfos())) {
            ArrayList<CompletableFuture<List>> futureList = new ArrayList<CompletableFuture<List>>();
            HumanSearchRespond respond = new HumanSearchRespond();
            HumanSearchRequest request = (HumanSearchRequest)obj.getRequestBody();
            for (VcmReqBaseInfo vcmInfo : obj.getVcmInfos()) {
                CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> {
                    try {
                        ParamBean paramBean = new ParamBean();
                        HumanSearchRequest humanSearchRequest = new HumanSearchRequest();
                        BeanUtils.copyProperties((Object)request, (Object)humanSearchRequest);
                        humanSearchRequest.setCameraList(humanSearchRequest.getChannelCode().getJSONArray(vcmInfo.getDomainCode()).toJavaList(String.class));
                        paramBean.setVcmInfo(vcmInfo);
                        paramBean.setRequestBody((Object)humanSearchRequest);
                        HumanSearchRespond result = ((PictureSearchService)this.getServer(vcmInfo)).humanDynamicRetrieval(paramBean);
                        return result.getPeoplepass();
                    }
                    catch (Exception e) {
                        LOGGER.error("CompletableFuture get human search error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
                        return new ArrayList();
                    }
                });
                futureList.add(future);
            }
            ArrayList passInfoList = new ArrayList();
            CompletionStage allFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).whenComplete((v, t) -> futureList.forEach(temp -> {
                PictureSearchController pictureSearchController = this;
                synchronized (pictureSearchController) {
                    passInfoList.addAll(temp.getNow(null));
                }
            }));
            try {
                ((CompletableFuture)allFuture).get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("human complex CompletableFuture get error", (Throwable)e);
            }
            List resultList = passInfoList.stream().sorted((o1, o2) -> {
                LocalDateTime time2;
                LocalDateTime time1 = LocalDateTime.ofEpochSecond(Long.parseLong(o1.getRecordTime()), 0, OffsetDateTime.now().getOffset());
                if (time1.isAfter(time2 = LocalDateTime.ofEpochSecond(Long.parseLong(o2.getRecordTime()), 0, OffsetDateTime.now().getOffset()))) {
                    return -1;
                }
                if (time1.isBefore(time2)) {
                    return 1;
                }
                return 0;
            }).collect(Collectors.toList());
            LOGGER.info("human complex result size:" + resultList.size());
            if (resultList.size() > ((HumanSearchRequest)obj.getRequestBody()).getSearchCount()) {
                respond.setPeoplepass(resultList.subList(0, ((HumanSearchRequest)obj.getRequestBody()).getSearchCount()));
            } else {
                respond.setPeoplepass(resultList);
            }
            respond.setTotal(Integer.valueOf(respond.getPeoplepass().size()));
            return ResultHelper.success((Object)respond);
        }
        HumanSearchRespond result = ((PictureSearchService)this.getServer(obj.getVcmInfo())).humanDynamicRetrieval(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u4eba\u8138\u6bd4\u5bf91\uff1a1 IVS1800\u63a5\u53e3")
    @RequestMapping(value={"/getFaceToFace"}, method={RequestMethod.POST})
    public ContentResponse<String, JSONObject> getFaceToFace(@RequestBody ParamBean<FaceSearchRequest> obj) {
        JSONObject result = ((PictureSearchService)this.getServer(obj.getVcmInfo())).getFaceToFace(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u6b64\u63a5\u53e3\u7528\u4e8e\u8f66\u8f86\u7684\u6570\u636e\u5b57\u5178\u67e5\u8be2 IVS1800\u63a5\u53e3")
    @RequestMapping(value={"/getVehicleData"}, method={RequestMethod.POST})
    public ContentResponse<String, DataDictionaryRespond> getVehicleData(@RequestBody ParamBean<DataDictionaryRequest> obj) {
        DataDictionaryRespond result = ((PictureSearchService)this.getServer(obj.getVcmInfo())).getVehicleData(obj);
        return ResultHelper.success((Object)result);
    }

    public PictureSearchService<?> getIvs3800Server() {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public PictureSearchService<IServerType.IVS1800> getIvs1800Server() {
        return this.pictureSearchIvs1800Service;
    }

    public PictureSearchService<IServerType.NVR800> getNvr800Server() {
        return this.pictureSearchNvr800Service;
    }
}

