/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v1;

import com.zkteco.zkbiosecurity.cuserver.aspect.IcsCheck;
import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.FaceInfoRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.FaceRepositoryRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.PeopleRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceInfoSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepositoryRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepositorySearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.PeopleSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.FaceRepositoryManagementService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SdcServiceType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u4eba\u8138\u5e93\u7ba1\u7406"})
@Controller
@RequestMapping(value={"/rest/ics/v1/zk/faceRepository"})
public class FaceRepositoryController
implements BaseController<FaceRepositoryManagementService<?>> {
    @Autowired
    private FaceRepositoryManagementService<IServerType.IVS1800> faceRepositoryManagementIvs1800Service;
    @Autowired
    private FaceRepositoryManagementService<IServerType.NVR800> faceRepositoryManagementNvr800Service;
    @Autowired
    private Set<FaceRepositoryManagementService<IServerType.SDC>> faceRepositoryManagementSdcServiceSet;

    @ApiOperation(value="\u65b0\u589e\u4eba\u8138\u5e93")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @ResponseBody
    public ContentResponse<String, FaceRepositoryRespond> addFaceRepository(@RequestBody ParamBean<FaceRepositoryRequest> obj) {
        return ResultHelper.success((Object)new FaceRepositoryRespond(obj.getVcmInfo().getVcmIp(), ((FaceRepositoryManagementService)this.getServer(obj.getVcmInfo())).add(obj.getVcmInfo(), (FaceRepositoryRequest)obj.getRequestBody())));
    }

    @ApiOperation(value="\u5220\u9664\u4eba\u8138\u5e93")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public ContentResponse<String, FaceRepositoryRespond> deleteFaceRepository(@RequestBody ParamBean<FaceRepositoryRequest> obj) {
        return ResultHelper.success((Object)new FaceRepositoryRespond(obj.getVcmInfo().getVcmIp(), ((FaceRepositoryManagementService)this.getServer(obj.getVcmInfo())).delete(obj.getVcmInfo(), (FaceRepositoryRequest)obj.getRequestBody())));
    }

    @ApiOperation(value="\u66f4\u65b0\u4eba\u8138\u5e93")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    @ResponseBody
    @IcsCheck
    public ContentResponse<String, FaceRepositoryRespond> updateFaceRepository(@RequestBody ParamBean<FaceRepositoryRequest> obj) {
        return ResultHelper.success((Object)new FaceRepositoryRespond(obj.getVcmInfo().getVcmIp(), ((FaceRepositoryManagementService)this.getServer(obj.getVcmInfo())).update(obj.getVcmInfo(), (FaceRepositoryRequest)obj.getRequestBody())));
    }

    @ApiOperation(value="\u67e5\u8be2\u4eba\u8138\u5e93")
    @RequestMapping(value={"/search"}, method={RequestMethod.POST})
    @ResponseBody
    public ContentResponse<String, FaceRepositorySearchRespond> searchFaceRepository(@RequestBody ParamBean<FaceRepositoryRequest> obj) {
        return ResultHelper.success((Object)((FaceRepositoryManagementService)this.getServer(obj.getVcmInfo())).search(obj.getVcmInfo(), (FaceRepositoryRequest)obj.getRequestBody()));
    }

    @ApiOperation(value="\u65b0\u589e\u4eba\u5458")
    @RequestMapping(value={"/people/add"}, method={RequestMethod.POST})
    @ResponseBody
    public ContentResponse<String, FaceRepositoryRespond> addPeople(@RequestBody ParamBean<PeopleRequest> obj) {
        boolean success = true;
        String errorCode = null;
        try {
            success = ((FaceRepositoryManagementService)this.getServer(obj.getVcmInfo())).addPeople(obj.getVcmInfo(), (PeopleRequest)obj.getRequestBody());
        }
        catch (InvokeException exception) {
            errorCode = exception.getMessage();
            if (!"cu_face_repeat".equals(errorCode)) {
                throw exception;
            }
            success = false;
        }
        FaceRepositoryRespond faceRepositoryRespond = new FaceRepositoryRespond();
        faceRepositoryRespond.setIp(obj.getVcmInfo().getVcmIp());
        faceRepositoryRespond.setSuccess(true);
        if (StringUtils.isNotEmpty((CharSequence)errorCode)) {
            faceRepositoryRespond.setErrorCode(errorCode);
        } else {
            faceRepositoryRespond.setErrorCode("");
        }
        return ResultHelper.success((Object)faceRepositoryRespond);
    }

    @ApiOperation(value="\u5220\u9664\u4eba\u5458")
    @RequestMapping(value={"/people/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public ContentResponse<String, FaceRepositoryRespond> deletePeople(@RequestBody ParamBean<PeopleRequest> obj) {
        return ResultHelper.success((Object)new FaceRepositoryRespond(obj.getVcmInfo().getVcmIp(), ((FaceRepositoryManagementService)this.getServer(obj.getVcmInfo())).deletePeople(obj.getVcmInfo(), (PeopleRequest)obj.getRequestBody())));
    }

    @ApiOperation(value="\u66f4\u65b0\u4eba\u5458\u4fe1\u606f")
    @RequestMapping(value={"/people/update"}, method={RequestMethod.POST})
    @ResponseBody
    public ContentResponse<String, FaceRepositoryRespond> updatePeople(@RequestBody ParamBean<PeopleRequest> obj) {
        return ResultHelper.success((Object)new FaceRepositoryRespond(obj.getVcmInfo().getVcmIp(), ((FaceRepositoryManagementService)this.getServer(obj.getVcmInfo())).updatePeople(obj.getVcmInfo(), (PeopleRequest)obj.getRequestBody())));
    }

    @ApiOperation(value="\u67e5\u8be2\u4eba\u5458\u4fe1\u606f")
    @RequestMapping(value={"/people/search"}, method={RequestMethod.POST})
    @ResponseBody
    public ContentResponse<String, PeopleSearchRespond> searchPeople(@RequestBody ParamBean<PeopleRequest> obj) {
        return ResultHelper.success((Object)((FaceRepositoryManagementService)this.getServer(obj.getVcmInfo())).searchPeople(obj.getVcmInfo(), (PeopleRequest)obj.getRequestBody()));
    }

    @ApiOperation(value="\u6279\u91cf\u66f4\u6539\u4eba\u5458\u6240\u5c5e\u4eba\u8138\u5e93")
    @RequestMapping(value={"/update/repository/people/batch"}, method={RequestMethod.POST})
    @ResponseBody
    public ContentResponse<String, FaceRepositoryRespond> peopleUpdateBatch(@RequestBody ParamBean<PeopleRequest> obj) {
        return ResultHelper.success((Object)new FaceRepositoryRespond(obj.getVcmInfo().getVcmIp(), ((FaceRepositoryManagementService)this.getServer(obj.getVcmInfo())).repositoryUpdatePeopleBatch(obj.getVcmInfo(), (PeopleRequest)obj.getRequestBody())));
    }

    @ApiOperation(value="\u5e74\u9f84\u62a5\u8868\u6570\u636e\u641c\u7d22")
    @RequestMapping(value={"/people/faceReport"}, method={RequestMethod.POST})
    @ResponseBody
    public ContentResponse<String, FaceInfoSearchRespond> faceReport(@RequestBody ParamBean<FaceInfoRequest> obj) {
        return ResultHelper.success((Object)((FaceRepositoryManagementService)this.getServer(obj.getVcmInfo())).faceReportDataSearch(obj.getVcmInfo(), (FaceInfoRequest)obj.getRequestBody()));
    }

    @ApiOperation(value="\u76ee\u6807\u62a5\u8868\u7edf\u8ba1\u4fe1\u606f\u641c\u7d22")
    @RequestMapping(value={"/people/faceStatistics"}, method={RequestMethod.POST})
    @ResponseBody
    public ContentResponse<String, FaceInfoSearchRespond> faceStatistics(@RequestBody ParamBean<FaceInfoRequest> obj) {
        return ResultHelper.success((Object)((FaceRepositoryManagementService)this.getServer(obj.getVcmInfo())).faceStatisticalInfoSearch(obj.getVcmInfo(), (FaceInfoRequest)obj.getRequestBody()));
    }

    @ApiOperation(value="\u673a\u975e\u4eba\u7edf\u8ba1\u4fe1\u606f\u641c\u7d22")
    @RequestMapping(value={"/people/machineSearch"}, method={RequestMethod.POST})
    @ResponseBody
    public ContentResponse<String, FaceInfoSearchRespond> machineInfoSearch(@RequestBody ParamBean<FaceInfoRequest> obj) {
        return ResultHelper.success((Object)((FaceRepositoryManagementService)this.getServer(obj.getVcmInfo())).machineInfoSearch(obj.getVcmInfo(), (FaceInfoRequest)obj.getRequestBody()));
    }

    @RequestMapping(value={"/faceImage/get"}, method={RequestMethod.POST})
    @ResponseBody
    public ContentResponse<String, FaceRepositoryRespond> getFaceImage(@RequestBody ParamBean<PeopleRequest> obj) {
        return ResultHelper.success((Object)new FaceRepositoryRespond(obj.getVcmInfo().getVcmIp(), ((FaceRepositoryManagementService)this.getServer(obj.getVcmInfo())).getFaceImage(obj.getVcmInfo(), (PeopleRequest)obj.getRequestBody())));
    }

    @RequestMapping(value={"/face/import"}, method={RequestMethod.POST})
    @ResponseBody
    public ContentResponse<String, FaceRepositoryRespond> replicateLibrary(@RequestBody ParamBean<PeopleRequest> obj) {
        return ResultHelper.success((Object)new FaceRepositoryRespond(obj.getVcmInfo().getVcmIp(), ((FaceRepositoryManagementService)this.getServer(obj.getVcmInfo())).replicateLibrary(obj.getVcmInfo(), (PeopleRequest)obj.getRequestBody())));
    }

    public FaceRepositoryManagementService<?> getIvs3800Server() {
        throw new UnsupportedOperationException("IVS3800");
    }

    public FaceRepositoryManagementService<?> getIvs1800Server() {
        return this.faceRepositoryManagementIvs1800Service;
    }

    public FaceRepositoryManagementService<?> getNvr800Server() {
        return this.faceRepositoryManagementNvr800Service;
    }

    public FaceRepositoryManagementService<?> getSdcServer(int implType) {
        for (FaceRepositoryManagementService faceRepositoryManagementService : this.faceRepositoryManagementSdcServiceSet) {
            SdcServiceType sdkType = AopUtils.getTargetClass((Object)faceRepositoryManagementService).getAnnotation(SdcServiceType.class);
            if (sdkType == null || sdkType.value() != implType) continue;
            return faceRepositoryManagementService;
        }
        return null;
    }
}

