/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v1;

import com.zkteco.zkbiosecurity.cuserver.api.v1.FaceRepositoryController;
import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.ColorConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.DateTimeRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.OsdConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.zknvr.ZkNvrConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.deviceconfig.ColorConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.deviceconfig.DateTimeRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.deviceconfig.OsdConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.zknvr.ZkNvrConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.DeviceInfoConfigService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e3b\u8bbe\u5907\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/rest/ics/v1/zk/setting"})
public class DeviceInfoConfigController
implements BaseController<DeviceInfoConfigService<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FaceRepositoryController.class);
    @Autowired
    private DeviceInfoConfigService<IServerType.NVR800> deviceInfoConfigNvr800Service;
    @Autowired
    private DeviceInfoConfigService<IServerType.IVS1800> deviceInfoConfigIvs1800Service;
    @Autowired
    private DeviceInfoConfigService<IServerType.ZKNVR> deviceInfoConfigZKNvrService;
    @Autowired
    private DeviceInfoConfigService<IServerType.ZKIPC> deviceInfoConfigZKIpcService;

    @ApiOperation(value="\u83b7\u53d6\u4e3b\u8bbe\u5907\u65f6\u95f4\u914d\u7f6e \u4ec5NVR800")
    @RequestMapping(value={"/device/time/get"}, method={RequestMethod.POST})
    public ContentResponse<String, DateTimeRespond> getTimeConfig(@RequestBody ParamBean<EmptyRequest> obj) {
        DateTimeRespond config = ((DeviceInfoConfigService)this.getServer(obj.getVcmInfo())).getTimeConfig(obj);
        return ResultHelper.success((Object)config);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u8bbe\u5907\u65f6\u95f4\u914d\u7f6e \u4ec5NVR800")
    @RequestMapping(value={"/device/time/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setTimeConfig(@RequestBody ParamBean<DateTimeRequest> obj) {
        boolean flag = ((DeviceInfoConfigService)this.getServer(obj.getVcmInfo())).setTimeConfig(obj);
        return ResultHelper.success((Object)flag);
    }

    @ApiOperation(value="\u83b7\u53d6\u901a\u9053OSD\u914d\u7f6e")
    @RequestMapping(value={"/camera/osd/get"}, method={RequestMethod.POST})
    public ContentResponse<String, OsdConfigRespond> getOsdConfig(@RequestBody ParamBean<OsdConfigRequest> obj) {
        OsdConfigRespond config = ((DeviceInfoConfigService)this.getServer(obj.getVcmInfo())).getOsdConfig(obj);
        return ResultHelper.success((Object)config);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u901a\u9053OSD\u914d\u7f6e")
    @RequestMapping(value={"/camera/osd/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setOsdConfig(@RequestBody ParamBean<OsdConfigRequest> obj) {
        boolean isSuccess = ((DeviceInfoConfigService)this.getServer(obj.getVcmInfo())).setOsdConfig(obj);
        return ResultHelper.success((Object)isSuccess);
    }

    @ApiOperation(value="\u83b7\u53d6\u901a\u9053IPC\u989c\u8272\u914d\u7f6e")
    @RequestMapping(value={"/camera/color/get"}, method={RequestMethod.POST})
    public ContentResponse<String, ColorConfigRespond> getColorConfig(@RequestBody ParamBean<ColorConfigRequest> obj) {
        ColorConfigRespond config = ((DeviceInfoConfigService)this.getServer(obj.getVcmInfo())).getColorConfig(obj);
        return ResultHelper.success((Object)config);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u901a\u9053\u989c\u8272\u914d\u7f6e")
    @RequestMapping(value={"/camera/color/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setColorConfig(@RequestBody ParamBean<ColorConfigRequest> obj) {
        boolean isSuccess = ((DeviceInfoConfigService)this.getServer(obj.getVcmInfo())).setColorConfig(obj);
        return ResultHelper.success((Object)isSuccess);
    }

    @ApiOperation(value="\u53d6zk nvr \u914d\u7f6e\u53c2\u6570--(zknvr\u7c7b\u578b\u8bbe\u5907\u4e13\u7528\u63a5\u53e3)")
    @RequestMapping(value={"/camera/config/get"}, method={RequestMethod.POST})
    public ContentResponse<String, ZkNvrConfigRespond> getZkNvrSettingParam(@RequestBody ParamBean<ZkNvrConfigRequest> obj) {
        ZkNvrConfigRespond zkNvrConfigRespond = ((DeviceInfoConfigService)this.getServer(obj.getVcmInfo())).getZkNvrConfig(obj);
        return ResultHelper.success((Object)zkNvrConfigRespond);
    }

    @ApiOperation(value="\u8bbe\u7f6ezk nvr \u914d\u7f6e\u53c2\u6570--(zknvr\u7c7b\u578b\u8bbe\u5907\u4e13\u7528\u63a5\u53e3)")
    @RequestMapping(value={"/camera/config/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> getChannelConfig(@RequestBody ParamBean<ZkNvrConfigRequest> obj) {
        boolean isSuccess = ((DeviceInfoConfigService)this.getServer(obj.getVcmInfo())).setZkNvrConfig(obj);
        return ResultHelper.success((Object)isSuccess);
    }

    public DeviceInfoConfigService<IServerType.IVS3800> getIvs3800Server() {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public DeviceInfoConfigService<IServerType.IVS1800> getIvs1800Server() {
        return this.deviceInfoConfigIvs1800Service;
    }

    public DeviceInfoConfigService<IServerType.NVR800> getNvr800Server() {
        return this.deviceInfoConfigNvr800Service;
    }

    public DeviceInfoConfigService<IServerType.ZKNVR> getZKNVRServer() {
        return this.deviceInfoConfigZKNvrService;
    }

    public DeviceInfoConfigService<IServerType.ZKIPC> getZKIPCServer() {
        return this.deviceInfoConfigZKIpcService;
    }
}

