/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v1;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.config.ConfigHolder;
import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.AlarmSourceRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraAddRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRebootRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRemoveRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraValidRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelUpdateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.MasterDeviceSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.InitPasswordUpdateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.PasswordUpdateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BaseEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.AlarmSourceRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraAddRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraAndChannelRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraThirdAlgorithmRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.ChannelRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CloudDeviceRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.DeviceEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.DeviceInfoRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.DeviceRouteRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.ParentDeviceStateRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.sdc.SdcDeviceRespond;
import com.zkteco.zkbiosecurity.cuserver.enums.EventTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.DeviceManageService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.WebSocketService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.sdc.config.SdcServiceType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8bbe\u5907\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/rest/ics/v1/zk/device"})
public class DeviceController
implements BaseController<DeviceManageService<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceController.class);
    @Autowired
    private DeviceManageService<IServerType.IVS1800> deviceManageIvs1800Service;
    @Autowired
    private DeviceManageService<IServerType.NVR800> deviceManageNvr800Service;
    @Autowired
    private DeviceManageService<IServerType.Cloud> deviceManageCloudService;
    @Autowired
    private Set<DeviceManageService<IServerType.SDC>> deviceManageSdcServiceSet;
    @Autowired
    private DeviceManageService<IServerType.ZKNVR> deviceManageZKNvrService;
    @Autowired
    private DeviceManageService<IServerType.Tiandy> deviceManageTIANDYService;
    @Autowired
    private DeviceManageService<IServerType.HIKVISION> deviceManageHIKVISIONService;
    @Autowired
    private WebSocketService webSocketService;
    @Autowired
    private DeviceManageService<IServerType.Onvif> onvifDeviceManageService;
    @Autowired
    private DeviceManageService<IServerType.ZKIPC> deviceManageZKIpcService;
    @Autowired
    private DeviceManageService<IServerType.DHNVR> deviceManageDHNvrService;

    @ApiOperation(value="\u83b7\u53d6\u4e3b\u8bbe\u5907\u7684\u5168\u90e8\u6444\u50cf\u673a\u5bf9\u5e94\u901a\u9053\u7684\u8be6\u60c5\u5217\u8868")
    @RequestMapping(value={"/camerasAndChannels"}, method={RequestMethod.POST})
    public ContentResponse<String, CameraAndChannelRespond> listCamerasAndChannels(@RequestBody ParamBean<EmptyRequest> obj) {
        CameraAndChannelRespond respondList = ((DeviceManageService)this.getServer(obj.getVcmInfo())).listCamerasAndChannels(obj.getVcmInfo());
        return ResultHelper.success((Object)respondList);
    }

    @ApiOperation(value="")
    @RequestMapping(value={"/cameras"}, method={RequestMethod.POST})
    public ContentResponse<String, List<CameraRespond>> listCameras(@RequestBody ParamBean<EmptyRequest> obj) {
        List respondList = ((DeviceManageService)this.getServer(obj.getVcmInfo())).listCamera(obj.getVcmInfo());
        return ResultHelper.success((Object)respondList);
    }

    @ApiOperation(value="\u83b7\u53d6\u6444\u50cf\u673a\u7684\u8be6\u60c5 code:\u8bbe\u5907\u7f16\u7801")
    @RequestMapping(value={"/cameras/{code}"}, method={RequestMethod.POST})
    public ContentResponse<String, CameraRespond> listCameras(@RequestBody ParamBean<EmptyRequest> obj, @PathVariable String code) {
        List respondList = ((DeviceManageService)this.getServer(obj.getVcmInfo())).listCamera(obj.getVcmInfo());
        for (CameraRespond cameraRespond : respondList) {
            if (!code.equals(cameraRespond.getCameraCode())) continue;
            return ResultHelper.success((Object)cameraRespond);
        }
        throw new InvokeException("500", "object_not_exist");
    }

    @ApiOperation(value="\u83b7\u53d6\u6444\u50cf\u673a\u7684\u5168\u90e8\u901a\u9053\u8be6\u60c5 cameraCode:\u8bbe\u5907\u7f16\u7801")
    @RequestMapping(value={"/cameras/{cameraCode}/channels"}, method={RequestMethod.POST})
    public ContentResponse<String, List<ChannelRespond>> listChannelByCamera(@RequestBody ParamBean<EmptyRequest> obj, @PathVariable String cameraCode) {
        List respondList = ((DeviceManageService)this.getServer(obj.getVcmInfo())).listChannelsByCamera(obj.getVcmInfo(), cameraCode);
        return ResultHelper.success((Object)respondList);
    }

    @ApiOperation(value="")
    @RequestMapping(value={"/channels"}, method={RequestMethod.POST})
    public ContentResponse<String, List<ChannelRespond>> listChannels(@RequestBody ParamBean<EmptyRequest> obj) {
        List respondList = ((DeviceManageService)this.getServer(obj.getVcmInfo())).listChannel(obj.getVcmInfo());
        return ResultHelper.success((Object)respondList);
    }

    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8\u901a\u9053\u7684\u8be6\u60c5\u5217\u8868")
    @RequestMapping(value={"/channels/get"}, method={RequestMethod.POST})
    public ContentResponse<String, ChannelRespond> getChannel(@RequestBody ParamBean<ChannelRequest> obj) {
        ChannelRespond channelRespond = ((DeviceManageService)this.getServer(obj.getVcmInfo())).getChannel(obj);
        return ResultHelper.success((Object)channelRespond);
    }

    @ApiOperation(value="NVR800 \u67e5\u8be2\u7a7a\u901a\u9053\u63a5\u53e3")
    @RequestMapping(value={"/channels/getEmptyChannel"}, method={RequestMethod.POST})
    public ContentResponse<String, List<String>> getEmptyChannel(@RequestBody ParamBean<EmptyRequest> obj) {
        List channelCodeList = ((DeviceManageService)this.getServer(obj.getVcmInfo())).getEmptyChannel(obj);
        return ResultHelper.success((Object)channelCodeList);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u901a\u9053\u540d\u79f0")
    @RequestMapping(value={"/channels/set"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> setChannel(@RequestBody ParamBean<ChannelUpdateRequest> obj) {
        boolean result = ((DeviceManageService)this.getServer(obj.getVcmInfo())).updateChannel(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u6dfb\u52a0\u6444\u50cf\u673a")
    @RequestMapping(value={"/cameras/add"}, method={RequestMethod.POST})
    public ContentResponse<String, CameraAddRespond> addCamera(@RequestBody ParamBean<CameraAddRequest> obj) {
        CameraAddRespond cameraAddRespond = ((DeviceManageService)this.getServer(obj.getVcmInfo())).addCamera(obj);
        return ResultHelper.success((Object)cameraAddRespond);
    }

    @ApiOperation(value="\u5220\u9664\u6444\u50cf\u673a")
    @RequestMapping(value={"/cameras/remove"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> removeCamera(@RequestBody ParamBean<CameraRemoveRequest> obj) {
        boolean success = ((DeviceManageService)this.getServer(obj.getVcmInfo())).removeCamera(obj);
        return ResultHelper.success((Object)success);
    }

    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801")
    @RequestMapping(value={"/cameras/password"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> updatePassword(@RequestBody ParamBean<PasswordUpdateRequest> obj) {
        boolean result = ((DeviceManageService)this.getServer(obj.getVcmInfo())).updatePassword(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u66f4\u65b0\u79bb\u7ebf\u6444\u50cf\u673a\u5bc6\u7801")
    @PostMapping(value={"/cameras/updateOfflinePassword"})
    public ContentResponse<String, Boolean> updateOfflinePassword(@RequestBody ParamBean<CameraAddRequest> obj) {
        boolean result = ((DeviceManageService)this.getServer(obj.getVcmInfo())).updateOfflinePassword(obj);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u91cd\u542f\u6444\u50cf\u673a")
    @RequestMapping(value={"/cameras/reboot"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> rebootCamera(@RequestBody ParamBean<CameraRebootRequest> obj) {
        boolean success = ((DeviceManageService)this.getServer(obj.getVcmInfo())).rebootCamera(obj);
        return ResultHelper.success((Object)success);
    }

    @ApiOperation(value="\u4e91\u670d\u52a1\u63a5\u53e3  \u83b7\u53d6\u4e91\u7aef\u5168\u90e8\u8bbe\u5907(\u4e3b\u8bbe\u5907-\u8bbe\u5907-\u901a\u9053)")
    @RequestMapping(value={"/cloudDevice/get"}, method={RequestMethod.POST})
    public ContentResponse<String, CloudDeviceRespond> getCloudDevice(@RequestBody ParamBean<EmptyRequest> obj) {
        CloudDeviceRespond cloudDevice = ((DeviceManageService)this.getServer(obj.getVcmInfo())).getCloudDevice(obj.getVcmInfo());
        return ResultHelper.success((Object)cloudDevice);
    }

    @ApiOperation(value="\u83b7\u53d6SDC\u8bbe\u5907\u8be6\u60c5")
    @RequestMapping(value={"/sdc/get"}, method={RequestMethod.POST})
    public ContentResponse<String, SdcDeviceRespond> getSdcDevice(@RequestBody ParamBean<EmptyRequest> obj) {
        SdcDeviceRespond sdcDevice = ((DeviceManageService)this.getServer(obj.getVcmInfo())).getSdcDevice(obj.getVcmInfo());
        return ResultHelper.success((Object)sdcDevice);
    }

    @ApiOperation(value="\u641c\u7d22\u6444\u50cf\u673a \u8fd4\u56de\u7a7a\u5217\u8868\u3002\u7531websocket\u63a8\u9001\u6570\u636e")
    @RequestMapping(value={"/cameras/search"}, method={RequestMethod.POST})
    public ContentResponse<String, List<CameraSearchRespond>> searchCamera(@RequestBody ParamBean<CameraSearchRequest> obj) {
        List cameraList = ((DeviceManageService)this.getServer(obj.getVcmInfo())).searchCamera(obj.getVcmInfo(), (CameraSearchRequest)obj.getRequestBody());
        return ResultHelper.success((Object)cameraList);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e3b\u8bbe\u5907\u8def\u7531\u4fe1\u606f")
    @RequestMapping(value={"/device/getDomainCode"}, method={RequestMethod.POST})
    public ContentResponse<String, List<DeviceRouteRespond>> getDeviceRoute(@RequestBody ParamBean<EmptyRequest> obj) {
        List respondList = ((DeviceManageService)this.getServer(obj.getVcmInfo())).getDeviceRoute(obj.getVcmInfo());
        return ResultHelper.success((Object)respondList);
    }

    @ApiOperation(value="\u9a8c\u8bc1\u6444\u50cf\u673a \u4ec5IVS1800\u652f\u6301")
    @RequestMapping(value={"/cameras/valid"}, method={RequestMethod.POST})
    public ContentResponse<String, CameraSearchRespond> validCamera(@RequestBody ParamBean<CameraValidRequest> obj) {
        CameraSearchRespond respond = ((DeviceManageService)this.getServer(obj.getVcmInfo())).validCamera(obj.getVcmInfo(), (CameraValidRequest)obj.getRequestBody());
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u505c\u6b62\u641c\u7d22\u6444\u50cf\u673a")
    @RequestMapping(value={"/cameras/stopSearch"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> stopSearch(@RequestBody ParamBean<CameraValidRequest> obj) {
        Boolean result = ((DeviceManageService)this.getServer(obj.getVcmInfo())).stopSearch(obj.getVcmInfo(), (CameraValidRequest)obj.getRequestBody());
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e3b\u8bbe\u5907\u7248\u672c\u4fe1\u606f")
    @RequestMapping(value={"/device/getDeviceVersion"}, method={RequestMethod.POST})
    public ContentResponse<String, DeviceRouteRespond> getDeviceVersion(@RequestBody ParamBean<EmptyRequest> obj) {
        DeviceRouteRespond respondList = ((DeviceManageService)this.getServer(obj.getVcmInfo())).getDeviceVersion(obj.getVcmInfo());
        return ResultHelper.success((Object)respondList);
    }

    @ApiOperation(value="\u83b7\u53d6\u5b50\u8bbe\u5907\u5217\u8868-\u544a\u8b66\u6e90\u5217\u8868")
    @RequestMapping(value={"/device/getAlarmSource"}, method={RequestMethod.POST})
    public ContentResponse<String, List<AlarmSourceRespond>> getAlarmSource(@RequestBody ParamBean<AlarmSourceRequest> obj) {
        List respondList = ((DeviceManageService)this.getServer(obj.getVcmInfo())).getAlarmSource(obj);
        return ResultHelper.success((Object)respondList);
    }

    @ApiOperation(value="\u83b7\u53d6\u8bbe\u5907\u677f\u7aef\u62a5\u8b66\u8f93\u51fa\u8def\u6570 \u4ec5NVR800\u652f\u6301")
    @RequestMapping(value={"/device/getDeviceInfo"}, method={RequestMethod.POST})
    public ContentResponse<String, DeviceInfoRespond> getDeviceInfo(@RequestBody ParamBean<EmptyRequest> obj) {
        DeviceInfoRespond respondList = ((DeviceManageService)this.getServer(obj.getVcmInfo())).getLoginDeviceInfo(obj.getVcmInfo());
        return ResultHelper.success((Object)respondList);
    }

    @ApiOperation(value="\u641c\u7d22\u4e3b\u8bbe\u5907")
    @PostMapping(value={"/device/searchMasterDevice"})
    public ContentResponse<String, Boolean> searchMasterDevice(@RequestBody ParamBean<MasterDeviceSearchRequest> obj) {
        return this.searchDevice(obj, "searchMasterDevice");
    }

    @ApiOperation(value="\u641c\u7d22sdc\u8bbe\u5907")
    @PostMapping(value={"/device/searchSDCDevice"})
    public ContentResponse<String, Boolean> searchSDCDevice(@RequestBody ParamBean<MasterDeviceSearchRequest> obj) {
        return this.searchDevice(obj, "searchSdcDevice");
    }

    private ContentResponse<String, Boolean> searchDevice(ParamBean<MasterDeviceSearchRequest> obj, String searchSdcDevice) {
        if (ConfigHolder.getSearchMastDeviceFlag()) {
            return ResultHelper.success((Object)true);
        }
        CompletableFuture.runAsync(() -> {
            ConfigHolder.setSearchMastDeviceFlag((boolean)true);
            try {
                ArrayList<CompletableFuture<List>> futureList = new ArrayList<CompletableFuture<List>>();
                DeviceEventRespond respond = new DeviceEventRespond();
                respond.setSubtype(searchSdcDevice);
                respond.setType(EventTypeEnum.OPERATE_RESULT);
                for (Integer type : ((MasterDeviceSearchRequest)obj.getRequestBody()).getSearchType()) {
                    CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> {
                        VcmReqBaseInfo vcmInfo = new VcmReqBaseInfo();
                        vcmInfo.setVcmType(type);
                        return ((DeviceManageService)this.getServer(vcmInfo)).searchMasterDevice((MasterDeviceSearchRequest)obj.getRequestBody());
                    });
                    futureList.add(future);
                }
                ArrayList deviceRespondList = new ArrayList();
                CompletionStage allFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).whenComplete((v, t) -> futureList.forEach(temp -> {
                    DeviceController deviceController = this;
                    synchronized (deviceController) {
                        deviceRespondList.addAll(temp.getNow(null));
                    }
                }));
                try {
                    ((CompletableFuture)allFuture).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    LOGGER.error("search master device CompletableFuture get error", (Throwable)e);
                }
                respond.setPercent("100");
                respond.getData().setParentDevices(deviceRespondList);
                LOGGER.info("search master device data size:{}", (Object)deviceRespondList.size());
                this.webSocketService.send((BaseEventRespond)respond);
            }
            catch (Exception e) {
                LOGGER.error("search master device error", (Throwable)e);
            }
            finally {
                ConfigHolder.setSearchMastDeviceFlag((boolean)false);
            }
        });
        return ResultHelper.success((Object)true);
    }

    @ApiOperation(value="\u4fee\u6539\u6444\u50cf\u673a\u8bbe\u5907\u5bc6\u7801 \u4ec5IVS1800\u652f\u6301")
    @RequestMapping(value={"/device/modifyDevicePassword"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> modifyDevicePassword(@RequestBody ParamBean<InitPasswordUpdateRequest> obj) {
        boolean success = ((DeviceManageService)this.getServer(obj.getVcmInfo())).modifyDevicePassword(obj);
        return ResultHelper.success((Object)success);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e3b\u8bbe\u5907\u8d44\u6e90\u72b6\u6001")
    @PostMapping(value={"/getParentDeviceState"})
    public ContentResponse<String, List<ParentDeviceStateRespond>> getParentDeviceState(@RequestBody ParamBean<EmptyRequest> obj) {
        ArrayList respondList = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)obj.getVcmInfos())) {
            return ResultHelper.success(respondList);
        }
        ArrayList<CompletableFuture<ParentDeviceStateRespond>> futureList = new ArrayList<CompletableFuture<ParentDeviceStateRespond>>();
        for (VcmReqBaseInfo vcmReqBaseInfo : obj.getVcmInfos()) {
            CompletableFuture<ParentDeviceStateRespond> future = CompletableFuture.supplyAsync(() -> ((DeviceManageService)this.getServer(vcmReqBaseInfo)).getParentDeviceState(vcmReqBaseInfo));
            futureList.add(future);
        }
        CompletionStage allFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).whenComplete((v, t) -> futureList.forEach(temp -> {
            DeviceController deviceController = this;
            synchronized (deviceController) {
                respondList.add(temp.getNow(null));
            }
        }));
        try {
            ((CompletableFuture)allFuture).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("get parent device error", (Throwable)e);
        }
        return ResultHelper.success(respondList);
    }

    @ApiOperation(value="\u4e91\u670d\u52a1\u63a5\u53e3 \u4f01\u4e1a\u7248\u4e2a\u4eba\u7248\u6574\u5408 \u83b7\u53d6\u8bbe\u5907\u901a\u9053\u4fe1\u606f")
    @RequestMapping(value={"/getCloudDeviceEnterprise"}, method={RequestMethod.POST})
    public ContentResponse<String, CloudDeviceRespond> getCloudDeviceEnterprise(@RequestBody ParamBean<EmptyRequest> obj) {
        CloudDeviceRespond cloudDevice = ((DeviceManageService)this.getServer(obj.getVcmInfo())).getCloudDeviceEnterprise(obj.getVcmInfo());
        return ResultHelper.success((Object)cloudDevice);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6444\u50cf\u673a")
    @RequestMapping(value={"/cameras/removes"}, method={RequestMethod.POST})
    public ContentResponse<String, JSONObject> removeCameras(@RequestBody ParamBean<CameraRemoveRequest> obj) {
        JSONObject success = ((DeviceManageService)this.getServer(obj.getVcmInfo())).removeCameras(obj);
        return ResultHelper.success((Object)success);
    }

    @ApiOperation(value="IVS1800 \u5f00\u542f\u81ea\u52a8\u6293\u62cd\u63a5\u53e3\u9002\u914d")
    @RequestMapping(value={"/autoCaptureSet"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> autoCaptureSet(@RequestBody ParamBean<EmptyRequest> obj) {
        Boolean success = ((DeviceManageService)this.getServer(obj.getVcmInfo())).autoCaptureSet(obj);
        return ResultHelper.success((Object)success);
    }

    @ApiOperation(value="\u83b7\u53d6\u6444\u50cf\u673a\u8bbe\u5907\u4fe1\u606f")
    @RequestMapping(value={"/getCameraInfo"}, method={RequestMethod.POST})
    public ContentResponse<String, DeviceInfoRespond> getCameraInfo(@RequestBody ParamBean<CameraRequest> obj) {
        DeviceInfoRespond respond = ((DeviceManageService)this.getServer(obj.getVcmInfo())).getCameraInfo(obj);
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u83b7\u53d6\u6444\u50cf\u673a\u7b2c\u4e09\u65b9\u7b97\u6cd5\u5217\u8868")
    @RequestMapping(value={"/getCameraThirdAlgorithm"}, method={RequestMethod.POST})
    public ContentResponse<String, List<CameraThirdAlgorithmRespond>> getCameraThirdAlgorithm(@RequestBody ParamBean<CameraRequest> obj) {
        List respondList = ((DeviceManageService)this.getServer(obj.getVcmInfo())).getCameraThirdAlgorithm(obj);
        return ResultHelper.success((Object)respondList);
    }

    @ApiOperation(value="nvr800 \u8bbe\u5907\u91cd\u542f")
    @RequestMapping(value={"/deviceReboot"}, method={RequestMethod.POST})
    public ContentResponse<String, Boolean> deviceReboot(@RequestBody ParamBean<CameraAddRequest> obj) {
        Boolean respond = ((DeviceManageService)this.getServer(obj.getVcmInfo())).DeviceReboot(obj);
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u83b7\u53d6\u7b2c\u4e09\u65b9\u7b97\u6cd5License\u72b6\u6001")
    @RequestMapping(value={"/getLicenseStatus"}, method={RequestMethod.POST})
    public ContentResponse<String, DeviceInfoRespond> getLicenseStatus(@RequestBody ParamBean<CameraRequest> obj) {
        DeviceInfoRespond respond = ((DeviceManageService)this.getServer(obj.getVcmInfo())).getLicenseStatus(obj);
        return ResultHelper.success((Object)respond);
    }

    public DeviceManageService<IServerType.IVS3800> getIvs3800Server() {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public DeviceManageService<IServerType.IVS1800> getIvs1800Server() {
        return this.deviceManageIvs1800Service;
    }

    public DeviceManageService<IServerType.NVR800> getNvr800Server() {
        return this.deviceManageNvr800Service;
    }

    public DeviceManageService<IServerType.ZKNVR> getZKNVRServer() {
        return this.deviceManageZKNvrService;
    }

    public DeviceManageService<IServerType.ZKIPC> getZKIPCServer() {
        return this.deviceManageZKIpcService;
    }

    public DeviceManageService<IServerType.Cloud> getCloudServer() {
        return this.deviceManageCloudService;
    }

    public DeviceManageService<IServerType.Tiandy> getTIANDYServer() {
        return this.deviceManageTIANDYService;
    }

    public DeviceManageService<IServerType.HIKVISION> getHIKVISIONServer() {
        return this.deviceManageHIKVISIONService;
    }

    public DeviceManageService<IServerType.DHNVR> getDHNVRServer() {
        return this.deviceManageDHNvrService;
    }

    public DeviceManageService<?> getSdcServer(int implType) {
        for (DeviceManageService deviceManageService : this.deviceManageSdcServiceSet) {
            SdcServiceType sdkType = AopUtils.getTargetClass((Object)deviceManageService).getAnnotation(SdcServiceType.class);
            if (sdkType == null || sdkType.value() != implType) continue;
            return deviceManageService;
        }
        return null;
    }

    public DeviceManageService<?> getOnvifServer() {
        return this.onvifDeviceManageService;
    }
}

