/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v1;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.CruiseRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.CruiseDetailRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.CruiseListRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.CruiseRespond;
import com.zkteco.zkbiosecurity.cuserver.service.CruiseService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5de1\u822a\u8f68\u8ff9"})
@RestController
@RequestMapping(value={"/rest/ics/v1/zk/cruise"})
public class CruiseController
implements BaseController<CruiseService<?>> {
    @Autowired
    private CruiseService<IServerType.IVS1800> cruiseIvs1800Service;
    @Autowired
    private CruiseService<IServerType.NVR800> cruiseNvr800Service;
    @Autowired
    private CruiseService<IServerType.SDC> cruiseSdcService;

    @ApiOperation(value="\u6dfb\u52a0\u5de1\u822a\u8f68\u8ff9")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ContentResponse<String, CruiseRespond> add(@RequestBody ParamBean<CruiseRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        CruiseRequest req = (CruiseRequest)obj.getRequestBody();
        CruiseRespond result = ((CruiseService)this.getServer(vcmInfo)).add(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u4fee\u6539\u5de1\u822a\u8f68\u8ff9")
    @RequestMapping(value={"/upt"}, method={RequestMethod.POST})
    public ContentResponse<String, CruiseRespond> upt(@RequestBody ParamBean<CruiseRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        CruiseRequest req = (CruiseRequest)obj.getRequestBody();
        CruiseRespond result = ((CruiseService)this.getServer(vcmInfo)).upt(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u5220\u9664\u5de1\u822a\u8f68\u8ff9")
    @RequestMapping(value={"/del"}, method={RequestMethod.POST})
    public ContentResponse<String, CruiseRespond> del(@RequestBody ParamBean<CruiseRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        CruiseRequest req = (CruiseRequest)obj.getRequestBody();
        CruiseRespond result = ((CruiseService)this.getServer(vcmInfo)).del(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u5de1\u822a\u8f68\u8ff9\u5217\u8868")
    @RequestMapping(value={"/list"}, method={RequestMethod.POST})
    public ContentResponse<String, CruiseListRespond> list(@RequestBody ParamBean<CruiseRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        CruiseRequest req = (CruiseRequest)obj.getRequestBody();
        CruiseListRespond result = ((CruiseService)this.getServer(vcmInfo)).list(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u5de1\u822a\u8f68\u8ff9\u8be6\u60c5")
    @RequestMapping(value={"/detail"}, method={RequestMethod.POST})
    public ContentResponse<String, CruiseDetailRespond> detail(@RequestBody ParamBean<CruiseRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        CruiseRequest req = (CruiseRequest)obj.getRequestBody();
        CruiseDetailRespond result = ((CruiseService)this.getServer(vcmInfo)).detail(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u5de1\u822a\u8f68\u8ff9No")
    @RequestMapping(value={"/getCruiseNo"}, method={RequestMethod.POST})
    public ContentResponse<String, JSONObject> getCruiseNo(@RequestBody ParamBean<CruiseRequest> obj) {
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        CruiseRequest req = (CruiseRequest)obj.getRequestBody();
        JSONObject result = ((CruiseService)this.getServer(vcmInfo)).getCruiseNo(vcmInfo, req);
        return ResultHelper.success((Object)result);
    }

    public CruiseService<IServerType.IVS3800> getIvs3800Server() {
        return null;
    }

    public CruiseService<IServerType.IVS1800> getIvs1800Server() {
        return this.cruiseIvs1800Service;
    }

    public CruiseService<IServerType.NVR800> getNvr800Server() {
        return this.cruiseNvr800Service;
    }

    public CruiseService<IServerType.SDC> getSdcServer() {
        return this.cruiseSdcService;
    }
}

