/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.api.v1;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.controller.BaseController;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.ResultHelper;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.common.ContentResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.common.CommonGetImageRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.CommonGetImageRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.vehicleRepository.VehicleImgUploadRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.service.CommonService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.cloud.CommonCloudServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.CommonIvs1800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.CommonNvr800ServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u56fe\u7247\u4e0b\u8f7d"})
@RestController
@RequestMapping(value={"/rest/ics/v1/zk/common"})
public class CommonController
implements BaseController<CommonService<?>> {
    @Autowired
    private CommonNvr800ServiceImpl commonNvr800Service;
    @Autowired
    private CommonIvs1800ServiceImpl commonIvs1800Service;
    @Autowired
    private CommonCloudServiceImpl commonCloudService;

    @ApiOperation(value="\u4e0b\u8f7d\u7167\u7247")
    @RequestMapping(value={"/getImage"}, method={RequestMethod.POST})
    public ContentResponse<String, CommonGetImageRespond> getImage(@RequestBody ParamBean<CommonGetImageRequest> obj) {
        CommonGetImageRespond respond = ((CommonService)this.getServer(obj.getVcmInfo())).getImage(obj);
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u6839\u636e\u6293\u62cduuid\u83b7\u53d6\u56fe\u7247")
    @RequestMapping(value={"/getCaptureByUUId"}, method={RequestMethod.POST})
    public ContentResponse<String, CommonGetImageRespond> getCaptureByUUId(@RequestBody ParamBean<CommonGetImageRequest> obj) {
        CommonGetImageRespond respond = ((CommonService)this.getServer(obj.getVcmInfo())).getCaptureByUUId(obj);
        return ResultHelper.success((Object)respond);
    }

    @ApiOperation(value="\u540d\u5355\u5e93\u56fe\u7247\u6587\u4ef6\u4e0a\u4f20(\u652f\u6301\u6279\u91cf)")
    @RequestMapping(value={"/imageUploadVehicle"})
    public ContentResponse<String, VehicleImgUploadRespond> imageUploadVehicle(@RequestParam(value="imgInput") MultipartFile[] images, @RequestParam(value="vcmInfo") String vcmInfo) {
        VcmReqBaseInfo vcmReqBaseInfo = (VcmReqBaseInfo)JSONObject.parseObject((String)vcmInfo).toJavaObject(VcmReqBaseInfo.class);
        VehicleImgUploadRespond respond = ((CommonService)this.getServer(vcmReqBaseInfo)).imageUploadVehicle(vcmReqBaseInfo, images);
        return ResultHelper.success((Object)respond);
    }

    public CommonService<?> getCloudServer() {
        return this.commonCloudService;
    }

    public CommonService<?> getIvs3800Server() {
        throw new InvokeException("500", "cu_device_not_support");
    }

    public CommonService<?> getIvs1800Server() {
        return this.commonIvs1800Service;
    }

    public CommonService<?> getNvr800Server() {
        return this.commonNvr800Service;
    }
}

